package com.arachnoid.satfinderandroid;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.hardware.GeomagneticField;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.provider.Settings;
import android.support.design.widget.TabLayout;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.menu.ActionMenuItemView;
import android.support.v7.widget.Toolbar;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SizeF;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Surface;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.CheckBox;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

import static android.content.pm.PackageManager.PERMISSION_GRANTED;

public class SatFinderAndroidActivity extends AppCompatActivity implements
        SensorEventListener {

    // change version only from the manifest file
    // static final boolean DEBUG = false;
    SatFinderAndroidApplication app;
    SatFinderAndroidActivity activity;
    //private static WeakReference<SatFinderAndroidActivity> wrActivity = null;
    LocationManager locationManager = null;
    LocationListener locationGPSListener = null;
    LocationListener locationNetworkListener = null;
    //TabHost tabHost;
    //TabWidget tabWidget;
    int lowestSelKey = 0;
    // special error indication: latitude = -100
    double latitude = -100, longitude = 0;
    boolean goodLocation = false;
    TextView posSource, latTV, lngTV, magDecTV, locationText, posQuality;
    RelativeLayout pointView;
    WebView helpWebView;
    ImageView compassImage;
    RelativeLayout skyViewTab;
    SatImageOverlay skyViewOverlay;

    BiQuadraticFilter sinBF, cosBF;

    android.support.v7.view.menu.ActionMenuItemView statusItem;
    ImageButton statusButton;
    RadioButton satsUS, satsInt;
    String strSource;
    int[] ledIconColors;
    final int STATUS_NO_FIX = 0;
    final int STATUS_OLD_FIX = 1;
    final int STATUS_NEW_FIX = 2;
    int posUpdateTimeInterval = 5000; // milliseconds
    int posUpdateDistanceInterval = 50; // meters
    String[] statusName = new String[]{"No Location", "Old Location",
            "Good Location"};
    ArrayList<SatDescription> satData = null;
    WebView webList = null;
    View locationFragment = null;
    double magDec = 0;
    double useMagDec = 0;
    private Handler handler;
    String pageHead = "<head><style type=\"text/css\">"
            + "body {font-family:Verdana, Tahoma, Helvetica, Arial;font-style:monospace;background-color:black;color:white}"
            + "table {border-collapse:collapse}"
            + "td {text-align:right;padding-left:8px}"
            + ".oddRow {background-color:#202020;}"
            + ".evenRow {background-color:black;}"
            + ".head {background-color:#002020;color:#c0c0ff}"
            + "#toprow {background-color:#002020}"
            + ".title {text-align:center;color:#c0c000}"
            + ".button {color:red;backgrond-color:red;border-color:red;scale:200%}"
            + ".selected {background-color:#800000}" + "</style></head>";

    private SensorManager mSensorManager;
    float sensorAzimuth = 0;
    float unitAzimuth = 0;
    float sensorPitch = 0;
    float sensorRoll = 0;
    Display defaultDisplay;
    int compass_xs = -1, compass_ys = -1;
    Bitmap compassBitmap = null;
    Path compassPath = null;

    static final int TAB_SETUP = 0;
    static final int TAB_SELECT = 1;
    static final int TAB_COMPASS = 2;
    static final int TAB_SKYVIEW = 3;
    static final int TAB_HELP = 4;
    int MY_GPS_REQ = 1234;

    float rToD = (float) (180 / Math.PI);
    float dToR = (float) (Math.PI / 180);

    boolean sensorsRegistered = false;

    int sensorSampleRate = 50; // milliseconds

    boolean fullScreen = false;
    boolean lightColorScheme = false;
    String declinationString = "";

    Sensor mRotationSensor = null;

    boolean badAccuracy = false;

    int cameraOrientation = 0;
    Camera2BasicFragment camProcess = null;
    float cameraXAngle = 60 * dToR, cameraYAngle = 45 * dToR;
    float camSensorX = 1, camSensorY = 1;

    /**
     * The {@link android.support.v4.view.PagerAdapter} that will provide
     * fragments for each of the sections. We use a
     * {@link FragmentPagerAdapter} derivative, which will keep every
     * loaded fragment in memory. If this becomes too memory intensive, it
     * may be best to switch to a
     * {@link android.support.v4.app.FragmentStatePagerAdapter}.
     */
    private SectionsPagerAdapter mSectionsPagerAdapter;

    /**
     * The {@link ViewPager} that will host the section contents.
     */
    private ViewPager mViewPager;

    //Bundle mySavedInstanceState = null;

    //private static WeakReference<Camera2BasicFragment> camProcess = null;

    int currentPage, priorPage;
    protected DisplayMetrics metrics;
    File storageBase = Environment.getExternalStorageDirectory();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // this deals with a nasty bug in which
        // a fragment isn't destroyed between incarnations
        // of this activity, preventing normal
        // recreation of the view
        //View v = findViewById(R.id.texture);
        //v = null;

        super.onCreate(savedInstanceState);

        activity = this;
        app = (SatFinderAndroidApplication) getApplication();

        setContentView(R.layout.activity_sat_finder_android);

        Resources r = getResources();

        if (r != null) {
            metrics = r.getDisplayMetrics();
        }

        satData = new ArrayList<>();

        handler = new Handler();

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        // Create the adapter that will return a fragment for each of the three
        // primary sections of the activity.
        mSectionsPagerAdapter = new SectionsPagerAdapter(getSupportFragmentManager());

        // Set up the ViewPager with the sections adapter.
        mViewPager = (ViewPager) findViewById(R.id.container);
        mViewPager.setAdapter(mSectionsPagerAdapter);

        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                onPageSelected(position);
            }

            @Override
            public void onPageSelected(int position) {
                fullScreen = true;
                // disable full screen when changing tabs
                toggleFullScreen(null);
                writeConfig();
                currentPage = position;
                checkSkyViewState();
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }


        });

        mViewPager.setOffscreenPageLimit(5);

        TabLayout tabLayout = (TabLayout) findViewById(R.id.tabs);
        tabLayout.setupWithViewPager(mViewPager);

        ActionBar ab = getSupportActionBar();
        if (ab != null) {
            ab.setDisplayShowHomeEnabled(true);
            ab.setLogo(R.drawable.app_icon);
            ab.setDisplayUseLogoEnabled(true);
            ab.setTitle("  SatFinderAndroid " + app.PROGRAM_VERSION);
        }
        double Q = .7;
        double rate = sensorSampleRate;
        double freq = 2;

        sinBF = new BiQuadraticFilter(BiQuadraticFilter.LOWPASS, freq, rate, Q);
        cosBF = new BiQuadraticFilter(BiQuadraticFilter.LOWPASS, freq, rate, Q);

        defaultDisplay = getWindowManager().getDefaultDisplay();

    }

    protected void checkSkyViewState() {
        if (currentPage != priorPage && lowestSelKey == 0 && (currentPage == TAB_SKYVIEW || currentPage == TAB_COMPASS) && skyViewOverlay != null) {
            Toast.makeText(this, "Please select a target at the TARGET tab.", Toast.LENGTH_SHORT).show();
            priorPage = currentPage;
        }

    }

    protected void afterResume() {
        // this assures that the layout is complete, everything created
        mViewPager.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                mViewPager.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                layoutComplete();
            }
        });
    }

    protected void layoutComplete() {
        setupSkyView();
        if (webList == null) {
            readConfig();
            setupLinks();
            //setupCamera();
            //app.debug_log("onCreate", camView + "," + camHolder);
            //setupTabs();
            setupDefaults();
            setupHelp();
            setLowestSelectKey();
            setupCheckBoxes();
            setupSatList();

            //setupSkyView();

            getCameraAngles();

            View v = findViewById(R.id.texture);
            if (v != null) {
                // must set both these listeners programmatically
                // if the simple xml approach is used, one action will fail
                v.setOnLongClickListener(
                        new View.OnLongClickListener() {
                            @Override
                            public boolean onLongClick(View v) {
                                toggleLightColors(null);
                                return true;
                            }
                        }
                );
                v.setOnClickListener(
                        new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                toggleFullScreen(null);
                            }
                        }
                );
            }
        }
        setupLoc();
        displayLoop();
    }

    protected void setupSkyView() {
        if (camProcess == null) {
            camProcess = Camera2BasicFragment.newInstance();
            getFragmentManager().beginTransaction()
                    .replace(R.id.skyview_pane, camProcess)
                    .commit();
        }
    }

    private void displayLoop() {
        //Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (sensorsRegistered) {
                    updateCompassDisplay();
                    displayLoop();
                }
            }
        }, 100);
    }

    protected void getCameraAngles() {
        //debug_camera_test();
        boolean success = false;
        CameraManager cManager = (CameraManager) activity.getSystemService(Context.CAMERA_SERVICE);
        if (cManager != null) {
            try {
                for (final String cameraId : cManager.getCameraIdList()) {
                    CameraCharacteristics characteristics = cManager.getCameraCharacteristics(cameraId);
                    if (characteristics != null) {
                        int cOrientation = characteristics.get(CameraCharacteristics.LENS_FACING);
                        if (cOrientation == CameraCharacteristics.LENS_FACING_BACK) {
                            float[] maxFocus = characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
                            //minFocalDistance = characteristics.get(CameraCharacteristics.LENS_INFO_FOCUS_DISTANCE_CALIBRATION);
                            SizeF size = characteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
                            if (size != null) {
                                camSensorX = size.getWidth();
                                camSensorY = size.getHeight();
                                //Rect aasize = characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                                //float aaw = aasize.width();
                                //float aah = aasize.height();
                                //Size pasize = characteristics.get(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE);
                                //float paw = pasize.getWidth();
                                //float pah = pasize.getHeight();
                                if (maxFocus != null && maxFocus.length > 0) {
                                    float fl = maxFocus[0];
                                    cameraXAngle = (float) (2 * Math.atan2(camSensorX, (fl * 2)));
                                    cameraYAngle = (float) (2 * Math.atan2(camSensorY, (fl * 2)));
                                    success = true;
                                    //Log.e("Monitor", "new FL: " + maxFocus[0] + ", X: " + cameraXAngle * rToD + ", Y: " + cameraYAngle * rToD);
                                }
                            }
                        }
                    }
                }
            } catch (CameraAccessException e) {
                Log.e("Error", "" + e.toString());
            }
        }
        if (!success) {
            cameraXAngle = 65 * dToR;
            cameraYAngle = 52 * dToR;
        }
    }

    protected void registerSensors() {
        if (!sensorsRegistered) {
            mSensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
            mRotationSensor = mSensorManager.getDefaultSensor(Sensor.TYPE_ROTATION_VECTOR);
            mSensorManager.registerListener(this, mRotationSensor,
                    sensorSampleRate * 1000);
            //mSensorManager.registerListener(this, mSensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD),
            //        SensorManager.SENSOR_DELAY_FASTEST);
            //Log.e("Monitor", "Register sensors: " + mSensorManager);
            sensorsRegistered = true;
        }
    }

    protected void unregisterSensors() {
        //Log.e("Monitor", "Unregister sensors");
        mSensorManager.unregisterListener(this);
        sensorsRegistered = false;
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_sat_finder_android, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();


        if (id == R.id.launch_help) {
            launchHelp(null);
            return true;
        }

        if (id == R.id.status_item) {
            setTab(TAB_SETUP);
            return true;
        }

        return super.onOptionsItemSelected(item);
    }


    private void setupLinks() {
        webList = (WebView) findViewById(R.id.sat_select_webview);
        locationFragment = findViewById(R.id.location_view);
        //tabHost = (TabHost) findViewById(android.R.id.tabhost);
        //tabWidget = (TabWidget) findViewById(android.R.id.tabs);
        posSource = (TextView) findViewById(R.id.pos_source);
        posQuality = (TextView) findViewById(R.id.pos_quality);
        latTV = (TextView) findViewById(R.id.lattv);
        lngTV = (TextView) findViewById(R.id.lngtv);
        magDecTV = (TextView) findViewById(R.id.magdectv);
        pointView = (RelativeLayout) findViewById(R.id.pointing_view);
        skyViewTab = (RelativeLayout) findViewById(R.id.skyview_tab);
        skyViewOverlay = (SatImageOverlay) findViewById(R.id.sat_overlay);
        //camView = (SurfaceView) findViewById(R.id.camera_view);
        helpWebView = (WebView) findViewById(R.id.help_webview);
        if (helpWebView != null) {
            WebSettings set = helpWebView.getSettings();
            set.setBuiltInZoomControls(true);
        }
        compassImage = (ImageView) findViewById(R.id.compass_image);
        locationText = (TextView) findViewById(R.id.location_text);
        statusItem = (android.support.v7.view.menu.ActionMenuItemView) findViewById(R.id.status_item);
        statusButton = (ImageButton) findViewById(R.id.status_button);
        //appButton = (Button) findViewById(R.id.app_button);
        satsUS = (RadioButton) findViewById(R.id.sats_us);
        satsInt = (RadioButton) findViewById(R.id.sats_int);
        ledIconColors = new int[]{R.drawable.ic_led_red,
                R.drawable.ic_led_yellow, R.drawable.ic_led_green};
    }

    private void setupDefaults() {
        if (satsUS != null) {
            satsUS.setChecked(app.configuration.listUSSats);
        }
        if (satsInt != null) {
            satsInt.setChecked(!app.configuration.listUSSats);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if ((requestCode == MY_GPS_REQ) && grantResults.length > 0 && grantResults[0] == PERMISSION_GRANTED) {
            //Log.e("Outcome", "onRequestPermissionsResult: " + access_permitted);
            setupLoc();
        }
    }

    public void setupLoc() {
        try {
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(this, new String[]{android.Manifest.permission.ACCESS_FINE_LOCATION}, MY_GPS_REQ);
                gotLocation(null, STATUS_NO_FIX);
            } else {
                // Acquire a reference to the system Location Manager
                locationManager = (LocationManager) this
                        .getSystemService(Context.LOCATION_SERVICE);

                // Define a listener that responds to location updates
                if (locationGPSListener == null) {
                    locationGPSListener = new LocationListener() {
                        public void onLocationChanged(Location location) {
                            gotLocation(location, STATUS_NEW_FIX);
                        }

                        public void onStatusChanged(String provider, int status,
                                                    Bundle extras) {
                        }

                        public void onProviderEnabled(String provider) {
                        }

                        public void onProviderDisabled(String provider) {
                        }

                    };
                }
                if (locationNetworkListener == null) {
                    locationNetworkListener = new LocationListener() {
                        public void onLocationChanged(Location location) {
                            gotLocation(location, STATUS_NEW_FIX);
                        }

                        public void onStatusChanged(String provider, int status,
                                                    Bundle extras) {
                        }

                        public void onProviderEnabled(String provider) {
                        }

                        public void onProviderDisabled(String provider) {
                        }

                    };
                }
                Location loc = null;
                if (app.configuration.allowGPSLocation) {
                    loc = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
                }
                if (loc == null && app.configuration.allowNetworkLocation) {
                    loc = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
                }
                if (loc != null) {
                    gotLocation(loc, STATUS_OLD_FIX);
                }

                // request new fix

                if (app.configuration.allowNetworkLocation) {
                    locationManager.requestLocationUpdates(
                            LocationManager.NETWORK_PROVIDER, posUpdateTimeInterval, posUpdateDistanceInterval, locationNetworkListener);
                } else {
                    locationManager.removeUpdates(locationNetworkListener);
                }
                if (app.configuration.allowGPSLocation) {
                    locationManager.requestLocationUpdates(
                            LocationManager.GPS_PROVIDER, posUpdateTimeInterval, posUpdateDistanceInterval, locationGPSListener);
                } else {
                    locationManager.removeUpdates(locationGPSListener);
                }
            }
        } catch (Exception e) {
            Log.e("Error", "Location Setup: " + e.toString());
        }
    }

    private void setupHelp() {
        String helpPage = loadLocalAsset("help.html");
        try {
            String v = getPackageManager().getPackageInfo(getPackageName(), 0).versionName;
            helpPage = helpPage.replaceAll("#version#", v);
        } catch (PackageManager.NameNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        loadWebViewData(helpPage, helpWebView);
    }

    @SuppressLint("RestrictedApi")
    private void setLocationStatus(int status) {
        statusItem = (ActionMenuItemView) findViewById(R.id.status_item);
        if (statusItem != null) {
            Drawable dr = ContextCompat.getDrawable(this, ledIconColors[status]);
            statusItem.setIcon(dr);
            statusButton.setImageDrawable(dr);
            posQuality.setText(statusName[status]);
        }
    }

    private String toDegMin(double a, String ne, String sw) {
        String s = (a < 0) ? sw : ne;
        a = Math.abs(a);
        double d = Math.floor(a);
        double m = ((a - d) * 60);
        return String.format("%03.0f° %02.3f' %s", d, m, s);
    }

    private void gotLocation(Location loc, int status) {
        if (loc != null) {
            //Log.e("Monitor", "gotLocation: " + loc);
            latitude = loc.getLatitude();
            longitude = loc.getLongitude();
            goodLocation = true;
            updateCompassConvention();
            strSource = loc.getProvider();
            posSource.setText(strSource);
            String strLat = toDegMin(latitude, "N", "S");
            String strLng = toDegMin(longitude, "E", "W");
            latTV.setText(strLat);
            lngTV.setText(strLng);
            //if (locationManager != null && status == STATUS_NEW_FIX) {
            //    locationManager.removeUpdates(locationGPSListener);
            //    locationManager.removeUpdates(locationNetworkListener);
            //}
            setupSatList();
        }
        setLocationStatus(status);
    }

    private void updateCompassConvention() {
        if (goodLocation) {
            long t = new Date().getTime();
            GeomagneticField gf = new GeomagneticField((float) latitude, (float) longitude, 0, t);
            magDec = gf.getDeclination() * dToR;
            useMagDec = (app.configuration.trueCompass) ? magDec : 0;
            //Log.e("Monitor", "useMagDec: " + app.configuration.trueCompass + "," + useMagDec);
            declinationString = String.format("%4.1f°", magDec * rToD);
            if (magDecTV != null) {
                magDecTV.setText(declinationString);
            }
        }
    }


    private void writeConfig() {
        app.configuration.currentTab = mViewPager.getCurrentItem();
        app.serialize();
        setupCheckBoxes();
    }

    private void readConfig() {
        app.deSerialize();
        if (app.configuration.currentTab != -1) {
            mViewPager.setCurrentItem(app.configuration.currentTab);
        }
        setupCheckBoxes();
        updateCompassConvention();
    }

    public void setSatData(View v) {
        RadioButton rb = (RadioButton) v;
        app.configuration.listUSSats = (rb == satsUS);
        app.configuration.satSelectList.clear();
        setLowestSelectKey();
        setupSatList();
    }

    protected void registerSensorManager(boolean activate) {
        if (activate) {
            registerSensors();
        } else {
            unregisterSensors();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        //readConfig();
        //afterResume();
        //registerSensorManager(true);
        //setupSkyView();
    }

    @Override
    public void onResume() {
        super.onResume();
        readConfig();
        afterResume();
        registerSensorManager(true);
    }

    @Override
    public void onStop() {
        super.onStop();
        registerSensorManager(false);
        writeConfig();
        //closeCam();
    }

    @Override
    public void onPause() {
        super.onPause();
        //closeCam();
        registerSensorManager(false);
        writeConfig();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        // end of this view
        registerSensorManager(false);
        writeConfig();
        //closeCam();
    }

    private String wrapTag(String tag, String content, String modifiers) {
        return "<" + tag + " " + modifiers + ">" + content + "</" + tag + ">";
    }

    private String wrapTag(String tag, String content) {
        return wrapTag(tag, content, "");
    }

    private String loadLocalAsset(String name) {
        StringBuilder data = new StringBuilder();
        try {
            BufferedReader isr = new BufferedReader(new InputStreamReader(getAssets().open(
                    name)));
            String line;

            while ((line = isr.readLine()) != null) {
                line = line.trim();
                if (line.length() > 0) {
                    data.append(line + "\n");
                }
            }
            isr.close();
        } catch (Exception e) {
            app.showStackTrace(e);
        }
        //Log.e("loadLocalAsset", data.toString());
        return data.toString();
    }


    @SuppressLint("DefaultLocale")
    private String generateCSVSatList() {
        //Log.e("Monitor", "setupsatlist");
        StringBuilder csvData = new StringBuilder();
        if (!goodLocation) {
            csvData.append("No Location.");
        } else {
            try {
                // if (satData == null) {
                satData = new ArrayList<>();
                // read satellite data file once
                BufferedReader isr = new BufferedReader(new InputStreamReader(getAssets().open(
                        "satlist.txt")));
                String line;
                int i = 0;
                while ((line = isr.readLine()) != null) {
                    line = line.trim();
                    if (line.length() > 0) {
                        SatDescription sd = new SatDescription(line, i, magDec, latitude, longitude);
                        satData.add(sd);
                        //Log.e("setupSatList","" + line + " -> " + sd);
                        i++;
                    }
                }
                isr.close();
                // }
                // now build satellite display
                i = 0;
                String row;
                boolean inUSSats = true;
                for (SatDescription sd : satData) {
                    if (sd.isHeader) {
                        row = sd.formatCSVTitle();
                        //Log.e("CSV Title","[" + row + "]");
                        if (row.matches("(?s).*All Geostationary.*")) {
                            inUSSats = false;
                        }
                        if (inUSSats == app.configuration.listUSSats) {
                            // assure default selection
                            // regardless of list type
                            if (app.configuration.satSelectList.size() == 0) {
                                app.configuration.satSelectList.put(i + 1, true);
                            }
                            csvData.append(row);
                            row = sd.getCSVHeader();
                            csvData.append(row);
                        }
                    } else {
                        if (inUSSats == app.configuration.listUSSats) {
                            row = sd.getCSVDescription();
                            //Log.e("CSV Record","[" + row + "]");
                            csvData.append(row);
                            //Log.e("setupSatFunct", "content: " + row);
                        }
                    }
                    i++;
                }
            } catch (Exception e) {
                Log.e("Error", "setupCSVSatList: " + e.toString());
            }
        }
        return csvData.toString();
    }

    @SuppressLint("DefaultLocale")
    private String generateHTMLSatList(boolean copyright) {
        //Log.e("Monitor", "setupsatlist");
        StringBuilder webData = new StringBuilder();
        if (!goodLocation) {
            webData.append("<b style=\"font-size:120%\">No Location.</b>");
        } else {
            try {
                // if (satData == null) {
                satData = new ArrayList<>();
                // read satellite data file once
                BufferedReader isr = new BufferedReader(new InputStreamReader(getAssets().open(
                        "satlist.txt")));
                String line;
                int i = 0;
                while ((line = isr.readLine()) != null) {
                    line = line.trim();
                    if (line.length() > 0) {
                        SatDescription sd = new SatDescription(line, i, magDec, latitude, longitude);
                        satData.add(sd);
                        //Log.e("setupSatList","" + line + " -> " + sd);
                        i++;
                    }
                }
                isr.close();
                // }
                // now build satellite display
                i = 0;
                String row;
                boolean inUSSats = true;
                for (SatDescription sd : satData) {
                    if (sd.isHeader) {
                        row = sd.formatHTMLTitle();
                        //Log.e("HTML Title","[" + row + "]");
                        if (row.matches("(?s).*All Geostationary.*")) {
                            inUSSats = false;
                        }
                        if (inUSSats == app.configuration.listUSSats) {
                            // assure default selection
                            // regardless of list type
                            //if (app.configuration.satSelectList.size() == 0) {
                            //    app.configuration.satSelectList.put(i + 1, true);
                            //}
                            webData.append(row);
                            row = sd.getHTMLHeader();
                            webData.append(row);
                        }
                    } else {
                        if (inUSSats == app.configuration.listUSSats) {
                            String js = String.format(
                                    "onClick=\"Android.exec(%d)\"", i);
                            row = sd.getHtmlDescription();
                            String rc = rowClass(i);
                            if (getSatSelected(i)) {
                                rc += " selected";
                            }
                            row = wrapTag("tr", row,
                                    String.format("class=\"%s\" id=\"%d\" ", rc, i)
                                            + js);
                            //Log.e("HTML Record","[" + row + "]");
                            webData.append(row);
                            //Log.e("setupSatFunct", "content: " + row);
                        }
                    }
                    i++;
                }
            } catch (Exception e) {
                Log.e("Error", "setupHTMLSatList: " + e.toString());
            }
        }
        String page = webData.toString();
        page = wrapTag("table", page);
        if (copyright) {
            page += String.format("<p><div align=\"center\">From <a href=\"http://arachnoid.com/android/SatFinderAndroid\">SatFinderAndroid</a>, Copyright &copy; 2017, <a href=\"http://arachnoid.com/administration\">P. Lutus</a></div></p>");
        }
        page = wrapTag("body", page);
        page = pageHead + wrapTag("html", page);
        return page;
    }

    private void setupSatList() {
        String page = generateHTMLSatList(false);
        WebSettings set = webList.getSettings();
        set.setJavaScriptEnabled(true);
        set.setBuiltInZoomControls(true);
        webList.addJavascriptInterface(new BrowserInterface(this),
                "Android");
        webList.loadDataWithBaseURL("", page, "text/html", "UTF-8", null);
        //webList.reload();
        setLowestSelectKey();
        updateCompassLocationPane();
    }

    // must use this update method to stay in the UI thread

    protected void loadWebViewUrl(final String s, final WebView target) {
        handler.post(new Runnable() {
            public void run() {
                // TODO Auto-generated method stub
                target.loadUrl(s);
            }
        });
    }

    private void loadWebViewData(final String content, final WebView target) {
        handler.post(new Runnable() {
            public void run() {
                // TODO Auto-generated method stub
                target.loadDataWithBaseURL("", content, "text/html", "UTF-8", null);
                //target.reload();
            }
        });
    }


    protected void setLowestSelectKey() {
        SatDescription item;
        //Log.e("Monitor", "setlowestselectkey A: ");
        if (app.configuration.satSelectList != null) {
            //Log.e("Monitor", "setlowestselectkey B: ");
            Set<Integer> set = app.configuration.satSelectList.keySet();
            if (set != null && satData != null) {
                //Log.e("Monitor", "setlowestselectkey set size: " + set.size());
                ArrayList<Integer> list = new ArrayList<>(set);
                Collections.sort(list);
                for (int key : list) {
                    //Log.e("Monitor","Key:" + key);
                    if (satData.size() > key) {
                        item = satData.get(key);
                        //Log.e("Monitor", "Key1:" + key + "," + item + "," + item.isHeader);
                        if (item != null && app.configuration.satSelectList.get(key)
                                && !item.isHeader) {
                            lowestSelKey = key;
                            //Log.e("Monitor", "Key result:" + key);
                            return;
                        }
                    }
                }
            }
        }
        lowestSelKey = 0;
    }

    protected void setSatSelected(int n, boolean v) {
        //Log.e("Monitor", "setSatSelected: " + n);
        app.configuration.satSelectList.put(n, v);
    }

    protected boolean getSatSelected(int n) {
        if (app.configuration.satSelectList.containsKey(n)) {
            return app.configuration.satSelectList.get(n);
        } else {
            return false;
        }
    }

    public void selectAllSats(View v) {
        setSelectSats(true);
    }

    public void clearAllSats(View v) {
        setSelectSats(false);
    }

    private void setSelectSats(boolean sel) {
        for (SatDescription sd : satData) {
            app.configuration.satSelectList.put(sd.index, sel);
        }
        setupSatList();
        app.debug_log("setSelectSats", app.configuration.satSelectList.size()
                + "," + lowestSelKey);
    }

    protected void updateCompassLocationPane() {
        //Log.e("Monitor","updateCompassLocationPane 1");
        String data = "";
        if (locationText != null && satData != null && satData.size() > lowestSelKey) {
            SatDescription sd = satData.get(lowestSelKey);
            if (sd != null && !sd.isHeader) {

                data = sd.getTextDescription();
                //Log.e("Monitor", "updateCompassLocationPane 2: " + data);
            }
        }
        if (locationText != null) {
            locationText.setText(data);
        }
    }

	/*
     * private String getSelString(int n) { String title =
	 * satData.get(n).satTitle; return String.format("Pointing Target: %s",
	 * title); }
	 */

    protected String rowClass(int n) {
        return ((n % 2) == 0) ? "evenRow" : "oddRow";
    }

    // compass-related functions

    private void drawCompassGraphic(SatDescription sd, double sensAz) {
        //Log.e("","");
        if (app.configuration.currentTab != TAB_COMPASS) {
            return;
        }
        if (compassImage == null) {
            return;
        }
        double satEl = 0;
        double az = 0;
        String satName = "No Target Selected";
        if (sd != null) {
            satEl = sd.targetEl;
            //Log.e("Monitor","Sat elev: " + satEl);
            satName = sd.satTitle;
            az = sensAz * rToD + sd.targetAzMag;
        }
        //Log.e("drawCompass","azimuth: " + sensorAzimuth + ", magdec: " + magDec + ", roll: " + sensorRoll + ", pitch: " + sensorPitch);
        if (compassPath == null) {
            compassPath = new Path();
            compassPath.addRect(-160, -15, 100, 15, Path.Direction.CW);
            compassPath.moveTo(100, 60);
            compassPath.lineTo(100, -60);
            compassPath.lineTo(160, 0);
            compassPath.lineTo(100, 60);

        }
        int xs = compassImage.getWidth();
        int ys = compassImage.getHeight();
        if (xs == 0 || ys == 0) {
            return;
        }
        if (compassBitmap == null || xs != compass_xs || ys != compass_ys) {
            compassBitmap = Bitmap
                    .createBitmap(xs, ys, Bitmap.Config.ARGB_8888);
        }

        compass_xs = xs;
        compass_ys = ys;

        compassBitmap.eraseColor(0x002020);

        float xcenter = xs / 2.0f;
        float ycenter = ys / 2.0f;

        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(Color.RED);
        paint.setStyle(Paint.Style.FILL);

        Canvas canvas = new Canvas(compassBitmap);
        canvas.translate(xcenter, ycenter);

        float scale = ((xs > ys) ? ys : xs) / 350.0f;

        canvas.scale(scale, scale);
        float rotVal = (float) ((az + 90));
        canvas.rotate(rotVal);
        canvas.drawPath(compassPath, paint);

        paint.setColor(Color.YELLOW);

        canvas.drawText((goodLocation) ? satName : "No Location", -150, 4,
                paint);

        canvas.rotate(-rotVal);

        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(Color.rgb(64, 128, 64));
        // cpaint.setAlpha(alpha);
        paint.setStrokeWidth(10);
        canvas.drawCircle(0, 0, 40, paint);
        paint.setColor(Color.rgb(128, 64, 0));
        paint.setStyle(Paint.Style.FILL);

        double levelGain = 8.0;
        float temp;

        float px = (float) (sensorRoll * levelGain * rToD);
        float py = (float) (sensorPitch * levelGain * rToD);

        int v = (defaultDisplay != null) ? defaultDisplay.getRotation() : Surface.ROTATION_0;
        switch (v) {
            case Surface.ROTATION_0:
                break;
            case Surface.ROTATION_180:
                py = -py;
                break;
            case Surface.ROTATION_90:
                temp = px;
                px = py;
                py = temp;
                break;
            case Surface.ROTATION_270:
                temp = -px;
                px = py;
                py = temp;
                break;
        }

        canvas.drawCircle(px, py, 35, paint);
        String s = "Level";
        float len = paint.measureText(s) / 2;
        paint.setColor(Color.WHITE);
        canvas.drawText(s, px - len, py, paint);

        double elev = py + satEl * levelGain;
        //Log.e("Monitor","elev: " + elev + "," + sensorPitch);
        Complex satElev = new Complex(px, elev);
        paint.setColor(Color.rgb(64, 64, 255));
        canvas.drawCircle((float) satElev.x(), (float) satElev.y(), 35, paint);
        paint.setColor(Color.WHITE);
        String sp = String.format("%+.1f°", satEl);
        len = paint.measureText(sp) / 2;
        canvas.drawText(sp, (float) satElev.x() - len, (float) satElev.y(),
                paint);

        compassImage.setImageBitmap(compassBitmap);
    }

    private double getDisplayOrientation() {
        double r = 0;
        int v = defaultDisplay.getRotation();
        switch (v) {
            case Surface.ROTATION_0:
                r = Math.PI;
                break;
            case Surface.ROTATION_90:
                r = Math.PI / 2;
                break;
            case Surface.ROTATION_180:
                r = 0;
                break;
            case Surface.ROTATION_270:
                r = Math.PI * 1.5;
                break;
        }
        return r;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.accuracy == SensorManager.SENSOR_STATUS_UNRELIABLE) {
            //Log.e("Error", "Accuracy unreliable");
            badAccuracy = true;
        }

        if (event.sensor == mRotationSensor) {
            if (badAccuracy) {
                badAccuracy = false;
            } else {
                updateOrientation(event.values);
            }
        }
    }


    @SuppressLint("WrongConstant")
    private void updateOrientation(float[] rotationVector) {
        //Log.e("Monitor","updateOrientation: " + rotationVector);
        float[] rotationMatrix = new float[9];
        SensorManager.getRotationMatrixFromVector(rotationMatrix, rotationVector);

        int worldAxisForDeviceAxisX = SensorManager.AXIS_X;
        int worldAxisForDeviceAxisY = SensorManager.AXIS_Y;

        // Remap the axes as if the device screen was the instrument panel,
        // and adjust the rotation matrix for the device orientation.
        String sorient = "";
        cameraOrientation = defaultDisplay.getRotation();
        // remap to defaults if satcompass is on display

        switch (cameraOrientation) {
            case Surface.ROTATION_0:
                sorient = "ROT 0";
                worldAxisForDeviceAxisX = SensorManager.AXIS_X;
                worldAxisForDeviceAxisY = SensorManager.AXIS_Z;
                break;
            case Surface.ROTATION_90:
                sorient = "ROT 90";
                worldAxisForDeviceAxisX = SensorManager.AXIS_Z;
                worldAxisForDeviceAxisY = SensorManager.AXIS_MINUS_X;
                break;
            case Surface.ROTATION_180:
                sorient = "ROT 180";
                worldAxisForDeviceAxisX = SensorManager.AXIS_MINUS_X;
                worldAxisForDeviceAxisY = SensorManager.AXIS_MINUS_Z;
                break;
            case Surface.ROTATION_270:
                sorient = "ROT 270";
                worldAxisForDeviceAxisX = SensorManager.AXIS_MINUS_Z;
                worldAxisForDeviceAxisY = SensorManager.AXIS_X;
                break;
            default:
                break;
        }
        // but don't remap axes when using a nearly-horizontal orientation

        if (currentPage == TAB_COMPASS) {
            worldAxisForDeviceAxisX = SensorManager.AXIS_X;
            worldAxisForDeviceAxisY = SensorManager.AXIS_Y;
        }

        float[] adjustedRotationMatrix = new float[9];
        SensorManager.remapCoordinateSystem(rotationMatrix, worldAxisForDeviceAxisX,
                worldAxisForDeviceAxisY, adjustedRotationMatrix);

        // Transform rotation matrix into azimuth/pitch/roll
        float[] orientation = new float[3];
        SensorManager.getOrientation(adjustedRotationMatrix, orientation);

        // filtering noise out of azimuth
        // is not so easy
        double localAzimuth = orientation[0];
        double azSin = Math.sin(localAzimuth);
        double azCos = Math.cos(localAzimuth);
        double rSin = sinBF.filter(azSin);
        double rCos = cosBF.filter(azCos);
        sensorAzimuth = (float) (Math.atan2(rSin, rCos));
        sensorPitch = (float) (orientation[1] - app.configuration.calLevelPitch);
        sensorRoll = (float) (orientation[2] - app.configuration.calLevelRoll);
        //String result = String.format("%d, %s: az: %.1f, pitch: %.1f, roll: %.1f", cameraOrientation, sorient, sensorAzimuth, sensorPitch, sensorRoll);
        //Log.e("Monitor", "roll: " + sensorRoll + ", pitch: " + sensorPitch);
        updateCompassDisplay();
    }


    protected double integrate(double intv, double v, double ic) {
        return (v - intv) * ic + intv;
    }


    protected void updateCompassDisplay() {
        double orientation = getDisplayOrientation();
        SatDescription sd = null;
        unitAzimuth = (float) orientation - sensorAzimuth;
        //Log.e("Monitor","Lowest Selected Key: " + lowestSelKey);
        if (satData != null && satData.size() > lowestSelKey) {
            sd = satData.get(lowestSelKey);
            //Log.e("Monitor","sd: " + sd);
        }
        drawCompassGraphic(sd, unitAzimuth);
    }


    public void calLevelSet(View v) {
        app.configuration.calLevelPitch += sensorPitch;
        app.configuration.calLevelRoll += sensorRoll;
    }

    public void calLevelDefaults(View v) {
        app.configuration.calLevelPitch = 0.0;
        app.configuration.calLevelRoll = 0.0;
    }

    /**
     * Returns a new instance of fragment for the given section
     * number.
     */
    public PlaceholderFragment newFragment(int sectionNumber) {
        //PlaceholderFragment fragment;
        //if (sectionNumber == TAB_SKYVIEW) {
        //    fragment = null;// new Camera2BasicFragment();
        //} else {
        //    fragment = new PlaceholderFragment();
        //}
        PlaceholderFragment fragment = new PlaceholderFragment();
        Bundle args = new Bundle();
        args.putInt("index", sectionNumber);
        // always use default setArguments()
        fragment.setArguments(args);
        return fragment;
    }

    /**
     * A {@link FragmentPagerAdapter} that returns a fragment corresponding to
     * one of the sections/tabs/pages.
     */
    public class SectionsPagerAdapter extends FragmentPagerAdapter {

        public SectionsPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        @Override
        public Fragment getItem(int position) {
            // getItem is called to instantiate the fragment for the given page.
            // Return a PlaceholderFragment (defined as a static inner class below).
            return newFragment(position);
        }

        @Override
        public int getCount() {
            return 5;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            switch (position) {
                case 0:
                    return "Location";
                case 1:
                    return "Target";
                case 2:
                    return "SatCompass";
                case 3:
                    return "SkyView";
                case 4:
                    return "Help";

            }
            return null;
        }
    }

    public void toggleFullScreen(View v) {
        View appbar = findViewById(R.id.appbar);
        fullScreen = !fullScreen;
        if (fullScreen) {
            appbar.setVisibility(View.GONE);
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        } else {
            appbar.setVisibility(View.VISIBLE);
            getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        }
    }

    public void toggleLightColors(View v) {
        lightColorScheme = !lightColorScheme;
    }

    public void launchHelp(View v) {
        setTab(4);
    }

    protected void setTab(int t) {
        app.configuration.currentTab = t;
        mViewPager.setCurrentItem(app.configuration.currentTab);
        writeConfig();
    }

    public void onCheckboxClicked(View v) {
        if (v == findViewById(R.id.checkbox_gps)) {
            app.configuration.allowGPSLocation = !app.configuration.allowGPSLocation;
        } else if (v == findViewById(R.id.checkbox_network)) {
            app.configuration.allowNetworkLocation = !app.configuration.allowNetworkLocation;
        }
        if (!app.configuration.allowGPSLocation && !app.configuration.allowNetworkLocation) {
            // Sometimes TEMPORARILY disabled for testing
            app.configuration.allowGPSLocation = true;
        }
        writeConfig();
        setupSatList();
        setupCheckBoxes();
        setupLoc();
    }

    protected void setupCheckBoxes() {
        CheckBox cb = (CheckBox) findViewById(R.id.checkbox_gps);
        if (cb != null) {
            cb.setChecked(app.configuration.allowGPSLocation);
            cb = (CheckBox) findViewById(R.id.checkbox_network);
            cb.setChecked(app.configuration.allowNetworkLocation);
            RadioButton b = (RadioButton) findViewById(R.id.radio_true_bearings);
            b.setChecked(app.configuration.trueCompass);
            b = (RadioButton) findViewById(R.id.radio_magnetic_bearings);
            b.setChecked(!app.configuration.trueCompass);
            View v = findViewById(R.id.location_view);
            v.invalidate();
        }
    }

    public void onDeclinationChanged(View v) {
        RadioButton tv = (RadioButton) findViewById(R.id.radio_true_bearings);
        app.configuration.trueCompass = tv.isChecked();
        //Log.e("Monitor", "Checked: " + app.configuration.trueCompass);
        writeConfig();
        updateCompassConvention();
        if (locationFragment != null) {
            locationFragment.invalidate();
        }
    }

    public void shareData(View v) {
        AlertDialog ad = new AlertDialog.Builder(activity).create();
        ad.setTitle("Share Satellite Data");
        ad.setIcon(R.drawable.app_icon);
        ad.setMessage("Share which format?");
        ad.setButton(Dialog.BUTTON_POSITIVE, "HTML table", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                shareHTML();
            }
        });
        ad.setButton(Dialog.BUTTON_NEUTRAL, "CSV table", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                shareCSV();
            }

        });
        ad.show();
    }

    protected void shareHTML() {
        if (testFileWriting()) {
            File dir = createStorageDirectory();
            String html = generateHTMLSatList(true);
            shareTable(dir, "This is an HTML data table from SatFinderAndroid", html, "html");
        }
    }

    protected void shareCSV() {
        if (testFileWriting()) {
            File dir = createStorageDirectory();
            String csv = generateCSVSatList();
            shareTable(dir, "This is a CSV data table from SatFinderAndroid", csv, "csv");
        }

    }

    private void shareTable(File dir, String title, String data, String type) {

        try {
            //File file;
            //File base = Environment.getExternalStorageDirectory();
            //File dir = new File(base, "Documents/TankCalcAndroid");
            //dir.mkdirs();
            File file = new File(dir, "TankCalcAndroidData." + type);
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(data);
            out.close();
            Uri uri = Uri.fromFile(file);
            Intent sendIntent = new Intent(Intent.ACTION_SEND);
            //Uri uri = Uri.parse("file://" + path);
            sendIntent.putExtra(Intent.EXTRA_STREAM, uri);
            sendIntent.setType("text/" + type);
            //String title = String.format("This is a %s data table from TankCalcAndroid", type.toUpperCase());
            //startActivity(Intent.createChooser(sendIntent, title));
            //sendIntent.putExtra(Intent.EXTRA_SUBJECT, msg);
            //sendIntent.putExtra(android.content.Intent.EXTRA_TEXT, msg);
            sendIntent.setType("text/" + type);
            startActivity(Intent.createChooser(sendIntent, title));
            //startActivity(sendIntent);
        } catch (Exception e) {
            Log.e("Error:", "shareTable: " + e.toString());
            //permissionsDialog();
        }
    }

    protected File createStorageDirectory() {
        File dir = new File(storageBase, "Documents/SatFinderAndroid");
        dir.mkdirs();
        return dir;
    }

    protected boolean testFileWriting() {

        if (!canWriteFiles()) {
            FunctionInterface fi = new FunctionInterface() {
                public void yes_function() {
                    setFileWritePermissions();
                }

                public void no_function() {
                }
            };
            actionDialog(this, "Enable File Writing", "To share satellite data, SatFinderAndroid needs permission to write files. In the next screen, choose \"Permissions\" and enable the \"Storage\" option. Press OK to continue, Cancel to take no action.", fi);
        }
        return canWriteFiles();
    }

    protected boolean canWriteFiles() {
        return ContextCompat.checkSelfPermission(this,
                Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED;
    }

    protected void setFileWritePermissions() {
        Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS,
                Uri.fromParts("package", getPackageName(), null));
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
    }

    public void actionDialog(Context c, String title, String message, final FunctionInterface f) {
        new AlertDialog.Builder(c)
                .setTitle(title)
                .setMessage(message)
                .setIcon(R.drawable.app_icon)
                .setPositiveButton(android.R.string.yes,
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog,
                                                int whichButton) {
                                f.yes_function();
                            }
                        })
                .setNegativeButton(android.R.string.no, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog,
                                        int whichButton) {
                        f.no_function();
                    }
                })
                .show();
    }


}
