package com.arachnoid.satfinderandroid;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.webkit.JavascriptInterface;

/**
 * Created by lutusp on 10/1/17.
 */

public // class to receive webView javascript events

class BrowserInterface {
    Handler handler;
    SatFinderAndroidActivity activity;
    SatFinderAndroidApplication app;

    /**
     * Instantiate the interface and set the context
     */
    BrowserInterface(Context c) {
        activity = (SatFinderAndroidActivity) c;
        app = (SatFinderAndroidApplication) activity.getApplication();
        handler = new Handler();
    }

    @JavascriptInterface
    public void exec(final String s) {
        handler.post(new Runnable() {
            public void run() {
                // TODO Auto-generated method stub
                //app.debug_log("BrowserInterface.exec", "web exec content: "
                        //+ s);
                //Log.e("Monitor","JavascriptInterface:exec: index " + s);
                int n = 0;
                try {
                    n = Integer.parseInt(s);
                } catch (Exception e) {
                    app.showStackTrace(e);
                    Log.e("Error","JavascriptInterface:exec: parseInt fail " + e.toString());
                }

                // reset old selection highlight

                // boolean selected = false;
                boolean selected = activity.getSatSelected(n);

                //Log.e("Monitor","JavascriptInterface: " + s + "," + selected);

                selected = !selected;

                activity.setSatSelected(n, selected);

                String rc = activity.rowClass(n);

                String sel = (selected) ? "selected" : rc;

                final String js = String
                        .format("javascript:document.getElementById(%d).setAttribute(\"class\",\"%s\");",
                                n, sel);
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        activity.loadWebViewUrl(js, activity.webList);
                        activity.setLowestSelectKey();
                        activity.updateCompassLocationPane();
                    }
                });
            }
        });
    }
}