/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.Window;

final public class MyRepsSetDialog extends Dialog {
	Context context;
	MyTimeSetEntryField tsReps;
	int reps = 0;
	OnRepsSetListener listener = null;

	public interface OnRepsSetListener {

		void onRepsSet(MyRepsSetDialog view, int reps);
	}

	protected MyRepsSetDialog(Context context, OnRepsSetListener tl,GenericEvent ae) {
		super(context);
		listener = tl;
		this.context = context;
		this.reps = ae.getRepetitions();
	}

	/** Called when the activity is first created. */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_LEFT_ICON);
		setContentView(R.layout.myrepsdialoglayout);
		setFeatureDrawableResource(Window.FEATURE_LEFT_ICON, R.drawable.app_icon);
		tsReps = (MyTimeSetEntryField) findViewById(R.id.reps_picker);
		tsReps.setValue(reps);
		int[] buttons = new int[] {R.id.cancel_button,R.id.set_button};
		for (int btn : buttons) {
			findViewById(btn).setOnClickListener(
					new View.OnClickListener() {
						public void onClick(View v) {
							pressedButton(v);
						}});
		}
	}

	private void pressedButton(View v) {
		int bid = v.getId();
		switch(bid) {
		case R.id.set_button:
			setReps();
			dismiss();
			break;
		case R.id.cancel_button:
			dismiss();
			break;
		}
	}

	public void setReps() {
		reps = tsReps.getValue();
		listener.onRepsSet(this, reps);
		dismiss();
	}
}