/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import java.util.ArrayList;

import android.app.Dialog;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;

final public class MonthDaysDialog extends Dialog  {
	GenericEvent ae;
	SetupBase context;
	ArrayList<GenericRowLayout> listRows = null;
	LinearLayout dialogList = null;

	int[] btnIds = new int[] {
			R.id.accept_button,
			R.id.cancel_button,
			R.id.clear_all_button,
			R.id.set_all_button
	};
	public MonthDaysDialog(SetupBase context, GenericEvent ae) {
		super(context);
		this.context = context;
		this.ae = ae;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_LEFT_ICON);
		setContentView(R.layout.list_dialog_layout);
		setFeatureDrawableResource(Window.FEATURE_LEFT_ICON, R.drawable.app_icon);
		String title = context.app.programTitle;
		title += ": Choose Days of Month";
		setTitle(title);
		for (int bid : btnIds) {
			Button b = (Button) findViewById(bid);
			b.setOnClickListener(
					new View.OnClickListener() {
						public void onClick(View v) {
							pressedButton(v);
						}});
		}
		createListRows();
		writeCheckBoxes();
	}

	private void createListRows() {
		listRows = new ArrayList<GenericRowLayout>();
		dialogList = (LinearLayout) findViewById(R.id.item_dialog_list);
		dialogList.removeAllViews();
		for(int i = 1;i <= 31;i++) {
			GenericRowLayout rd = (GenericRowLayout) getLayoutInflater().inflate(R.layout.generic_row_layout,dialogList,false);
			rd.setup(String.format("%d",i));
			rd.setBackgroundResource(((i % 2) == 0)?R.color.black:R.color.dark_gray);
			dialogList.addView(rd);
			listRows.add(rd);
		}
	}

	private void writeCheckBoxes() {
		int bits = ae.getMonthDayBits();
		for (GenericRowLayout rd : listRows) {
			rd.cb.setChecked((bits & 1) != 0);
			bits >>= 1;
		}
	}

	private void readCheckBoxes() {
		int bits = 0;
		for (GenericRowLayout rd : listRows) {
			bits >>= 1;
			bits |= (rd.cb.isChecked())?0x40000000:0;
		}
		ae.setMonthDayBits(bits);
	}

	public void pressedButton(View v) {
		int bid = v.getId();
		switch(bid) {
		case R.id.accept_button:
			readCheckBoxes();
			dismiss();
			break;
		case R.id.cancel_button:
			dismiss();
			break;
		case R.id.clear_all_button:
			for (GenericRowLayout rd : listRows) {
				rd.cb.setChecked(false);
			}
			break;
		case R.id.set_all_button:
			for (GenericRowLayout rd : listRows) {
				rd.cb.setChecked(true);
			}
			break;
		}
	}


}
