/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

public class GenericLayout extends LinearLayout {
	CarpeTempusApplication app = null;
	CarpeTempusActivity activity = null;
	GenericEvent ae = null;
	CheckBox acb;
	TextView em;
	TextView dv;
	TextView tv;
	View ir;

	public GenericLayout(Context context) {
		super(context);
	}

	public GenericLayout(Context context, AttributeSet as) {
		super(context, as);
	}

	public GenericLayout(Context context, AttributeSet as, int defStyle) {
		super(context, as, defStyle);
	}

	public void setup(CarpeTempusActivity activity, GenericEvent ae) {
		this.activity = activity;
		this.app = (CarpeTempusApplication) activity.getApplication();
		this.ae = ae;
		acb = (CheckBox) findViewById(R.id.active_checkbox);
		em = (TextView) findViewById(R.id.event_message);
		ir = (View) findViewById(R.id.inner_rect);
		dv = (TextView) findViewById(R.id.date_view);
		tv = (TextView) findViewById(R.id.time_view);
		int c = getResources().getColor(
				(ae instanceof TimerEvent) ? R.color.timer_background
						: R.color.alarm_background);
		ir.setBackgroundColor(c);
		updateLayout();
	}

	public void updateLayout() {
		if (ae instanceof AlarmEvent) {
			if (ae.getSpecDate()) {
				dv.setText(ae.secToDateString(app));
				dv.setTextColor(0xffffffff);
			} else {
				dv.setText("");
			}
			dv.setHint("(enter date)");
		} else {
			dv.setText("");
		}
		tv.setText(ae.secToTimeString(app));
		acb.setChecked(ae.getActive());
		em.setText(ae.getMessage());
		em.setTextColor(0xffffffff);
		em.setHint("(enter message)");
	}
}
