/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import java.util.Iterator;

import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.LinearLayout;

/*
 * Remember -- any action that needs to be preserved,
 * but that doesn't drive this view into the background,
 * must be accompanied by a call to serialize().
 * 
 * Actions that do launch a dialog, automatically serialize
 * because this view is "paused", which is set up
 * to serialize on the pause() call. 
 * 
 */

final public class CarpeTempusActivity extends SetupBase {
	LinearLayout eventList = null;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		app.activity = this;
		app.set24HourFormat();
		requestWindowFeature(Window.FEATURE_LEFT_ICON);
		setContentView(R.layout.main_layout);
		eventList = (LinearLayout) findViewById(R.id.event_list);
		Button appButton = (Button) findViewById(R.id.app_button);
		setTitle(app.programTitle + ": Alarms and Timers");
		appButton.setText(app.programTitle + ": Alarms and Timers");
		setFeatureDrawableResource(Window.FEATURE_LEFT_ICON,
				R.drawable.app_icon);
		recreateEventDateTimeFields();
		// only fully sort the alarms on a restart
		app.sortAlarms(true);
		createEventList();
		app.startAlarmSchedulerIfNeeded();
		app.setTimeZoneMonitor();
		app.restoreTimerIfNeeded();
	}

	protected void recreateEventDateTimeFields() {
		synchronized (app.alarms) {
			Iterator<GenericEvent> i = app.alarms.iterator();
			while (i.hasNext()) {
				GenericEvent ae = i.next();
				ae.makeLocalDateTimeFieldsfromEventTime();
			}
		}
	}

	protected void createEventList() {
		eventList.removeAllViews();
		synchronized (app.alarms) {
			Iterator<GenericEvent> i = app.alarms.iterator();
			while (i.hasNext()) {
				GenericEvent ae = i.next();
				GenericLayout v = (GenericLayout) getLayoutInflater().inflate(
						R.layout.alarm_item_layout, eventList, false);
				v.setup(this, ae);
				eventList.addView(v);
			}
		}
		app.setAlarmTimeout();
	}

	public void processResults() {
		createEventList();
	}

	public void newAlarmButton(View v) {
		app.newAlarmButton(v);
		refreshDisplayAndStorage();
	}

	public void newTimerButton(View v) {
		app.newTimerButton(v);
		refreshDisplayAndStorage();
	}

	public void updateEventValues(View v) {
		GenericEvent ae = getAlarmEvent(v);
		if (ae != null) {
			int id = v.getId();
			switch (id) {
			case R.id.active_checkbox:
				ae.setActive(((CheckBox) v).isChecked());
				app.serialize();
				app.setAlarmTimeout();
				break;
			}
		}
	}

	public void updateDisplay() {
		for (int i = 0; i < eventList.getChildCount(); i++) {
			GenericLayout gl = (GenericLayout) eventList.getChildAt(i);
			gl.updateLayout();
		}
	}

	public void setupButton(View v) {
		GenericEvent ae = getAlarmEvent(v);
		Intent i = new Intent(this, SetupDialogActivity.class);
		i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		int index = app.getIndexForEvent(ae);
		i.putExtra("AlarmEventIndex", index);
		app.context.startActivity(i);
	}

	public void showTimeDialogCom(View v) {
		aeclone = getAlarmEvent(v);
		aeclone.makeLocalDateTimeFieldsfromEventTime();
		super.showTimeDialogButton(v);
	}

	public void showDateDialogCom(View v) {
		aeclone = getAlarmEvent(v);
		if (aeclone instanceof AlarmEvent) {
			aeclone.makeLocalDateTimeFieldsfromEventTime();
			super.showDateDialogButton(v);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.main_menu, menu);
		return true;
	}

	private void refreshDisplayAndStorage() {
		app.serialize();
		createEventList();
	}

	@Override
	public void onResume() {
		super.onResume();
		app.set24HourFormat();
		app.sortAlarms(true);
		refreshDisplayAndStorage();
		app.activity = this;
		createEventList();
	}

	@Override
	public void onStop() {
		super.onStop();
		app.serialize();
		app.activity = null;
	}

	@Override
	public void onPause() {
		super.onPause();
		app.serialize();
		app.activity = null;
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		app.serialize();
		app.activity = null;
	}

}