package com.arachnoid.anchorsentinel;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

final public class SimpleDialogActivity extends Activity {

	int[] btnIds = new int[] { R.id.dialog_ok_button, R.id.dialog_yes_button,
			R.id.dialog_no_button };

	AnchorSentinelApplication app;
	int index = -1;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		app = (AnchorSentinelApplication) getApplication();
		requestWindowFeature(Window.FEATURE_LEFT_ICON);

		index = getIntent().getIntExtra("index", 0);
		if (index < 0) {
			setContentView(R.layout.simple_info_dialog);
		} else {
			setContentView(R.layout.simple_yn_dialog);
		}
		setFeatureDrawableResource(Window.FEATURE_LEFT_ICON,
				R.drawable.app_icon);
		String msg = getIntent().getStringExtra("msg");

		TextView tv = (TextView) findViewById(R.id.simple_dialog_msg);
		tv.setText(msg);
		for (int bid : btnIds) {
			Button b = (Button) findViewById(bid);
			if (b != null) {
				b.setOnClickListener(new View.OnClickListener() {
					public void onClick(View v) {
						buttonPressed(v);
					}
				});
			}
		}
		app.beep();
	}

	public void buttonPressed(View v) {
		switch (v.getId()) {
		case R.id.dialog_yes_button:
			app.activity.dialogCallback(index);
			break;
		}
		finish();
	}

}
