/***************************************************************************
 *   Copyright (C) 2013 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.anchorsentinel;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;

final public class MyRingtone {
	MediaPlayer player;
	AnchorSentinelApplication app;

	public MyRingtone(AnchorSentinelApplication app) {
		this.app = app;	
	}
	private void play() {
		try {
			// stop prior tone playing
			stop();
			String ringtoneUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION).toString();
			Uri uri = Uri.parse(ringtoneUri);
			player = new MediaPlayer();
			player.setDataSource(app, uri);
			final AudioManager audioManager = (AudioManager)app.getSystemService(Context.AUDIO_SERVICE);
			if (audioManager.getStreamVolume(AudioManager.STREAM_ALARM) != 0) {
				player.setAudioStreamType(AudioManager.STREAM_ALARM);
				player.setLooping(true);
				player.prepare();
				player.start();
			}
		}
		catch(Exception e) {
			//e.printStackTrace();
		}
	}

	public void start() {
		play();
	}

	public void stop() {
		if(player != null) {
			player.stop();
			player = null;
		}
	}


}
