/***************************************************************************
 *   Copyright (C) 2013 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.anchorsentinel;

import android.Manifest;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;

public class GPSMonitorService extends Service {

    AnchorSentinelApplication app = null;
    AnchorSentinelActivity activity;
    String className;
    LocationManager locationManager = null;
    LocationListener locationListener = null;

    private Handler periodicNullHandler = null;
    private Runnable periodicTask;

    @Override
    public IBinder onBind(Intent intent) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void onCreate() {
        className = getClass().getName();
        app = (AnchorSentinelApplication) getApplication();
        activity = app.activity;
        setupMonitor();
        // Log.e(className,"Starting");
    }

    public void setupMonitor() {
        startNullUpdate();
        // Acquire a reference to the system Location Manager
        locationManager = (LocationManager) this
                .getSystemService(Context.LOCATION_SERVICE);

        // Define a listener that responds to location updates
        locationListener = new LocationListener() {
            public void onLocationChanged(Location location) {
                stopNullUpdate();
                app.updateLocation(location);
            }

            public void onStatusChanged(String provider, int status,
                                        Bundle extras) {
                app.updateLocation(null);
            }

            public void onProviderEnabled(String provider) {
                stopNullUpdate();
            }

            public void onProviderDisabled(String provider) {
                startNullUpdate();
            }

        };
        if(app.canAccessLocation()) {
            locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0,
                    0, locationListener);
        }
    }

    // If GPS loses fix, it stops periodic updates
    // so we must create periodic faux updates with a null position

    protected void startNullUpdate() {
        final int delay = 1000; // milliseconds
        periodicNullHandler = new Handler();
        periodicTask = new Runnable() {
            public void run() {
                app.updateLocation(null);
                periodicNullHandler.postDelayed(periodicTask, delay);
            }
        };
        periodicTask.run();
    }

    protected void stopNullUpdate() {
        if (periodicNullHandler != null) {
            periodicNullHandler.removeCallbacks(periodicTask);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (locationManager != null) {
            locationManager.removeUpdates(locationListener);
            locationManager = null;
            locationListener = null;
        }
        // handler.removeCallbacks(periodicTask);
        // parent.logToFile(className + ": Removed: " + periodicTask.toString(),
        // false);
    }

}
