/*
 * Decompiled with CFR 0.152.
 */
package tankflow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import tankflow.FieldDatum;
import tankflow.GraphicPane;
import tankflow.HelpPane;
import tankflow.ImageTransferable;
import tankflow.InitManager;
import tankflow.MatrixFunctions;
import tankflow.Pair;
import tankflow.StateProperties;

public class TankFlow
implements ClipboardOwner {
    public String VERSION = "1.5";
    public String programName = String.valueOf(this.getClass().getSimpleName()) + " " + this.VERSION;
    protected JFrame frame;
    HelpPane helpPanel;
    private JTextPane textpane_field_data;
    private JTextPane textpane_sensor_volume;
    InitManager initManager = null;
    protected StateProperties sharedSP;
    protected ArrayList<Pair> results;
    ArrayList<Pair> reverse_results;
    private JLabel lbl_conversion_results;
    private JTextPane results_textpane;
    private String[] output_forms;
    private String[] funct_array;
    private String[] label_array;
    protected ArrayList<Double> terms = null;
    protected ArrayList<Pair> arg = null;
    private boolean reverse = false;
    private JTextPane table_textpane;
    private JTextField table_start_textfield;
    private JTextField table_end_textfield;
    private JTextField table_step_textfield;
    private boolean table_running = false;
    private JButton table_generate_button;
    private JTabbedPane main_tabbed_pane;
    private JPanel panel_drawing;
    private JPanel panel_help;
    protected double xlow;
    protected double xhigh;
    private JPanel panel_graphic_control;
    private JButton btnCopyGraphic;
    private JButton increase_button;
    private JButton decrease_button;
    private JTextField graphic_degree_textfield;
    private JLabel poly_results_label;
    private JPanel panel;
    private JButton btnReadSampleTable;
    private JButton btnClearData;
    private JPanel panel_2;
    private JPanel panel_3;
    private JLabel lblDegree;
    private JTextField polynomial_degree_textfield;
    private JLabel lblCorrLow;
    private JTextField correct_low_textfield;
    private JCheckBox correct_low_checkbox;
    private JLabel lblCorrHigh;
    private JCheckBox correct_high_checkbox;
    private JTextField correct_high_textfield;
    private JPanel panel_4;
    private JComboBox<String> output_form_combobox;
    private JCheckBox reverse_checkbox;
    private JButton button;
    private JButton button_1;
    private JButton quit_button;
    private JComboBox<Integer> decimal_places_combobox;
    private String conversion_string = "";

    public TankFlow() {
        this.initialize();
        this.resetConfiguration();
        this.setup_function_strings();
        this.output_form_combobox.setModel(new DefaultComboBoxModel<String>(this.label_array));
        ArrayList<Integer> places = new ArrayList<Integer>();
        int n = 0;
        while (n <= 16) {
            places.add(n);
            ++n;
        }
        Integer[] temp = places.toArray(new Integer[places.size()]);
        this.decimal_places_combobox.setModel(new DefaultComboBoxModel<Integer>(temp));
        this.set_conversion_string();
        this.quit_button = new JButton("Quit");
        this.quit_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.fullClose();
            }
        });
        this.quit_button.setToolTipText("Exit this program, all data saved");
        this.panel_4.add(this.quit_button);
        this.initManager = new InitManager(this);
        ImageIcon programIcon = new ImageIcon(TankFlow.class.getResource("/tankflow/icons/TankFlow.png"));
        this.frame.setIconImage(programIcon.getImage());
        this.frame.setTitle(this.programName);
        this.helpPanel = new HelpPane(this, 0);
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 2);
        this.output_forms = new String[]{"simple list (x^0 to x^n)", "mathematical function", "C function", "C++ function", "Java function", "JavaScript function", "Python function"};
        this.panel_help = new JPanel();
        this.main_tabbed_pane.addTab("Help", null, this.panel_help, null);
        this.panel_help.setLayout(new BorderLayout(0, 0));
        this.panel_help.add(this.helpPanel);
        this.initManager.getDefaultValues();
        this.initManager.readConfig();
        this.writeValues();
        this.perform_regression();
    }

    protected void resetConfiguration() {
        this.sharedSP = new StateProperties();
        this.sharedSP.programFrame = this.frame;
        this.frame.setBounds(100, 100, 640, 480);
        this.results = new ArrayList();
    }

    protected void fullClose() {
        this.saveBeforeClose();
        System.exit(0);
    }

    protected void saveBeforeClose() {
        this.readValues();
        this.initManager.writeConfig();
    }

    protected void set_degree_limit() {
        this.sharedSP.polynomialDegree = Math.max(0, this.sharedSP.polynomialDegree);
    }

    protected void set_conversion_string() {
        int n = this.decimal_places_combobox.getSelectedIndex();
        this.conversion_string = String.format("%%.%dg", n);
    }

    protected String format_number(double v) {
        return String.format(this.conversion_string, v);
    }

    protected void writeValues() {
        this.set_degree_limit();
        this.polynomial_degree_textfield.setText("" + this.sharedSP.polynomialDegree);
        this.graphic_degree_textfield.setText("" + this.sharedSP.polynomialDegree);
        this.correct_low_textfield.setText("" + this.sharedSP.correctionLow);
        this.correct_high_textfield.setText("" + this.sharedSP.correctionHigh);
        this.correct_low_checkbox.setSelected(this.sharedSP.correctionLowApply);
        this.correct_high_checkbox.setSelected(this.sharedSP.correctionHighApply);
        this.reverse_checkbox.setSelected(this.sharedSP.reverseXYData);
        this.output_form_combobox.setSelectedIndex(this.sharedSP.output_form);
        String data = this.sharedSP.timeFlowData.replaceFirst("(?s).*<<<(.*)>>>.*", "$1");
        this.textpane_field_data.setText(data);
        data = this.sharedSP.sensorVolumeData.replaceFirst("(?s).*<<<(.*)>>>.*", "$1");
        this.textpane_sensor_volume.setText(data);
        data = this.sharedSP.tableData.replaceFirst("(?s).*<<<(.*)>>>.*", "$1");
        this.table_textpane.setText(data);
        this.main_tabbed_pane.setSelectedIndex(this.sharedSP.tabbedPane);
        this.graphic_degree_textfield.setText("" + this.sharedSP.polynomialDegree);
        this.table_start_textfield.setText("" + this.sharedSP.tableStart);
        this.table_end_textfield.setText("" + this.sharedSP.tableEnd);
        this.table_step_textfield.setText("" + this.sharedSP.tableStep);
        this.decimal_places_combobox.setSelectedIndex(this.sharedSP.decimal_places);
        this.set_conversion_string();
    }

    protected void readValues() {
        String data = this.textpane_field_data.getText();
        this.sharedSP.timeFlowData = "<<<" + data + ">>>";
        data = this.textpane_sensor_volume.getText();
        this.sharedSP.sensorVolumeData = "<<<" + data + ">>>";
        this.sharedSP.tabbedPane = this.main_tabbed_pane.getSelectedIndex();
        this.sharedSP.polynomialDegree = (int)Double.parseDouble(this.polynomial_degree_textfield.getText());
        this.sharedSP.correctionLow = Double.parseDouble(this.correct_low_textfield.getText());
        this.sharedSP.correctionLowApply = this.correct_low_checkbox.isSelected();
        this.sharedSP.correctionHigh = Double.parseDouble(this.correct_high_textfield.getText());
        this.sharedSP.correctionHighApply = this.correct_high_checkbox.isSelected();
        this.sharedSP.reverseXYData = this.reverse_checkbox.isSelected();
        this.sharedSP.output_form = this.output_form_combobox.getSelectedIndex();
        this.sharedSP.tableStart = Double.parseDouble(this.table_start_textfield.getText());
        this.sharedSP.tableEnd = Double.parseDouble(this.table_end_textfield.getText());
        this.sharedSP.tableStep = Double.parseDouble(this.table_step_textfield.getText());
        data = this.table_textpane.getText();
        this.sharedSP.tableData = "<<<" + data + ">>>";
        this.sharedSP.decimal_places = this.decimal_places_combobox.getSelectedIndex();
        this.set_degree_limit();
    }

    void p(String s) {
        System.out.println(s);
    }

    protected void update_low_correction() {
        try {
            this.sharedSP.correctionLow = Double.parseDouble(this.correct_low_textfield.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void update_high_correction() {
        try {
            this.sharedSP.correctionHigh = Double.parseDouble(this.correct_high_textfield.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String rjexponent(double v, String suffix) {
        return String.format(String.valueOf(this.format_number(v)) + suffix, new Object[0]);
    }

    protected void read_sample_data() {
        int response = JOptionPane.showConfirmDialog(this.frame, "Okay to replace data entries with sample data?", "Read Sample Data", 2);
        if (response == 0) {
            String s = this.readFile("/tankflow/sample_data_table.csv");
            this.textpane_field_data.setText(s);
        }
    }

    protected void clear_data_tables() {
        int response = JOptionPane.showConfirmDialog(this.frame, "Okay to clear all entered data?", "Clear Data Tables", 2);
        if (response == 0) {
            this.textpane_field_data.setText("");
            this.textpane_sensor_volume.setText("");
        }
    }

    protected void reset_defaults() {
        int response = JOptionPane.showConfirmDialog(this.frame, "Okay to reset all program values to defaults?", "Reset Program Defaults", 2);
        if (response == 0) {
            this.resetConfiguration();
            this.results_textpane.setText("");
            this.writeValues();
        }
    }

    void convert_field_data() {
        int n = 0;
        StringBuilder sb = new StringBuilder();
        String data = this.textpane_field_data.getText();
        String[] array = data.split("\n");
        if (array != null && array.length > 1) {
            this.results = new ArrayList();
            String[] fields = new String[3];
            FieldDatum olddatum = null;
            double volume = 0.0;
            String[] stringArray = array;
            int n2 = array.length;
            int n3 = 0;
            while (n3 < n2) {
                String line = stringArray[n3];
                try {
                    fields = line.split("\\s+|,|\t", 0);
                    double flowrate = Double.parseDouble(fields[1]);
                    double sensor = Double.parseDouble(fields[2]);
                    String[] hms = fields[0].split(":", 0);
                    double hh = Double.parseDouble(hms[0]);
                    double mm = Double.parseDouble(hms[1]);
                    double ss = hms.length > 2 ? Double.parseDouble(hms[2]) : 0.0;
                    ss = ss + mm * 60.0 + hh * 3600.0;
                    FieldDatum newdatum = new FieldDatum(ss, sensor, flowrate);
                    if (olddatum != null) {
                        double dt = newdatum.time - olddatum.time;
                        while (dt < 0.0) {
                            dt += 43200.0;
                        }
                        double averageflow = (newdatum.flow + olddatum.flow) / 2.0;
                        volume += averageflow * dt / 60.0;
                    }
                    sb.append(String.format(String.valueOf(this.format_number(newdatum.sensor)) + "," + this.format_number(volume) + "\n", new Object[0]));
                    ++n;
                    olddatum = newdatum;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n3;
            }
        } else if (this.textpane_sensor_volume.getText().length() < 2) {
            this.textpane_sensor_volume.setText("No field records available.");
        }
        if (n > 0) {
            for (Pair p : this.results) {
                sb.append(p.toString());
                sb.append("\n");
            }
            this.textpane_sensor_volume.setText(sb.toString());
            this.textpane_sensor_volume.setCaretPosition(0);
        }
        this.lbl_conversion_results.setText(String.format("Converted %d field records", n));
        this.results_textpane.setText(String.format("%d field records available.", n));
    }

    protected void set_poly_degree(JTextField field) {
        try {
            String s = field.getText();
            int d = Integer.parseInt(s);
            this.update_poly_degree(d);
        }
        catch (Exception e) {
            this.change_poly_degree(0);
        }
    }

    protected void change_poly_degree(int n) {
        int d = this.sharedSP.polynomialDegree + n;
        this.update_poly_degree(d);
    }

    protected void update_poly_degree(int d) {
        this.sharedSP.polynomialDegree = d = Math.max(0, d);
        this.polynomial_degree_textfield.setText("" + d);
        this.graphic_degree_textfield.setText("" + d);
        this.perform_regression();
    }

    private void perform_regression() {
        this.results = new ArrayList();
        this.xlow = 1.0E9;
        this.xhigh = -1.0E9;
        this.terms = null;
        String[] fields = new String[2];
        String data = this.textpane_sensor_volume.getText();
        String[] array = data.split("\n");
        if (array.length > 1) {
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                try {
                    fields = line.split("\\s+|,|\t", 0);
                    double sensor = Double.parseDouble(fields[0]);
                    double volume = Double.parseDouble(fields[1]);
                    this.results.add(new Pair(sensor, volume));
                }
                catch (Exception e) {
                    this.p("" + e);
                }
                ++n2;
            }
        }
        if (this.results.size() > 1) {
            this.interpolate_data();
            this.arg = this.results;
            this.reverse = this.reverse_checkbox.isSelected();
            if (this.reverse) {
                this.reverse_results = new ArrayList();
                for (Pair p : this.results) {
                    this.reverse_results.add(new Pair(p.y, p.x));
                }
                this.arg = this.reverse_results;
            }
            this.terms = MatrixFunctions.compute_coefficients(this.arg, this.sharedSP.polynomialDegree);
        } else {
            this.results_textpane.setText("No converted sensor/volume data.");
        }
        if (this.terms != null) {
            for (Pair p : this.arg) {
                this.xlow = Math.min(this.xlow, p.x);
                this.xhigh = Math.max(this.xhigh, p.x);
            }
            int points = this.arg.size();
            this.table_start_textfield.setText("" + this.xlow);
            this.table_end_textfield.setText("" + this.xhigh);
            double result_cc = MatrixFunctions.corr_coeff(this.arg, this.terms);
            double result_se = MatrixFunctions.std_error(this.arg, this.terms);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Mode: %s analysis.\n", this.reverse ? "reverse (y,x)" : "normal x,y"));
            String short_label = String.format("Polynomial degree %d with %d data points\n", this.sharedSP.polynomialDegree, points);
            sb.append(short_label);
            String medium_label = String.format("Pts: %d, CC: " + this.format_number(result_cc) + ", SE: " + this.format_number(result_se), points);
            this.poly_results_label.setText(medium_label);
            String long_tip = String.format("<html>Data points: %d<br/>Correlation Coefficient: " + this.format_number(result_cc) + "<br/>Standard Error: " + this.format_number(result_se), points);
            this.poly_results_label.setToolTipText(long_tip);
            sb.append(String.format("Correlation coefficient: " + this.format_number(result_cc) + ".\n", new Object[0]));
            sb.append(String.format("Standard Error: " + this.format_number(result_se) + "\n\n", new Object[0]));
            int index = this.output_form_combobox.getSelectedIndex();
            String type = this.output_forms[index];
            sb.append(String.format("Output form: %s\n", type));
            String line = "--------------------------------------";
            StringBuffer cb = new StringBuffer();
            switch (index) {
                case 0: {
                    cb.append("\n");
                    for (double term : this.terms) {
                        cb.append(this.rjexponent(term, "\n"));
                    }
                    break;
                }
                case 1: {
                    int p = 0;
                    for (double term : this.terms) {
                        if (p == 0) {
                            cb.append("\nf(x) = ");
                        } else {
                            cb.append("     + ");
                        }
                        cb.append(String.format("%s * x^%d\n", this.rjexponent(term, ""), p));
                        ++p;
                    }
                    break;
                }
                default: {
                    cb.append("\n");
                    StringBuffer sf = new StringBuffer();
                    int i = 0;
                    for (double term : this.terms) {
                        String comma = i < this.terms.size() - 1 ? "," : "";
                        sf.append(String.format("    %s%s\n", this.rjexponent(term, ""), comma));
                        ++i;
                    }
                    String content = this.funct_array[index - 2];
                    content = content.replace("TERMS", sf.toString());
                    cb.append(content);
                    cb.append("\n");
                }
            }
            sb.append(line);
            sb.append(cb);
            sb.append(line);
            sb.append("\nCopyright (c) 2019, P. Lutus -- http://arachnoid.com.");
            this.results_textpane.setText(sb.toString());
            this.results_textpane.setCaretPosition(0);
        }
        if (this.panel_drawing != null) {
            this.panel_drawing.repaint();
        }
    }

    private double ntrp(double x, double xl, double xh, double yl, double yh) {
        return (x - xl) * (yh - yl) / (xh - xl) + yl;
    }

    private void interpolate_data() {
        boolean perform = false;
        if (this.results != null) {
            double y_low = this.results.get((int)0).y;
            double y_high = this.results.get((int)(this.results.size() - 1)).y;
            double y_dl = y_low;
            double y_dh = y_high;
            if (this.correct_low_checkbox.isSelected()) {
                y_dl = Double.parseDouble(this.correct_low_textfield.getText());
                perform = true;
            }
            if (this.correct_high_checkbox.isSelected()) {
                y_dh = Double.parseDouble(this.correct_high_textfield.getText());
                perform = true;
            }
            if (perform) {
                ArrayList<Pair> conv = new ArrayList<Pair>();
                for (Pair p : this.results) {
                    double dy = this.ntrp(p.y, y_low, y_high, y_dl, y_dh);
                    conv.add(new Pair(p.x, dy));
                }
                this.results = conv;
            }
        }
    }

    private String format_table_value(double x) {
        double y = MatrixFunctions.regress(x, this.terms);
        return String.format(String.valueOf(this.format_number(x)) + "," + this.format_number(y) + "\n", new Object[0]);
    }

    private void create_table() {
        if (this.table_running) {
            this.table_running = false;
            this.table_textpane.setText("Interrupted.");
            this.table_generate_button.setText("Create");
        } else {
            this.table_running = true;
            this.table_generate_button.setText("Stop");
            this.table_worker();
        }
    }

    private void table_worker() {
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            public String doInBackground() throws Exception {
                if (TankFlow.this.terms != null) {
                    TankFlow.this.table_textpane.setText("Generating table ...");
                    double x = Double.parseDouble(TankFlow.this.table_start_textfield.getText());
                    double t_end = Double.parseDouble(TankFlow.this.table_end_textfield.getText());
                    double t_step = Double.parseDouble(TankFlow.this.table_step_textfield.getText());
                    StringBuilder sb = new StringBuilder();
                    String s = "";
                    while (x < t_end && TankFlow.this.table_running) {
                        s = TankFlow.this.format_table_value(x);
                        sb.append(s);
                        x += t_step;
                    }
                    if (TankFlow.this.table_running) {
                        String se = TankFlow.this.format_table_value(t_end);
                        if (!se.equals(s)) {
                            sb.append(se);
                        }
                        TankFlow.this.table_textpane.setText(sb.toString());
                    }
                } else {
                    TankFlow.this.table_textpane.setText("No regression data avalable.");
                }
                this.done();
                return "";
            }

            @Override
            protected void done() {
                TankFlow.this.table_running = false;
                TankFlow.this.table_generate_button.setText("Create");
            }
        };
        worker.execute();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TankFlow app_window = new TankFlow();
                    app_window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setup_function_strings() {
        String cppFunct = "double regress(double x) {\n  double terms[] = {\nTERMS};\n  \n  double t = 1;\n  double r = 0;\n  for (double c : terms) {\n    r += c * t;\n    t *= x;\n  }\n  return r;\n}";
        String cFunct = "double regress(double x) {\n  double terms[] = {\nTERMS};\n  \n  size_t csz = sizeof terms / sizeof *terms;\n  \n  double t = 1;\n  double r = 0;\n  for (int i = 0; i < csz;i++) {\n    r += terms[i] * t;\n    t *= x;\n  }\n  return r;\n}";
        String pyFunct = "terms = [\nTERMS]\n\ndef regress(x):\n  t = 1\n  r = 0\n  for c in terms:\n    r += c * t\n    t *= x\n  return r";
        String javaFunct = "double regress(double x) {\n    double terms[] = {\nTERMS};\n    \n    double t = 1;\n    double r = 0;\n    for (double c : terms) {\n      r += c * t;\n      t *= x;\n    }\n    return r;\n}";
        String javascriptFunct = "terms = [\nTERMS];\n\nregress(x, terms) {\n    var r = 0;\n    var t = 1;\n    for (var i in terms) {\n      r += terms[i] * t;\n      t *= x;\n    }\n    return r;\n}";
        this.funct_array = new String[]{cFunct, cppFunct, javaFunct, javascriptFunct, pyFunct};
        this.label_array = new String[]{"Simple list", "Mathematical function", "C function", "C++ function", "Java function", "JavaScript function", "Python function"};
    }

    void showNotifyMessage(String message, String title) {
        JOptionPane.showMessageDialog(this.frame, message, String.valueOf(this.programName) + ": " + title, 1);
    }

    void setClipboardContents(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    protected void copy_graphic_to_clipboard() {
        BufferedImage image = ((GraphicPane)this.panel_drawing).grabScreen(1280, 800);
        ImageTransferable imt = new ImageTransferable(image);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(imt, null);
    }

    protected String readFile(String path) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            InputStream is = TankFlow.class.getResourceAsStream(path);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TankFlow.this.fullClose();
            }
        });
        this.frame.setDefaultCloseOperation(3);
        this.main_tabbed_pane = new JTabbedPane(3);
        this.frame.getContentPane().add((Component)this.main_tabbed_pane, "Center");
        JPanel panel_flow = new JPanel();
        panel_flow.setToolTipText("");
        this.main_tabbed_pane.addTab("Flow Data", null, panel_flow, null);
        panel_flow.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        panel_flow.add((Component)scrollPane, "Center");
        this.textpane_field_data = new JTextPane();
        this.textpane_field_data.setToolTipText("Enter time/flow rate/sensor data here");
        this.textpane_field_data.setFont(new Font("Monospaced", 0, 12));
        scrollPane.setViewportView(this.textpane_field_data);
        this.panel = new JPanel();
        panel_flow.add((Component)this.panel, "North");
        this.btnReadSampleTable = new JButton("Read Sample Table ...");
        this.btnReadSampleTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.read_sample_data();
            }
        });
        this.btnReadSampleTable.setToolTipText("Read a sample data table for tutorial purposes");
        this.panel.add(this.btnReadSampleTable);
        this.btnClearData = new JButton("Clear Data ...");
        this.btnClearData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.clear_data_tables();
            }
        });
        this.btnClearData.setToolTipText("Clear all entered data");
        this.panel.add(this.btnClearData);
        JPanel panel_volume = new JPanel();
        this.main_tabbed_pane.addTab("Sensor/Volume", null, panel_volume, null);
        panel_volume.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane_1 = new JScrollPane();
        panel_volume.add((Component)scrollPane_1, "Center");
        this.textpane_sensor_volume = new JTextPane();
        this.textpane_sensor_volume.setToolTipText("Convert flow data or enter sensor/volume data here");
        this.textpane_sensor_volume.setFont(new Font("Monospaced", 0, 12));
        scrollPane_1.setViewportView(this.textpane_sensor_volume);
        JPanel control_panel_flow = new JPanel();
        panel_volume.add((Component)control_panel_flow, "North");
        control_panel_flow.setLayout(new BorderLayout(0, 0));
        JButton btn_convert = new JButton("Convert");
        btn_convert.setToolTipText("Convert field time/flow/sensor data from Flow Data tab into sensor/volume table here");
        btn_convert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.convert_field_data();
            }
        });
        btn_convert.setHorizontalAlignment(2);
        control_panel_flow.add((Component)btn_convert, "East");
        this.lbl_conversion_results = new JLabel("Results ...");
        this.lbl_conversion_results.setHorizontalAlignment(0);
        control_panel_flow.add((Component)this.lbl_conversion_results, "Center");
        JPanel panel_regression = new JPanel();
        panel_regression.setToolTipText("");
        this.main_tabbed_pane.addTab("Regression", null, panel_regression, null);
        panel_regression.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane_2 = new JScrollPane();
        panel_regression.add((Component)scrollPane_2, "Center");
        this.results_textpane = new JTextPane();
        this.results_textpane.setToolTipText("This panel shows the most recent regression analysis result");
        this.results_textpane.setFont(new Font("Monospaced", 0, 12));
        scrollPane_2.setViewportView(this.results_textpane);
        this.panel_2 = new JPanel();
        panel_regression.add((Component)this.panel_2, "North");
        this.panel_2.setLayout(new GridLayout(2, 0, 0, 0));
        this.panel_3 = new JPanel();
        this.panel_2.add(this.panel_3);
        this.panel_3.setLayout(new FlowLayout(1, 5, 5));
        this.lblDegree = new JLabel("Degree");
        this.lblDegree.setToolTipText("Enter a polynomial degree here");
        this.lblDegree.setHorizontalAlignment(0);
        this.panel_3.add(this.lblDegree);
        this.polynomial_degree_textfield = new JTextField();
        this.polynomial_degree_textfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.set_poly_degree(TankFlow.this.polynomial_degree_textfield);
            }
        });
        this.polynomial_degree_textfield.setToolTipText("Enter polynomial degree here");
        this.polynomial_degree_textfield.setText("12");
        this.polynomial_degree_textfield.setMinimumSize(new Dimension(26, 19));
        this.polynomial_degree_textfield.setHorizontalAlignment(4);
        this.polynomial_degree_textfield.setColumns(2);
        this.panel_3.add(this.polynomial_degree_textfield);
        this.lblCorrLow = new JLabel("Corr. Low");
        this.lblCorrLow.setToolTipText("");
        this.lblCorrLow.setHorizontalAlignment(0);
        this.panel_3.add(this.lblCorrLow);
        this.correct_low_textfield = new JTextField();
        this.correct_low_textfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.update_low_correction();
            }
        });
        this.correct_low_textfield.setToolTipText("Enter an optional low correction value here");
        this.correct_low_textfield.setText("0");
        this.correct_low_textfield.setHorizontalAlignment(4);
        this.correct_low_textfield.setColumns(8);
        this.panel_3.add(this.correct_low_textfield);
        this.correct_low_checkbox = new JCheckBox("Apply");
        this.correct_low_checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.perform_regression();
            }
        });
        this.correct_low_checkbox.setToolTipText("Enable to apply the low correction");
        this.correct_low_checkbox.setSelected(false);
        this.panel_3.add(this.correct_low_checkbox);
        this.lblCorrHigh = new JLabel(" | Corr. High");
        this.lblCorrHigh.setToolTipText("");
        this.lblCorrHigh.setHorizontalAlignment(0);
        this.panel_3.add(this.lblCorrHigh);
        this.correct_high_textfield = new JTextField();
        this.correct_high_textfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.update_high_correction();
            }
        });
        this.correct_high_textfield.setToolTipText("Enter an optional high correction value here");
        this.correct_high_textfield.setText("100");
        this.correct_high_textfield.setHorizontalAlignment(4);
        this.correct_high_textfield.setColumns(8);
        this.panel_3.add(this.correct_high_textfield);
        this.correct_high_checkbox = new JCheckBox("Apply");
        this.correct_high_checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.perform_regression();
            }
        });
        this.correct_high_checkbox.setToolTipText("Enable to apply the high correction");
        this.correct_high_checkbox.setSelected(false);
        this.correct_high_checkbox.setHorizontalAlignment(2);
        this.panel_3.add(this.correct_high_checkbox);
        this.panel_4 = new JPanel();
        this.panel_2.add(this.panel_4);
        this.output_form_combobox = new JComboBox();
        this.output_form_combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.perform_regression();
            }
        });
        this.decimal_places_combobox = new JComboBox();
        this.decimal_places_combobox.setToolTipText("Choose the number of decimal places in tables and results");
        this.decimal_places_combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.set_conversion_string();
            }
        });
        this.panel_4.add(this.decimal_places_combobox);
        this.output_form_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"\"a\",\"b\",\"c\""}));
        this.output_form_combobox.setSelectedIndex(0);
        this.output_form_combobox.setToolTipText("Select the desired output format");
        this.panel_4.add(this.output_form_combobox);
        this.reverse_checkbox = new JCheckBox("Reverse X-Y");
        this.reverse_checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.perform_regression();
            }
        });
        this.reverse_checkbox.setToolTipText("Enable to reverse the relationship between X and Y");
        this.reverse_checkbox.setSelected(false);
        this.panel_4.add(this.reverse_checkbox);
        this.button = new JButton("Perform");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.perform_regression();
            }
        });
        this.button.setToolTipText("Carry out this regression");
        this.panel_4.add(this.button);
        this.button_1 = new JButton("Reset");
        this.button_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.reset_defaults();
            }
        });
        this.button_1.setToolTipText("Reset all program values to defaults");
        this.panel_4.add(this.button_1);
        JPanel panel_graphic = new JPanel();
        this.main_tabbed_pane.addTab("Graphic", null, panel_graphic, null);
        panel_graphic.setLayout(new BorderLayout(0, 0));
        this.panel_drawing = new GraphicPane(this);
        this.panel_drawing.setForeground(Color.WHITE);
        this.panel_drawing.setBackground(Color.WHITE);
        panel_graphic.add((Component)this.panel_drawing, "Center");
        this.panel_drawing.setLayout(new BorderLayout(0, 0));
        this.panel_graphic_control = new JPanel();
        this.panel_graphic_control.setBackground(Color.WHITE);
        panel_graphic.add((Component)this.panel_graphic_control, "North");
        GridBagLayout gbl_panel_graphic_control = new GridBagLayout();
        gbl_panel_graphic_control.columnWidths = new int[]{32, 32, 32, 32, 32};
        int[] nArray = new int[2];
        nArray[0] = 25;
        gbl_panel_graphic_control.rowHeights = nArray;
        gbl_panel_graphic_control.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0};
        gbl_panel_graphic_control.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.panel_graphic_control.setLayout(gbl_panel_graphic_control);
        this.decrease_button = new JButton("");
        this.decrease_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.change_poly_degree(-1);
            }
        });
        this.decrease_button.setToolTipText("Decrease polynomial degree");
        this.decrease_button.setIcon(new ImageIcon(TankFlow.class.getResource("/tankflow/icons/go-previous.png")));
        this.decrease_button.setVerticalAlignment(1);
        this.decrease_button.setHorizontalAlignment(2);
        GridBagConstraints gbc_decrease_button = new GridBagConstraints();
        gbc_decrease_button.fill = 2;
        gbc_decrease_button.insets = new Insets(0, 0, 0, 5);
        gbc_decrease_button.anchor = 17;
        gbc_decrease_button.gridx = 0;
        gbc_decrease_button.gridy = 0;
        this.panel_graphic_control.add((Component)this.decrease_button, gbc_decrease_button);
        this.graphic_degree_textfield = new JTextField();
        this.graphic_degree_textfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.set_poly_degree(TankFlow.this.graphic_degree_textfield);
            }
        });
        this.graphic_degree_textfield.setToolTipText("Enter polynomial degree");
        this.graphic_degree_textfield.setHorizontalAlignment(0);
        GridBagConstraints gbc_graphic_degree_textfield = new GridBagConstraints();
        gbc_graphic_degree_textfield.anchor = 17;
        gbc_graphic_degree_textfield.insets = new Insets(0, 0, 0, 5);
        gbc_graphic_degree_textfield.gridx = 1;
        gbc_graphic_degree_textfield.gridy = 0;
        this.panel_graphic_control.add((Component)this.graphic_degree_textfield, gbc_graphic_degree_textfield);
        this.graphic_degree_textfield.setColumns(2);
        this.increase_button = new JButton("");
        this.increase_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.change_poly_degree(1);
            }
        });
        this.increase_button.setToolTipText("Increase polynomial degree");
        this.increase_button.setIcon(new ImageIcon(TankFlow.class.getResource("/tankflow/icons/go-next.png")));
        GridBagConstraints gbc_increase_button = new GridBagConstraints();
        gbc_increase_button.fill = 2;
        gbc_increase_button.anchor = 18;
        gbc_increase_button.insets = new Insets(0, 0, 0, 5);
        gbc_increase_button.gridx = 2;
        gbc_increase_button.gridy = 0;
        this.panel_graphic_control.add((Component)this.increase_button, gbc_increase_button);
        this.btnCopyGraphic = new JButton("Copy Chart");
        this.btnCopyGraphic.setHorizontalAlignment(4);
        this.btnCopyGraphic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.copy_graphic_to_clipboard();
            }
        });
        this.poly_results_label = new JLabel();
        this.poly_results_label.setBackground(Color.WHITE);
        this.poly_results_label.setText("Polynomial results");
        GridBagConstraints gbc_poly_results_label = new GridBagConstraints();
        gbc_poly_results_label.insets = new Insets(0, 0, 0, 5);
        gbc_poly_results_label.fill = 2;
        gbc_poly_results_label.gridx = 3;
        gbc_poly_results_label.gridy = 0;
        this.panel_graphic_control.add((Component)this.poly_results_label, gbc_poly_results_label);
        this.btnCopyGraphic.setToolTipText("Copy this chart as an image to the system clipboard");
        GridBagConstraints gbc_btnCopyGraphic = new GridBagConstraints();
        gbc_btnCopyGraphic.fill = 2;
        gbc_btnCopyGraphic.insets = new Insets(0, 0, 0, 5);
        gbc_btnCopyGraphic.anchor = 13;
        gbc_btnCopyGraphic.gridx = 4;
        gbc_btnCopyGraphic.gridy = 0;
        this.panel_graphic_control.add((Component)this.btnCopyGraphic, gbc_btnCopyGraphic);
        JPanel panel_table = new JPanel();
        this.main_tabbed_pane.addTab("Table", null, panel_table, null);
        panel_table.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane_3 = new JScrollPane();
        panel_table.add((Component)scrollPane_3, "Center");
        this.table_textpane = new JTextPane();
        this.table_textpane.setToolTipText("Create data table here");
        scrollPane_3.setViewportView(this.table_textpane);
        JPanel panel_1 = new JPanel();
        panel_table.add((Component)panel_1, "North");
        panel_1.setLayout(new GridLayout(0, 7, 0, 0));
        JLabel label = new JLabel("Start");
        label.setHorizontalAlignment(0);
        panel_1.add(label);
        this.table_start_textfield = new JTextField();
        this.table_start_textfield.setToolTipText("Table start X value");
        this.table_start_textfield.setText("0");
        this.table_start_textfield.setMaximumSize(new Dimension(100, Integer.MAX_VALUE));
        this.table_start_textfield.setHorizontalAlignment(4);
        this.table_start_textfield.setColumns(10);
        panel_1.add(this.table_start_textfield);
        JLabel label_1 = new JLabel("End");
        label_1.setHorizontalAlignment(0);
        panel_1.add(label_1);
        this.table_end_textfield = new JTextField();
        this.table_end_textfield.setToolTipText("Table end X value");
        this.table_end_textfield.setText("100");
        this.table_end_textfield.setMaximumSize(new Dimension(100, Integer.MAX_VALUE));
        this.table_end_textfield.setHorizontalAlignment(4);
        this.table_end_textfield.setColumns(10);
        panel_1.add(this.table_end_textfield);
        JLabel label_2 = new JLabel("Step");
        label_2.setHorizontalAlignment(0);
        panel_1.add(label_2);
        this.table_step_textfield = new JTextField();
        this.table_step_textfield.setToolTipText("Table step size");
        this.table_step_textfield.setText("1");
        this.table_step_textfield.setMaximumSize(new Dimension(100, Integer.MAX_VALUE));
        this.table_step_textfield.setHorizontalAlignment(4);
        this.table_step_textfield.setColumns(10);
        panel_1.add(this.table_step_textfield);
        this.table_generate_button = new JButton("Create");
        this.table_generate_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TankFlow.this.create_table();
            }
        });
        this.table_generate_button.setToolTipText("Create the table");
        panel_1.add(this.table_generate_button);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

