/*
 * Decompiled with CFR 0.152.
 */
package tankflow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.net.URL;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import tankflow.HelpState;
import tankflow.TankFlow;

public final class HelpPane
extends JPanel {
    int invocationCount = 0;
    protected JTextField findTextField;
    JScrollPane helpScrollPane;
    TankFlow parent;
    Stack<HelpState> undoStack;
    Stack<HelpState> redoStack;
    Document doc;
    String oldSearch = "";
    int oldPos = 0;
    Object oldHighlight = null;
    Highlighter highlighter;
    Highlighter.HighlightPainter highlightPainter;
    JTextPane helpTextPane;
    JButton undoButton;
    JButton redoButton;
    JButton launchButton;
    JFrame separateFrame;
    HelpPane childHelp = null;

    public HelpPane(TankFlow p, int count) {
        this.invocationCount = count + 1;
        this.parent = p;
        this.setLayout(new BorderLayout(0, 0));
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.helpTextPane = new JTextPane();
        this.helpTextPane.setFocusable(false);
        this.helpTextPane.setBackground(Color.white);
        this.helpTextPane.setContentType("text/html;charset=UTF-8");
        this.helpTextPane.setEditorKit(new HTMLEditorKit());
        this.helpTextPane.setEditable(false);
        this.helpTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                HelpPane.this.manageHyperlinks(evt);
            }
        });
        this.doc = this.helpTextPane.getDocument();
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.highlighter = this.helpTextPane.getHighlighter();
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(200, 255, 200));
        this.helpScrollPane = new JScrollPane();
        this.add((Component)this.helpScrollPane, "Center");
        this.helpScrollPane.setViewportView(this.helpTextPane);
        JPanel controlPanel = new JPanel();
        this.add((Component)controlPanel, "South");
        this.launchButton = new JButton("");
        this.launchButton.setIcon(new ImageIcon(HelpPane.class.getResource("/tankflow/icons/system-help.png")));
        this.launchButton.setToolTipText("Launch copy of help in separate window");
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpPane.this.launchHelpInFrame();
            }
        });
        controlPanel.setLayout(new MigLayout("", "[]push[][][][]push"));
        controlPanel.add((Component)this.launchButton, "cell 0 0,alignx left");
        this.findTextField = new JTextField();
        this.findTextField.setHorizontalAlignment(4);
        this.findTextField.setToolTipText("<html>Quick search: type a search string,<br/>press Enter to find the next case</html>");
        this.findTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HelpPane.this.manageHelpTextField(e);
            }
        });
        this.redoButton = new JButton("");
        this.redoButton.setToolTipText("Redo previously undone action");
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpPane.this.redoPop();
            }
        });
        this.undoButton = new JButton("");
        this.undoButton.setToolTipText("Undo prior action");
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpPane.this.undoPop();
            }
        });
        this.undoButton.setIcon(new ImageIcon(HelpPane.class.getResource("/tankflow/icons/edit-undo.png")));
        controlPanel.add((Component)this.undoButton, "cell 2 0,alignx right");
        this.redoButton.setIcon(new ImageIcon(HelpPane.class.getResource("/tankflow/icons/edit-redo.png")));
        controlPanel.add((Component)this.redoButton, "cell 3 0,alignx right");
        controlPanel.add((Component)this.findTextField, "cell 4 0,alignx right");
        this.findTextField.setColumns(10);
        this.setupHelp();
        this.setButtons();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                HelpPane.this.findTextField.requestFocus();
                HelpPane.this.findTextField.requestFocusInWindow();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpPane.this.onStart();
            }
        });
    }

    protected void onStart() {
        this.helpScrollPane.getVerticalScrollBar().setValue(this.parent.sharedSP.helpScrollPos);
        this.findTextField.requestFocus();
        this.findTextField.requestFocusInWindow();
    }

    protected void onQuit() {
        this.parent.sharedSP.helpScrollPos = this.helpScrollPane.getVerticalScrollBar().getValue();
        if (this.childHelp != null) {
            this.childHelp.onQuit();
            this.separateFrame.setVisible(false);
            this.separateFrame.dispose();
        }
    }

    public void setScrollPos() {
        this.parent.sharedSP.helpScrollPos = this.helpScrollPane.getVerticalScrollBar().getValue();
    }

    protected void launchHelpInFrame() {
        if (this.invocationCount > 4) {
            this.parent.showNotifyMessage("Yes, you really can launch any number of\nchild help windows. But ... should you? :)", "More Help");
        }
        this.setScrollPos();
        this.separateFrame = new JFrame();
        this.childHelp = new HelpPane(this.parent, this.invocationCount);
        this.separateFrame.getContentPane().add(this.childHelp);
        this.separateFrame.setSize(this.getSize());
        this.separateFrame.setTitle(this.parent.frame.getTitle());
        this.separateFrame.setIconImage(this.parent.frame.getIconImage());
        this.separateFrame.setVisible(true);
    }

    void setupHelp() {
        String fn = "/tankflow/helpresources/HelpText.html";
        try {
            String s = this.parent.readFile(fn);
            s = s.replaceAll("#version#", this.parent.VERSION);
            String ud = this.parent.initManager.userPath.replaceAll("\\\\", "\\\\\\\\");
            ud = ud.replaceAll("\\$", "\\\\\\\\$");
            s = s.replaceAll("#userdir#", ud);
            this.helpTextPane.setText(s);
            this.helpTextPane.select(0, 0);
            URL url = this.parent.getClass().getResource(fn).toURI().toURL();
            ((HTMLDocument)this.helpTextPane.getDocument()).setBase(url);
        }
        catch (Exception e) {
            System.out.println("setupHelp: " + e);
            e.printStackTrace();
        }
    }

    void manageHyperlinks(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String surl = evt.getURL().toString();
            if (surl.matches("http://.*")) {
                try {
                    Desktop.getDesktop().browse(URI.create(surl));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else if (surl.matches(".*#.*")) {
                try {
                    this.undoPush();
                    this.helpTextPane.scrollToReference(url.getRef());
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else if (surl.matches(".*file:.*")) {
                String lensSpec = surl.replaceFirst("(?ms).*?file:\\s*(\\S*?)\\s*", "$1");
                String s = this.parent.readFile(lensSpec);
                this.parent.setClipboardContents(s);
            }
        }
    }

    void undoPop() {
        if (this.undoStack.size() > 0) {
            this.redoPush();
            this.removeOldHighlight();
            HelpState hs = this.undoStack.pop();
            this.helpScrollPane.getVerticalScrollBar().setValue(hs.scrollBar);
            try {
                this.oldHighlight = this.highlighter.addHighlight(hs.selectStart, hs.selectEnd, this.highlightPainter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.setButtons();
        }
    }

    void redoPop() {
        if (this.redoStack.size() > 0) {
            this.undoPush();
            this.removeOldHighlight();
            HelpState hs = this.redoStack.pop();
            this.helpScrollPane.getVerticalScrollBar().setValue(hs.scrollBar);
            try {
                this.oldHighlight = this.highlighter.addHighlight(hs.selectStart, hs.selectEnd, this.highlightPainter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.setButtons();
        }
    }

    void undoPush() {
        int ss = 0;
        int se = 0;
        Highlighter.Highlight[] ha = this.highlighter.getHighlights();
        if (ha.length > 0) {
            ss = ha[0].getStartOffset();
            se = ha[0].getEndOffset();
        }
        int sbp = this.helpScrollPane.getVerticalScrollBar().getValue();
        this.undoStack.push(new HelpState(sbp, ss, se));
        this.setButtons();
    }

    void redoPush() {
        int ss = 0;
        int se = 0;
        Highlighter.Highlight[] ha = this.highlighter.getHighlights();
        if (ha.length > 0) {
            ss = ha[0].getStartOffset();
            se = ha[0].getEndOffset();
        }
        int sbp = this.helpScrollPane.getVerticalScrollBar().getValue();
        this.redoStack.push(new HelpState(sbp, ss, se));
        this.setButtons();
    }

    void setButtons() {
        this.undoButton.setEnabled(this.undoStack.size() > 0);
        this.redoButton.setEnabled(this.redoStack.size() > 0);
    }

    void removeOldHighlight() {
        if (this.oldHighlight != null) {
            this.highlighter.removeHighlight(this.oldHighlight);
            this.oldHighlight = null;
        }
    }

    void manageHelpTextField(KeyEvent evt) {
        try {
            this.removeOldHighlight();
            this.doc = this.helpTextPane.getDocument();
            int len = this.doc.getLength();
            String content = this.doc.getText(0, len).toLowerCase();
            String search = this.findTextField.getText().toLowerCase();
            if (!search.equals(this.oldSearch)) {
                this.oldPos = 0;
            }
            this.oldSearch = search;
            int p = content.indexOf(search, this.oldPos);
            if (p == -1) {
                this.oldPos = 0;
                p = content.indexOf(search, this.oldPos);
            }
            if (p >= 0) {
                int slen = search.length();
                Rectangle r = this.helpTextPane.modelToView(p);
                int pos = r.y - this.helpScrollPane.getHeight() / 2;
                pos = pos < 0 ? 0 : pos;
                this.helpScrollPane.getVerticalScrollBar().setValue(pos);
                this.oldHighlight = this.highlighter.addHighlight(p, p + slen, this.highlightPainter);
                this.oldPos = p + 1;
                this.undoPush();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

