/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package tankcalc;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 *
 * @author lutusp
 */
final public class UserActionManager {

    int min, max;
    JTextField field = null;
    JComboBox box = null;
    TankCalc parent;

    public UserActionManager(JTextField field, int min, int max, TankCalc p) {
        this.field = field;
        init(min, max, p);
        assignHandlers(field);
    }

    public UserActionManager(JComboBox box, int min, int max, TankCalc p) {
        this.box = box;
        init(min, max, p);
        assignHandlers(box);
    }

    void init(int min, int max, TankCalc p) {
        parent = p;
        this.min = min;
        this.max = max;
    }

    public void assignHandlers(Component comp) {
        comp.addMouseWheelListener(new java.awt.event.MouseWheelListener() {

            @Override
            public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
                handleMouseWheelMoved(evt);
            }
        });
        comp.addKeyListener(new java.awt.event.KeyAdapter() {

            @Override
            public void keyReleased(java.awt.event.KeyEvent evt) {
                handleKeyReleased(evt);
            }
        });
    }

    private void handleKeyReleased(KeyEvent evt) {
        double n = 0;
        double v = 1;
        v = (evt.isShiftDown()) ? v * 0.1 : v;
        v = (evt.isAltDown()) ? v * 0.01 : v;
        int kcode = evt.getKeyCode();
        //String code = KeyEvent.getKey_Text(kcode);
        //System.out.println("key: " + code);
        if (kcode == KeyEvent.VK_HOME) {
            n = 100;
        } else if (kcode == KeyEvent.VK_END) {
            n = -100;
        } else if (kcode == KeyEvent.VK_PAGE_UP) {
            n = 10;
        } else if (kcode == KeyEvent.VK_PAGE_DOWN) {
            n = -10;
        } else if (kcode == KeyEvent.VK_DOWN) {
            n = -1;
        } else if (kcode == KeyEvent.VK_UP) {
            n = 1;
        }
        handleIncrement(n,v);
    }

    private void handleMouseWheelMoved(MouseWheelEvent evt) {
        double v = 1;
        v = (evt.isShiftDown()) ? v * 0.1 : v;
        v = (evt.isAltDown()) ? v * 0.01 : v;
        handleIncrement(-evt.getWheelRotation(),v);
    }

    void handleIncrement(double n,double sens) {
        if (n != 0) {
            if (field != null) {
                String text = field.getText();
                int myMax = max;
                String suff = "";
                String[] array = findSuff(text, new String[]{"%", "d"});
                if (array != null) {
                    text = array[1];
                    suff = array[0];
                    if (suff.equals("%") && max == 90) {
                        // allow a much larger entry for slope
                        // than for degrees
                        myMax = 1000;
                    } else if (suff.equals("d")) { // degree entry
                        myMax = 90;
                    }
                }
                double dv = parent.getDouble(text);
                double v = dv + (n * sens);
                v = (v < min) ? min : v;
                v = (v > myMax) ? myMax : v;
                //System.out.println("result: " + v);
                field.setText(parent.formatNum(v) + suff);

            } else if (box != null) {
                int v = box.getSelectedIndex();
                v += n;
                int top = box.getItemCount();
                v = (v < 0) ? 0 : v;
                v = (v >= top) ? top - 1 : v;
                box.setSelectedIndex(v);
            }
            if (parent != null) {
                parent.setModeAndLabels();
            }
        }
    }

    private String[] findSuff(String text, String[] suff) {
        String out = null;
        for (int i = 0; i < suff.length && out == null; i++) {
            if (text.matches(".*" + suff[i] + ".*")) {
                out = suff[i];
                text = text.replaceAll(suff[i], "");
            }
        }
        if (out == null) {
            return null;
        }
        return new String[]{out, text};
    }
}
