/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tankcalc;

import java.awt.event.*;
import java.util.ArrayList;
import java.util.Arrays;

/**
 *
 * @author lutusp
 */
public class SurfaceAreaMassComputer {

    TankCalc parent;
    TankProcessor tvi;
    TankProperties sharedTP;
    double iuToLength,iuToArea, iuToVolume;

    public SurfaceAreaMassComputer(TankCalc p, TankProperties stp) {
        parent = p;
        tvi = parent.tankProcessor;
        sharedTP = stp;
    }

    void formatLine(String s, double v, String unit,boolean header) {
        String sv = parent.formatNum(v);
        formatLine(s, sv,unit,header);
    }

    void formatLine(String s, String sv, String unit, boolean header) {
       ArrayList<String> record = new ArrayList<>(Arrays.asList(s, sv, unit));
        parent.addTableRecord(record,header);
        //String rs = String.format("%-52s %16s %12s\n", s, sv,unit);
        //return rs;
    }

    String convertLengthFormat(double v) {
        return parent.formatNum(v * iuToLength);
    }

    String convertAreaFormat(double v) {
        return parent.formatNum(v * iuToArea);
    }

    String convertVolumeFormat(double v) {
        return parent.formatNum(v * iuToVolume);
    }
    
    public void updateSettings( TankProperties stp) {
        sharedTP = stp;
    }

    public void createList() {
        try {
            iuToLength = tvi.convertLengthUnits(1.0, true);
            iuToArea = iuToLength * iuToLength;
            iuToVolume = iuToArea * iuToLength;
            String plainInUnit = parent.plainTextConvertExponents(sharedTP.currentInputUnitName);
            String ius = plainInUnit;
            String sius = plainInUnit + "^2";
            String cius = plainInUnit + "^3";
            String cous = sharedTP.currentOutputUnitName;
            double wt_conv = parent.tankProcessor.convertLengthUnits(sharedTP.wallThickness, false);
            double wd = sharedTP.wallDensity;
            double cd = sharedTP.contentDensity;
            int units = sharedTP.weightUnitIndex;
            String su = sharedTP.weightUnitName;
            double ftv = tvi.maxVolume;
            double fcsa = tvi.cylinderFullSurfaceArea() * sharedTP.scalingFactor; // meters^2
            double lca = tvi.endCapFullSurfaceArea(true) * sharedTP.scalingFactor; // meters^2
            double rca = tvi.endCapFullSurfaceArea(false) * sharedTP.scalingFactor; // meters^2
            // total surface area
            double tsa = fcsa + lca + rca; // meters^2
            // this was wrong
            //double twv = wt_conv * tsa; //  total wall volume in meters^3
            // subtract two volumes instead
            double twv = tvi.tankFullVolumeWithWallThickness().volume - tvi.tankFullVolume().volume;
            twv *= sharedTP.scalingFactor;
            double tm = twv * wd * 1e6; // grams
            tm /= 1000.0; // kilograms
            if (units == 1) { // pounds
                tm *= 2.2046244;
            }
            double contentw = ftv * cd * 1e6; // grams
            contentw /= 1000.0; // kilograme
            if (units == 1) { // pounds
                contentw *= 2.2046244;
            }

            formatLine("Name", "Value", "Units",true);
            formatLine("Input units", ius, "",false);
            formatLine("Output units", sharedTP.currentOutputUnitName, "",false);
            formatLine("Tank orientation", parent.tankOrientationString(), "",false);
            formatLine("Cylinder length (L)", convertLengthFormat(tvi.g_L), ius,false);
            formatLine("Cylinder radius (R)", convertLengthFormat(tvi.g_R), ius,false);
            formatLine("Left/bottom cap radius (r)", convertLengthFormat(tvi.g_rL), ius,false);
            formatLine("Right/top cap radius (r)", convertLengthFormat(tvi.g_rR), ius,false);
            formatLine("Scaling factor", parent.formatNum(sharedTP.scalingFactor), "(width/height ratio)",false);
            formatLine("Tank internal height", convertLengthFormat(tvi.maxHeight), ius,false);
            formatLine("Sensor vertical offset", convertLengthFormat(tvi.trueSensorOffset), ius,false);
            formatLine("Cylinder surface area", convertAreaFormat(fcsa), sius,false);
            formatLine("Left/bottom cap surface area", convertAreaFormat(lca), sius,false);
            formatLine("Right/top cap surface area", convertAreaFormat(rca), sius,false);
            formatLine("Tank surface area (cylinder+caps)", convertAreaFormat(tsa), sius,false);
            formatLine("Tank wall thickness", convertLengthFormat(wt_conv), ius,false);
            formatLine("Tank wall density", wd, "(water = 1)",false);
            formatLine("Tank content density", cd, "(water = 1)",false);
            formatLine("Tank wall volume (input units^3)", convertVolumeFormat(twv), cius,false);
            formatLine("Tank interior volume (input units^3)", convertVolumeFormat(ftv), cius,false);
            formatLine("Tank interior volume (output units)", parent.formatNum(sharedTP.maxVolumeConverted), cous,false);
            formatLine("Tank content weight (full tank)", parent.formatNum(contentw), su,false);
            formatLine("Tank empty weight", parent.formatNum(tm), su,false);
            formatLine("Tank gross weight (tank+contents)", parent.formatNum(contentw + tm), su,false);

        } catch (Exception e) {
            parent.setStatus("Numeric entry error", true);
            //System.out.println(getClass().getName() + ": " + e);
        }
    }

    public void createIfEnter(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            createList();
        }
    }
}
