/**
 * *************************************************************************
 * Copyright (C) 2014 by Paul Lutus * lutusp@arachnoid.com * * This program is
 * free software; you can redistribute it and/or modify * it under the terms of
 * the GNU General Public License as published by * the Free Software
 * Foundation; either version 2 of the License, or * (at your option) any later
 * version. * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the * GNU General
 * Public License for more details. * * You should have received a copy of the
 * GNU General Public License * along with this program; if not, write to the *
 * Free Software Foundation, Inc., * 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA. *
 * *************************************************************************
 */
package tankcalc;

import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import javax.swing.JTable;
import javax.swing.SwingUtilities;

@SuppressWarnings("serial")
final public class DataTableDisplay extends JTable {

    TankCalc parent;
    DataTableModel dataTableModel = null;
    int hScroll, vScroll;

    public DataTableDisplay(TankCalc p) {
        parent = p;

        // change everything except the size
        //updateDisplay();
        addFocusListener(new FocusAdapter() {
            @Override
            public void focusGained(FocusEvent e) {
                updateDisplay();
            }

            @Override
            public void focusLost(FocusEvent e) {
                hScroll = parent.tableScrollPane.getHorizontalScrollBar()
                        .getValue();
                vScroll = parent.tableScrollPane.getVerticalScrollBar()
                        .getValue();
            }
        });
        
        setToolTipText("Double-click: copy line to clipboard");
        addMouseListener(new MouseAdapter() {
            @Override
            public void mousePressed(MouseEvent me) {
                JTable table = (JTable) me.getSource();
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                if (me.getClickCount() == 2) {
                    ArrayList<String> data = dataTableModel.getRowData(row);
                    if (data != null) {
                        String s = parent.buildTSVRow(parent.strHeaderArray) + parent.buildTSVRow(data);
                        parent.copyToClipboard(s);
                    }
                }
            }
        });
    }

    protected void updateDisplay() {
        if (dataTableModel == null) {
            dataTableModel = new DataTableModel(parent, this);
            setModel(dataTableModel);

        }
        dataTableModel.updateDisplay();
        
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                parent.tableScrollPane.getHorizontalScrollBar().setValue(
                        hScroll);
                parent.tableScrollPane.getVerticalScrollBar().setValue(vScroll);
            }
        });
    }

}
