/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import tankcalc.TankCalc;

public final class UserActionManager {
    int min;
    int max;
    JTextField field = null;
    JComboBox box = null;
    TankCalc parent;

    public UserActionManager(JTextField field, int min, int max, TankCalc p) {
        this.field = field;
        this.init(min, max, p);
        this.assignHandlers(field);
    }

    public UserActionManager(JComboBox box, int min, int max, TankCalc p) {
        this.box = box;
        this.init(min, max, p);
        this.assignHandlers(box);
    }

    void init(int min, int max, TankCalc p) {
        this.parent = p;
        this.min = min;
        this.max = max;
    }

    public void assignHandlers(Component comp) {
        comp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                UserActionManager.this.handleMouseWheelMoved(evt);
            }
        });
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UserActionManager.this.handleKeyReleased(evt);
            }
        });
    }

    private void handleKeyReleased(KeyEvent evt) {
        double n = 0.0;
        double v = 1.0;
        v = evt.isShiftDown() ? v * 0.1 : v;
        v = evt.isAltDown() ? v * 0.01 : v;
        int kcode = evt.getKeyCode();
        if (kcode == 36) {
            n = 100.0;
        } else if (kcode == 35) {
            n = -100.0;
        } else if (kcode == 33) {
            n = 10.0;
        } else if (kcode == 34) {
            n = -10.0;
        } else if (kcode == 40) {
            n = -1.0;
        } else if (kcode == 38) {
            n = 1.0;
        }
        this.handleIncrement(n, v);
    }

    private void handleMouseWheelMoved(MouseWheelEvent evt) {
        double v = 1.0;
        v = evt.isShiftDown() ? v * 0.1 : v;
        v = evt.isAltDown() ? v * 0.01 : v;
        this.handleIncrement(-evt.getWheelRotation(), v);
    }

    void handleIncrement(double n, double sens) {
        if (n != 0.0) {
            if (this.field != null) {
                double dv;
                double v;
                String text = this.field.getText();
                int myMax = this.max;
                String suff = "";
                String[] array = this.findSuff(text, new String[]{"%", "d"});
                if (array != null) {
                    text = array[1];
                    suff = array[0];
                    if (suff.equals("%") && this.max == 90) {
                        myMax = 1000;
                    } else if (suff.equals("d")) {
                        myMax = 90;
                    }
                }
                v = (v = (dv = this.parent.getDouble(text)) + n * sens) < (double)this.min ? (double)this.min : v;
                v = v > (double)myMax ? (double)myMax : v;
                this.field.setText(this.parent.formatNum(v) + suff);
            } else if (this.box != null) {
                int v = this.box.getSelectedIndex();
                v = (int)((double)v + n);
                int top = this.box.getItemCount();
                v = v < 0 ? 0 : v;
                v = v >= top ? top - 1 : v;
                this.box.setSelectedIndex(v);
            }
            if (this.parent != null) {
                this.parent.setModeAndLabels();
            }
        }
    }

    private String[] findSuff(String text, String[] suff) {
        String out = null;
        for (int i = 0; i < suff.length && out == null; ++i) {
            if (!text.matches(".*" + suff[i] + ".*")) continue;
            out = suff[i];
            text = text.replaceAll(suff[i], "");
        }
        if (out == null) {
            return null;
        }
        return new String[]{out, text};
    }
}

