/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.util.Calendar;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import netscape.javascript.JSObject;
import tankcalc.StringEscapeUnescape;
import tankcalc.TankCalc;

public class TankCalcApplet
extends JApplet {
    TankCalc mainPanel = null;
    Thread cookie_thread;
    String oldCookie = null;

    @Override
    public void init() {
        try {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainPanel = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.cookie_thread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        TankCalcApplet.this.writeCookie();
                    }
                }
            };
            this.cookie_thread.start();
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TankCalcApplet.this.initComponents();
                    TankCalcApplet.this.mainPanel = new TankCalc(null, true, null);
                    TankCalcApplet.this.setContentPane(TankCalcApplet.this.mainPanel);
                    boolean verticalMode = false;
                    String s = TankCalcApplet.this.getParameter("verticalmode");
                    if (s != null) {
                        verticalMode = s.equals("true");
                    }
                    TankCalcApplet.this.mainPanel.setVerticalMode(verticalMode);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String config = TankCalcApplet.this.readCookie();
                            TankCalcApplet.this.mainPanel.setConfig(config);
                        }
                    });
                }
            });
        }
        catch (Exception ex) {
            System.out.println("applet init: " + ex);
        }
    }

    void writeCookie(String data) {
        if (data != null) {
            data = StringEscapeUnescape.stringToHex(data);
            try {
                if (data != null) {
                    JSObject document;
                    Calendar c = Calendar.getInstance();
                    c.add(2, 1);
                    String expires = "; expires=" + c.getTime().toString();
                    JSObject browser = JSObject.getWindow(this);
                    if (browser != null && (document = (JSObject)browser.getMember("document")) != null) {
                        String cookie = data + expires;
                        document.setMember("cookie", cookie);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("writeCookie failed: " + e);
            }
        }
    }

    public void writeCookie() {
        if (this.mainPanel != null) {
            String data = this.mainPanel.getConfig();
            if (data != null && this.oldCookie != null && !data.equals(this.oldCookie)) {
                this.writeCookie(data);
            }
            this.oldCookie = data;
        }
    }

    public String readCookie() {
        String result = null;
        try {
            String myCookie;
            JSObject browser = JSObject.getWindow(this);
            JSObject document = (JSObject)browser.getMember("document");
            if (document != null && (myCookie = (String)document.getMember("cookie")) != null && myCookie.length() > 0) {
                result = myCookie;
                result = result.replaceFirst("(.*?);.*", "$1");
            }
        }
        catch (Exception e) {
            System.out.println("readCookie exception: " + e);
        }
        if (result != null) {
            result = StringEscapeUnescape.hexToString(result);
        }
        return result;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }
}

