/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.util.ArrayList;
import tankcalc.CartesianPoint;
import tankcalc.Constants;
import tankcalc.IColor;
import tankcalc.ImageArray;
import tankcalc.TankProcessor;
import tankcalc.TankProperties;

public final class ImageGenerator {
    TankProcessor tvi;
    int xsteps = 0;
    int ysteps = 0;
    boolean lowRes = false;
    double sensorBoxSize = 1.0;
    int sensorConeSize = 4;
    int sensorXSteps;
    int sensorYSteps;
    int cylinderXSteps;
    ImageArray leftCap;
    ImageArray cylinder;
    ImageArray rightCap;
    ImageArray sensor;
    ArrayList<ImageArray> leftView;
    ArrayList<ImageArray> rightView;
    TankProperties sharedTP;

    public ImageGenerator(TankProcessor tproc, TankProperties stp, boolean lr) {
        this.tvi = tproc;
        this.sharedTP = stp;
        this.lowRes = lr;
    }

    void p(String s) {
        System.out.println(s);
    }

    String pn(double n) {
        return String.format("%.4f", n);
    }

    public void setDrawingScale() {
        double tolerance = 2.0;
        double me = this.tvi.maxExtent;
        double rf = this.tvi.g_R * 2.0;
        double d = me = me < rf ? rf : me;
        if (this.sharedTP.modelScaleFactor == 0.0 || me > this.sharedTP.modelOldScaleFactor * tolerance || me < this.sharedTP.modelOldScaleFactor / tolerance) {
            this.sharedTP.modelScaleFactor = me;
            this.sharedTP.modelScale = 800.0 / this.sharedTP.modelScaleFactor;
            this.sharedTP.modelTranslateX = 0.0;
            this.sharedTP.modelTranslateY = 0.0;
            this.sharedTP.modelTranslateZ = 0.0;
            this.sharedTP.modelOldScaleFactor = this.sharedTP.modelScaleFactor;
        }
        this.sharedTP.graphicPerspectiveFactor = this.sharedTP.modelScaleFactor * 3.0;
    }

    public void rebuildModel(TankProperties stp) {
        this.sharedTP = stp;
        this.setDrawingScale();
        boolean lowMode = this.lowRes && this.sharedTP.polygonMode;
        this.xsteps = lowMode ? 4 : this.sharedTP.graphicXDrawSteps;
        int n = this.ysteps = lowMode ? 32 : this.sharedTP.graphicYDrawSteps;
        this.cylinderXSteps = this.sharedTP.polygonMode ? (this.lowRes ? 1 : 8) : this.xsteps;
        this.sensorBoxSize = this.sharedTP.modelScaleFactor * 0.01;
        this.sensorXSteps = lowMode ? 8 : 16;
        this.sensorYSteps = lowMode ? 8 : 16;
        this.leftCap = new ImageArray(this.sharedTP.graphicDrawLeftCap, this.xsteps, this.ysteps);
        this.cylinder = new ImageArray(this.sharedTP.graphicDrawCylinder, this.cylinderXSteps, this.ysteps);
        this.rightCap = new ImageArray(this.sharedTP.graphicDrawRightCap, this.xsteps, this.ysteps);
        this.sensor = new ImageArray(this.sharedTP.graphicDrawSensor, this.sensorXSteps, this.sensorYSteps);
        this.genEndCap(this.leftCap, -(this.tvi.halfCylinder + this.tvi.g_rL), -this.tvi.halfCylinder, this.sharedTP.leftEndCapMode, false, this.tvi.g_rL, this.tvi.g_rLSign, this.tvi.leftMajorSphereRadius, Constants.leftCapColor, 1.0);
        this.genCylinder(this.cylinder, -this.tvi.halfCylinder, this.tvi.halfCylinder, this.tvi.g_R, 1.0);
        this.genEndCap(this.rightCap, this.tvi.halfCylinder, this.tvi.halfCylinder + this.tvi.g_rR, this.sharedTP.rightEndCapMode, true, this.tvi.g_rR, this.tvi.g_rRSign, this.tvi.rightMajorSphereRadius, Constants.rightCapColor, 1.0);
        this.genSensor(this.sensor, 1.0);
        this.rotateDataSet(this.leftCap);
        this.rotateDataSet(this.cylinder);
        this.rotateDataSet(this.rightCap);
        this.leftCap.createPolygons();
        this.cylinder.createPolygons();
        this.rightCap.createPolygons();
        this.sensor.createPolygons();
        this.leftView = new ArrayList();
        this.rightView = new ArrayList();
        this.leftView.add(this.sensor);
        this.rightView.add(this.sensor);
        this.rightView.add(this.rightCap);
        this.leftView.add(this.leftCap);
        this.rightView.add(this.cylinder);
        this.leftView.add(this.cylinder);
        this.leftView.add(this.rightCap);
        this.rightView.add(this.leftCap);
    }

    void rotateDataSet(ImageArray set) {
        if (set.isActive()) {
            double sa = Math.sin(this.sharedTP.angleRadians);
            double ca = Math.cos(this.sharedTP.angleRadians);
            CartesianPoint[][] cartesianPointArray = set.point;
            int n = cartesianPointArray.length;
            for (int i = 0; i < n; ++i) {
                CartesianPoint[] row;
                for (CartesianPoint p : row = cartesianPointArray[i]) {
                    if (p == null) continue;
                    double x = p.x;
                    double y = p.y;
                    p.y = x * sa + y * ca;
                    p.x = x * ca - y * sa;
                }
            }
        }
    }

    void genSensor(ImageArray set, double alpha) {
        if (set.isActive()) {
            double radius;
            double sr = 0.0;
            switch (this.sharedTP.sensorOrientation) {
                case 0: {
                    sr = 0.0;
                    break;
                }
                case 1: {
                    sr = -this.sharedTP.angleRadians;
                    break;
                }
                case 2: {
                    sr = -this.sharedTP.angleRadians + 1.5707963267948966;
                }
            }
            double ssv = Math.sin(sr);
            double scv = Math.cos(sr);
            double tankLen = this.tvi.g_L + this.tvi.g_rL + this.tvi.g_rR;
            double ystep = Math.PI * 2 / (double)this.sensorYSteps;
            for (int x = 0; x <= this.sensorConeSize; ++x) {
                CartesianPoint[] row = set.point[x];
                radius = (double)x * this.sensorBoxSize / (double)this.sensorConeSize;
                boolean start = true;
                for (int y = 0; y <= this.sensorYSteps; ++y) {
                    double ar = (double)y * ystep;
                    double sv = Math.sin(ar);
                    double cv = Math.cos(ar);
                    double xv = radius * cv;
                    double yv = radius;
                    row[y] = new CartesianPoint(this.tvi.trueSensorPositionX + xv * scv + yv * ssv, this.tvi.trueSensorPositionY + yv * scv - xv * ssv, -(this.tvi.trueSensorPositionZ + radius * sv), start, Constants.sensorColor, alpha);
                    start = false;
                }
            }
            int sensorPathSteps = this.sensorXSteps - (this.sensorConeSize + 1);
            radius = this.sensorBoxSize * (this.sharedTP.polygonMode ? 0.25 : 0.01);
            for (int x = 0; x <= sensorPathSteps; ++x) {
                double sensorPos = (double)x / (double)sensorPathSteps;
                CartesianPoint[] row = set.point[x + this.sensorConeSize + 1];
                boolean start = true;
                for (int y = 0; y <= this.sensorYSteps; ++y) {
                    CartesianPoint p;
                    double ar = (double)y * ystep;
                    double sv = Math.sin(ar);
                    double cv = Math.cos(ar);
                    double xv = radius * cv;
                    double yv = this.sensorBoxSize + (tankLen - this.sensorBoxSize) * sensorPos;
                    row[y] = p = new CartesianPoint(this.tvi.trueSensorPositionX + xv * scv + yv * ssv, this.tvi.trueSensorPositionY + yv * scv - xv * ssv, -(this.tvi.trueSensorPositionZ + radius * sv), start, Constants.sensorColor, alpha);
                    start = false;
                }
            }
        }
    }

    void genEndCap(ImageArray set, double ax, double bx, int endCapMode, boolean rev, double g_r, double g_rSign, double sphereRadius, IColor color, double alpha) {
        if (set.isActive()) {
            if (g_r == 0.0) {
                bx = ax + 0.001;
                g_r = 0.001;
                endCapMode = 0;
            }
            double xstep = g_r / (double)this.xsteps;
            double ystep = Math.PI * 2 / (double)this.ysteps;
            for (int x = 0; x <= this.xsteps; ++x) {
                CartesianPoint[] row = set.point[x];
                double xcoord = ax + (double)x * xstep;
                double radius = this.endCapRadius(xcoord, ax, bx, endCapMode, rev, g_r, sphereRadius);
                boolean start = true;
                for (int y = 0; y <= this.ysteps; ++y) {
                    CartesianPoint p;
                    double ar = (double)y * ystep;
                    row[y] = p = new CartesianPoint(xcoord, Math.cos(ar) * radius, Math.sin(ar) * radius * this.sharedTP.scalingFactor, start, color, alpha);
                    start = false;
                }
            }
        }
    }

    void genCylinder(ImageArray set, double ax, double bx, double radius, double alpha) {
        if (set.isActive()) {
            double xstep = (bx - ax) / (double)this.cylinderXSteps;
            double ystep = Math.PI * 2 / (double)this.ysteps;
            CartesianPoint[] row = null;
            for (int x = 0; x <= this.cylinderXSteps; ++x) {
                try {
                    row = set.point[x];
                }
                catch (Exception e) {
                    break;
                }
                double xcoord = (double)x * xstep + ax;
                boolean start = true;
                for (int y = 0; y <= this.ysteps; ++y) {
                    double ar = (double)y * ystep;
                    double car = Math.cos(ar) * radius;
                    double sar = Math.sin(ar) * radius * this.sharedTP.scalingFactor;
                    row[y] = new CartesianPoint(xcoord, car, sar, start, Constants.cylinderColor, alpha);
                    start = false;
                }
            }
        }
    }

    double endCapRadius(double x, double ax, double bx, int endCapMode, boolean rev, double g_r, double sphereRadius) {
        double radius = 0.0;
        double rt2 = g_r * 2.0;
        double range = bx - ax;
        double ratio = this.tvi.g_R / g_r;
        x = x > bx ? bx : x;
        switch (endCapMode) {
            case 0: {
                double delta = rev ? g_r : 0.0;
                double x2 = x - ax + delta;
                double invx = rt2 - x2;
                radius = Math.sqrt(invx * x2) * ratio;
                break;
            }
            case 1: {
                double delta = rev ? g_r : 0.0;
                double x2 = x - ax + delta;
                double invx = rt2 - x2;
                radius = (invx < x2 ? invx : x2) * ratio;
                break;
            }
            case 2: {
                double delta = rev ? sphereRadius - range : -sphereRadius;
                double srsq = sphereRadius * sphereRadius;
                double x2 = x - ax + delta;
                radius = Math.sqrt(srsq - x2 * x2);
            }
        }
        radius = Double.isNaN(radius) ? 0.0 : radius;
        return radius;
    }
}

