/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef THUMBCREATIONTHREAD_H
#define THUMBCREATIONTHREAD_H

#include <qthread.h>
#include <qprogressbar.h>
#include <qdir.h>
#include <string>
#include <iostream>
#include <fstream>

using namespace std;

/**
@author Paul Lutus
*/
class ThumbCreationThread : public QThread
{
public:
    ThumbCreationThread();

    ~ThumbCreationThread();
    
    string dir;
    QProgressBar *pbar;
    int iconSize;
    bool createAll;
    
    void execute(string dir, QProgressBar *dpb,int ics,bool ca);
    
    void makeThumbnailDirThread();
    
    void run();
    
    bool fileExists(string path);

};

#endif
