/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SLIDEPROJECTOR_H
#define SLIDEPROJECTOR_H

#include "SlideProjectorGUI.h"

#include <iostream>
#include <string>
#include <map>
#include <fstream>
#include <dirent.h>
#include <vector>
#include <algorithm>
#include <cctype>
#include <functional>

#include <cstdio>
#include <qpixmap.h>
#include <qimage.h>
#include <qlabel.h>
#include "myqlabel.h"
#include "imagefilehandler.h"
#include "helpwidget.h"
#include "initfilehandler.h"

#include <dcopobject.h>

//#include <dcopclient.h>

class IconEditor;

using namespace std;

typedef map<string,string> MSS;
typedef map<string,MSS> MMSS;

class SlideProjector : public SlideProjectorMainFrame, virtual public DCOPObject
{
  Q_OBJECT
  K_DCOP


public:

  SlideProjector(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~SlideProjector();
  /*$PUBLIC_FUNCTIONS$*/

  MyQLabel *myql_norm,*myql_full;
  QWidget *dupWidget;
  QGridLayout *dupLayout;

  QImage *editPreviewImage;

  HelpWidget *helpwidget;

  IconEditor *iconEditor;

  ImageFileHandler *imghandler;

  QTimer *autoShowTimer;

  bool zoom;
  bool rightMouseZooms;

  InitFileHandler *initHandler;
  void keyPressEvent(QKeyEvent *e);
  void closeEvent ( QCloseEvent * e );
  void updateImages(QImage *im,bool fe);
  void updateImages2(QImage *im,bool fe);
  QSize normalSize;
  QPoint normalPos;
  int screenMode;
  string usrPath,progPath;
  string lastImageDirectory;
  int toggleImage;
  int editIconSize;
  int editSlideDuration;
  int autoShowSlideDuration;
  bool autoShowRepeat;
  bool borderFrame;
  bool active;


  static const string programName;
  static const string programVersion;
  static const string thumbDirName;
  static const string thumbFilePrefix;
  static const string dummyShowName;
  static const string extensionsScriptName;

  void selectShow(string name);
  void showEditPreviewImage(string path);
  void testRefreshAfterSave(string name);
  void setupList();
  void readConfigFile();
  void writeConfigFile();
  void setImageDisplay();
  void toggleZoom();
  void rightMouseAction();
  void stopAutoSlideShow(bool setMode0);
  void manageExtensions(QImage *im,bool fromEditor);

k_dcop:

  void selectShow(QString name);
  void calibrateAction();
  void setDeltaImage(int i);
  void setImage(int i);
  void setLastImage();
  void setFirstImage();
  void toggleKeyImage();
  void launchHelp();
  void showEditor();
  void setDisplayMode(int);
  QString getShowList();
  int getImageCount();
  int getCurrentImage();
  void setAutoShowRepeat(bool);
  void setAutoShowSlideDuration(int d);
  void startAutoSlideShow();
  void stopAutoSlideShow();

public slots:

  /*$PUBLIC_SLOTS$*/

  void EditButton();
  void showChosen();
  void helpButton();
  void screen0Button();
  void screen1Button();
  void screen2Button();
  void screen3Button();
  void quitButton();
  void borderframeCheckBox_clicked();
  void calibrateButton();
  void slideDurationChanged();
  void newAutoSlideDuration();
  void iconSizeChanged();
  void newAutoShowRepeat();
  void startAutoShow();
  void autoShowNextSlide();
  void contextMenuEvent( QContextMenuEvent * e);
  void zoomRadioButton(int);

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/

};

#endif

