/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@pl-alpha                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MYICONVIEW_H
#define MYICONVIEW_H

#include <qapplication.h>
#include <qobject.h>
#include <qcursor.h>
#include <qsplitter.h>
#include <qlistbox.h>
#include <qiconview.h>
#include <qpixmap.h>
#include <string>
#include <qtooltip.h>
#include <qsplitter.h>
#include <qdir.h>
#include <qtimer.h>
#include <qpopupmenu.h>
#include <string>
#include <vector>
#include "thumbcreationthread.h"

using namespace std;

class QDragEnterEvent;
class QDragDropEvent;

class MyIconViewItem;
class SlideProjector;
class IconEditor;

typedef vector <string> VS;
typedef vector <VS> VVS;


/**
@author Paul Lutus
*/
class MyIconView : public QIconView {
    Q_OBJECT
public:
    MyIconView( QWidget * parent = 0, IconEditor *p1 = 0,SlideProjector *p2 = 0,const char *whatsthisText = 0,const char* path = 0,const char * name = 0, WFlags f = 0 );
    //MyIconView();

    ~MyIconView();
    
    string showName;
    
    string listFilePath;
    string dirPath;
    
    IconEditor *ieparent;
    SlideProjector *spparent;
    
    ThumbCreationThread *tcthread;
    
    VVS undoVec,redoVec;
    
    bool changed;
    
    QDragObject *dragObject();
    //string instanceName;
    QIconViewItem *mouseOverItem;
    void loadImagesFromDirectory(string path);
    void makeThumbnailDir(string d1,bool ca);
    void queryThumbnailDir(string d1,bool ca);
    bool loadImagesFromListFile(string path,string n);
    void saveImagesToListFile();
    //void showContextMenu();
    void insertIconViewItem(string path, MyIconViewItem *pi);
    vector <MyIconViewItem *> getSelectedItems();
    void deleteItems(vector <MyIconViewItem *> deletes);
    void insertItems(string data);
    string makeClipString(vector <MyIconViewItem *> sels);
    void setChanged(bool v);
    void newListFile(string path,string n);
    bool fileExists(string path);
    void clearPanel();
    bool testOpen();
    void pushUndo();
    void pushRedo();
    void pushUndoRedo(VVS& vec);
    
    
    
public slots:
    void slotNewItem( QDropEvent *, const QValueList<QIconDragItem>& );
    void slotMoved();
    void slotOnItem(QIconViewItem*);
    void slotOnViewport();
    //void slotPressed(QIconViewItem*);
    void contextMenuEvent( QContextMenuEvent * );
    void keyPressEvent(QKeyEvent *e);
    void selectAllItems();
    void copy();
    void cut();
    void paste();
    void undo();
    void redo();
    void showPreview();
    void showPreview(QIconViewItem *item);

private:

};

#endif
