/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SIGNALGEN_H
#define SIGNALGEN_H

#include "SignalGenGUI.h"
#include <string>
#include <sstream>
#include "initfilehandler.h"

using namespace std;

class OscillatorAudioDriver;
class OscillatorDisplayDriver;

class SignalGen : public MainFrame {
    Q_OBJECT

public:
    SignalGen(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~SignalGen();
    /*$PUBLIC_FUNCTIONS$*/

    bool isRunning;
    bool enabled;
    bool closing;

    void restart();
    
    InitFileHandler *initHandler;

    static const string programName;
    static const string programVersion;

    static const char *waveList[];

    static const char *scopeList[];

    static const double scopeRates[];

    string devicename;
    string usrPath,progPath;
    double freqn;
    double basefreq;
    int waveform;
    int scopeRange;
    int sampleRate;
    double level;
    OscillatorAudioDriver *osc;
    OscillatorDisplayDriver *odd;
    void newStart(bool);
    void initialize();
    void shutdownOsc(bool);
    void reviseSampleRate(int v);
    void writeVals();
    void readVals();
    void readConfig();
    void writeConfig();
    void setApplyButtonState(bool s);
    void setDefaults();


public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void          OffCommand();
    virtual void          LevelChanged(int);
    //virtual void          DeviceChanged();
    //virtual void          WaveformChanged(int);
    //virtual void          FreqChanged();
    virtual void          FreqSliderChanged(int);
    virtual void          ScopeComboboxChanged(int);
    //virtual void          sampleRateChanged();
    virtual void          OnCommand();
    virtual void          AboutButtonPressed();
    virtual void applyPressed();
    virtual void enableApply();
    void waveformChanged();

protected:
    /*$PROTECTED_FUNCTIONS$*/


    void closeEvent ( QCloseEvent * e );

    void setup();

protected slots:
    /*$PROTECTED_SLOTS$*/

};

#endif

