/*
 * Decompiled with CFR 0.152.
 */
import java.util.GregorianCalendar;

public final class ReportDesignData {
    String reportFileName;
    public String fullPath;
    public String webPagePath;
    public String tsvPagePath;
    PLCash parent;
    public String db_reportTitle;
    public boolean db_listAllAccounts = false;
    public boolean db_listSubCategories = false;
    public boolean db_CategoryReportFormat = true;
    public boolean db_enableSearching = false;
    public boolean db_extendedFormat = true;
    public boolean db_showIncomeCat = true;
    public boolean db_showExpenseCat = true;
    public boolean db_showTaxableCat = true;
    public boolean db_filterIncomeItem = true;
    public boolean db_filterExpenseItem = true;
    public boolean db_filterTaxableItem = true;
    public boolean db_filterDepositItem = true;
    public boolean db_filterOutlayItem = true;
    public boolean db_filterTransferItem = true;
    public String db_accounts = "";
    public String db_categories = "";
    public String db_searches = "";
    public int db_interval = 5;
    public int db_period = 7;
    public long db_startDate = 0L;
    public long db_endDate = 0L;

    public ReportDesignData(PLCash pLCash, String string) {
        this.parent = pLCash;
        this.rename(string);
        this.init(pLCash);
    }

    public void rename(String string) {
        this.db_reportTitle = string;
        this.reportFileName = string.replaceAll("[\\W|\\s]", "_");
        this.setPath();
    }

    private void init(PLCash pLCash) {
        this.setPath();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.db_endDate = this.db_startDate = gregorianCalendar.getTimeInMillis();
    }

    private void setPath() {
        String string = this.parent.programValues.db_ReportFilePath + this.parent.commonCode.fileSep + this.reportFileName;
        this.fullPath = string + ".txt";
        string = this.parent.programValues.db_ReportWebPageFilePath + this.parent.commonCode.fileSep + this.reportFileName;
        this.webPagePath = string + ".html";
        this.tsvPagePath = string + ".csv";
    }

    public void writeValues() {
        this.parent.dataFileManager.writeObjectToFile(this.fullPath, this, "db_");
    }

    public void readValues() {
        this.parent.dataFileManager.readObjectFromFile(this.fullPath, this, "db_");
    }

    public void readValues(String string) {
        this.parent.dataFileManager.readObjectFromFile(string, this, "db_");
    }

    public String[] getAccountList() {
        String[] stringArray = this.db_accounts.split("\t");
        return stringArray;
    }

    public String[] getCategoryList() {
        return this.db_categories.split("\t");
    }

    public String[] getSearchList() {
        return this.db_searches.split("\t");
    }

    public void setAccountList(String[] stringArray) {
        this.db_accounts = this.parent.commonCode.join(stringArray, "\t");
    }

    public void setSearchList(String[] stringArray) {
        this.db_searches = this.parent.commonCode.join(stringArray, "\t");
    }

    public void setCategoryList(String[] stringArray) {
        this.db_categories = stringArray != null ? this.parent.commonCode.join(stringArray, "\t") : "";
    }
}

