/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TreeMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public final class Prices
extends EditableList {
    String fileName = "priceHistoryList.tsv";

    public Prices(PLCash pLCash) {
        super(pLCash);
    }

    public void readTSV(String string) {
        this.readTSV(string, this.fileName, this.dataVector, (Object)new PricesItem(this.parent), "db_");
    }

    public void writeTSV(String string) {
        this.writeTSV(string, this.fileName, this.dataVector, (Object)new PricesItem(this.parent), "db_");
    }

    public void displayData() {
        this.displayVector("Price History", this, "db_");
    }

    public void createFromQIFData(TreeMap treeMap) {
        if (treeMap.size() > 0) {
            String string = this.parent.commonCode.safeTreeGet(treeMap, "\"");
            String[] stringArray = (string = string.replaceAll("\"", "")).split(",");
            if (stringArray.length == 3) {
                PricesItem pricesItem = new PricesItem(this.parent);
                pricesItem.db_Symbol = stringArray[0].trim();
                long l = this.parent.commonCode.timeForQIFDate(stringArray[2].trim());
                pricesItem.db_Date = this.parent.commonCode.dbDateForTime(l);
                pricesItem.setTime(l);
                String string2 = stringArray[1].trim();
                pricesItem.db_Price = this.parseFraction(string2);
                this.addPricesItem(pricesItem);
            }
        }
    }

    public void addPricesItem(PricesItem pricesItem) {
        this.addItem(pricesItem);
    }

    public void addPricesItemRemoveDups(PricesItem pricesItem) {
        int n = this.getVectorSize();
        PricesItem pricesItem2 = null;
        for (int i = n - 1; i >= 0; --i) {
            pricesItem2 = (PricesItem)this.getDataObject(i);
            if (!pricesItem.db_Symbol.equals(pricesItem2.db_Symbol) || !pricesItem.db_Date.equals(pricesItem2.db_Date)) continue;
            this.deleteVectorObject(pricesItem2);
        }
        this.addItem(pricesItem);
    }

    private double parseFraction(String string) {
        double d = 0.0;
        String[] stringArray = string.split("\\s+");
        if (stringArray.length > 1) {
            d = this.parent.commonCode.getDouble(stringArray[0].trim());
            double d2 = 0.0;
            String[] stringArray2 = stringArray[1].split("/");
            if (stringArray2.length > 1) {
                double d3 = this.parent.commonCode.getDouble(stringArray2[0].trim());
                double d4 = this.parent.commonCode.getDouble(stringArray2[1].trim());
                d2 = d3 / d4;
            } else {
                d2 = this.parent.commonCode.getDouble(stringArray[1].trim());
            }
            d += d2;
        } else {
            d = this.parent.commonCode.getDouble(string);
        }
        return d;
    }

    @Override
    public boolean allowEditRecords(int n) {
        return true;
    }

    @Override
    public Object getDataObject(String string) {
        return new PricesItem(this.parent);
    }

    @Override
    public Object getDataObject(int n) {
        if (n >= this.dataVector.size()) {
            return new PricesItem(this.parent);
        }
        return this.dataVector.get(n);
    }

    @Override
    public boolean allowCreateDeleteRecords() {
        return true;
    }

    public void importPrices() {
        File file;
        String string;
        String string2 = this.parent.programValues.db_PriceQuoteFilePath;
        if (string2.length() == 0) {
            string2 = ".";
        }
        if ((string = (file = new File(string2)).getParent()) != null) {
            file = new File(string);
        }
        JFileChooser jFileChooser = new JFileChooser();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("txt");
        exampleFileFilter.addExtension("text");
        exampleFileFilter.addExtension("csv");
        exampleFileFilter.addExtension("tsv");
        exampleFileFilter.setDescription("Price Quote Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(this.parent);
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            if (fileArray == null || fileArray.length == 0) {
                fileArray = new File[]{jFileChooser.getSelectedFile()};
            }
            if (fileArray != null && fileArray.length > 0) {
                this.parent.programValues.db_PriceQuoteFilePath = fileArray[0].getPath();
                int n2 = this.readPriceFileList(fileArray);
                JOptionPane.showMessageDialog(null, "Successfully imported " + n2 + " prices.", "Price import results", 0);
                if (n2 > 0) {
                    this.updatePrices();
                }
            }
        }
    }

    private int readPriceFileList(File[] fileArray) {
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            n += this.readPriceFile(fileArray[i]);
        }
        return n;
    }

    private int readPriceFile(File file) {
        int n = 0;
        String string = this.parent.commonCode.readFile(file);
        string = string.replaceAll("\r", "\n");
        String[] stringArray = (string = string.replaceAll("\n+", "\n")).split("\n");
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                n += this.readPriceRecord(stringArray[i].trim());
            }
        }
        return n;
    }

    private int readPriceRecord(String string) {
        int n = 0;
        String[] stringArray = null;
        string = string.replaceAll("(\\d+),(\\d+)", "$1###$2");
        string = string.replaceAll("\t", " ");
        string = string.replaceAll(",", " ");
        string = string.replaceAll(" +", " ");
        string = string.replaceAll("(\\d+)###(\\d+)", "$1,$2");
        string = string.trim();
        this.parent.p(string);
        stringArray = string.split(" ");
        if (stringArray != null && stringArray.length > 1) {
            String string2;
            Double d;
            this.trimFields(stringArray);
            String string3 = stringArray[0].toUpperCase();
            if (string3.length() > 0 && (d = this.parsePriceString(string2 = stringArray[1])) != null) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                long l = gregorianCalendar.getTimeInMillis();
                if (stringArray.length > 2) {
                    long l2 = this.parent.commonCode.timeForDisplayDateLenient(stringArray[2]);
                    l = l2 > 0L ? l2 : new Date().getTime();
                }
                PricesItem pricesItem = new PricesItem(this.parent, string3, (double)d, l);
                this.addPricesItemRemoveDups(pricesItem);
                ++n;
            }
        }
        return n;
    }

    private Double parsePriceString(String string) {
        Double d = null;
        double d2 = this.parent.commonCode.getDouble(string);
        if (d2 > 0.0) {
            d = new Double(d2);
        }
        return d;
    }

    private void trimFields(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = (string = string.trim()).length();
            if (n > 0 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
                string = string.substring(1, n - 1);
            }
            stringArray[i] = string;
        }
    }

    public void updatePrices() {
        this.sortVector(true);
        Account[] accountArray = this.parent.accountHandler.getAccountList(true);
        for (int i = 0; i < accountArray.length; ++i) {
            Account account = accountArray[i];
            this.updateAccountPrice(account);
            if (account.accountDisplay == null) continue;
            account.accountDisplay.setupDisplay();
        }
        this.parent.accountPanel.setupTable();
        this.parent.accountPanel.repaint();
    }

    private void updateAccountPrice(Account account) {
        if (account.type == 3) {
            account.getBalance();
            String string = this.parent.securityHandler.getSymbolForSecurity(account.db_Security);
            if (string.length() > 0) {
                PricesItem pricesItem = new PricesItem(this.parent, string, account.db_MostRecentAccountPrice, account.db_MostRecentAccountPriceDate);
                pricesItem = this.getMostRecentPrice(pricesItem);
                account.db_MostRecentPrice = pricesItem.db_Price;
                account.db_MostRecentPriceDate = pricesItem.getTime();
                account.adjustPriceComputeBalance();
            }
        }
    }

    private PricesItem getMostRecentPrice(PricesItem pricesItem) {
        int n = 0;
        int n2 = this.getVectorSize();
        PricesItem pricesItem2 = null;
        for (int i = 0; i < n2; ++i) {
            pricesItem2 = (PricesItem)this.getDataObject(i);
            if (n == 0 && pricesItem.db_Symbol.equals(pricesItem2.db_Symbol)) {
                ++n;
            }
            if (n != 1) continue;
            if (!pricesItem.db_Symbol.equals(pricesItem2.db_Symbol)) {
                pricesItem2 = i > 0 ? (PricesItem)this.getDataObject(i - 1) : pricesItem;
                ++n;
                break;
            }
            if (i != n2 - 1) continue;
            pricesItem2 = i >= 0 ? (PricesItem)this.getDataObject(i) : pricesItem;
            ++n;
            break;
        }
        if (n == 2 && pricesItem2.getTime() > pricesItem.getTime()) {
            return pricesItem2;
        }
        return pricesItem;
    }
}

