/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/*
 * PLCalcMainPanel.java
 *
 * Created on Feb 7, 2009, 8:28:41 AM
 */
package plcalc;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.lang.Thread.*;
import java.text.*;
import java.util.*;

/**
 *
 * @author lutusp
 */
public class PLCalcMainPanel extends javax.swing.JPanel {

    public String programName = "PLCalc";
    public String programVersion = "2.4";
    int activeTab;
    Calculator calc;
    Finance finance;
    Statistics stat;
    Units units;
    BaseConv basec;
    NumberFormat numberFormat;
    Locale locale;
    char radixChar;

    /** Creates new form PLCalcMainPanel */
    public PLCalcMainPanel() {
        // just for locale testing, normally commented out
        // Locale.setDefault(Locale.GERMANY);
        locale = Locale.getDefault();
        initComponents();
        radixChar = new DecimalFormatSymbols(locale).getDecimalSeparator();
        numberFormat = NumberFormat.getInstance();
        calc = new Calculator(this);
        finance = new Finance(this);
        basec = new BaseConv(this);
        setupValues();
        stat = new Statistics(this);
        units = new Units(this);
    }

    void setupValues() {
        calc.clearStack(false);
        DecPlacesCombo.removeAllItems();
        for (int i = 0; i <= 16; i++) {
            DecPlacesCombo.addItem(i);
        }
        DecPlacesCombo.setSelectedItem(4);
        InputModeComboBox.removeAllItems();
        for (int i = 0; i < calc.entryModes.length; i++) {
            InputModeComboBox.addItem(calc.entryModes[i]);
        }
        loadHelpFile(FinanceTextArea, "finance_help.txt");
        loadHelpFile(StatisticsTextArea, "statistics_help.txt");
        loadHelpFile(BaseTextArea, "baseconv_help.txt");
        loadHelpFile(HelpTextArea, "help_text.txt");
        setPaneTab(0);
        // all this just to reliably set focus ...
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                EntryTextField.requestFocus();
            }
        });
    }

    void loadHelpFile(JTextArea ta, String fn) {
        StringBuffer buff = new StringBuffer();
        InputStream in = getClass().getResourceAsStream(fn);
        BufferedReader bis = new BufferedReader(new InputStreamReader(in));
        String line;
        try {
            while ((line = bis.readLine()) != null) {
                buff.append(line + "\n");
            }
        } catch (Exception e) {
        }
        String out = buff.toString();
        out = out.replaceAll("<program>", programName);
        out = out.replaceAll("<version>", programVersion);
        ta.setText(out);
        ta.setSelectionStart(0);
        ta.setSelectionEnd(0);
    }

    void setPaneTab(int n) {
        if (n == -1) {
            n = TabbedPane.getSelectedIndex();
        } else {
            TabbedPane.setSelectedIndex(n);
        }
        activeTab = n;
        InputModeComboBox.setVisible(n == 0);
        if (n == 0 && calc != null) {
            calc.showStackDisp();
        }
        if (n == 3) {
            DecimalField.requestFocus();
        }
    }

    void setStatus(String s, boolean error) {
        StatusLabel.setText(s);
        if (error) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int getDecPlaces() {
        Integer n = (Integer) DecPlacesCombo.getSelectedItem();
        if (n == null) {
            n = 0;
        }
        return n;
    }

    public String getCurrentFormat() {
        int n = getDecPlaces();
        String fmt = "%." + n;
        if (AllRadioButton.isSelected()) {
            fmt += "g";
        } else if (FixRadioButton.isSelected()) {
            fmt += "f";
        } else if (SciRadioButton.isSelected()) {
            fmt += "e";
        }
        return fmt;
    }

    public boolean isAllFormat() {
        return AllRadioButton.isSelected();
    }

    // force locale obedience
    public String specialFormat(String fmt, double v) {
        String ns = String.format(locale, fmt, v);
        ns = ns.replaceAll("\\.", "" + radixChar);
        return ns;
    }

    double getDoubleThrowsException(String s) throws Exception {
        double v = 0;
        double e;
        // deal with possibility of exponent
        // which numberformat cannot process
        s = s.toLowerCase();
        String[] array = s.split("e");
        v = numberFormat.parse(array[0]).doubleValue();
        if (array.length > 1) {
            // get signed exponent
            String es = array[1].replaceFirst("\\+","");
            e = numberFormat.parse(es).doubleValue();
            v *= Math.pow(10, e);
        }
        return v;
    }

    double getDouble(String s) {
        double v = 0;
        double e;
        try {
            v = getDoubleThrowsException(s);
        } catch (Exception ex) {
            System.out.println(getClass().getName() + ".getDouble: Error: " + ex);
        }
        return v;
    }

    public double getNum(JTextField f) {
        double v = 0.0;
        try {
            v = getDouble(f.getText());
        } catch (NumberFormatException e) {
        }
        return v;
    }

    void displayOptionsChanged() {
        if (calc != null) {
            calc.showStackDisp();
        }
        if (units != null) {
            units.acceptConversion();
        }
    }

    void testUnitsAcceptConversion() {
        if (units != null) {
            units.acceptConversion();
        }
    }

    public void beep() {
        // a way to trace random program beeps
        //System.out.println(getStackTrace());
        Toolkit.getDefaultToolkit().beep();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        FixSciButtonGroup = new javax.swing.ButtonGroup();
        payButtonGroup = new javax.swing.ButtonGroup();
        NumFormatPane = new javax.swing.JPanel();
        FixRadioButton = new javax.swing.JRadioButton();
        SciRadioButton = new javax.swing.JRadioButton();
        DecPlacesCombo = new javax.swing.JComboBox();
        AllRadioButton = new javax.swing.JRadioButton();
        InputModeComboBox = new javax.swing.JComboBox();
        TabbedPane = new javax.swing.JTabbedPane();
        calcPanel = new javax.swing.JPanel();
        StackDisplayPane = new javax.swing.JPanel();
        ZTextField = new javax.swing.JTextField();
        YTextField = new javax.swing.JTextField();
        XTextField = new javax.swing.JTextField();
        EntryTextField = new javax.swing.JTextField();
        TTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        SinButton = new javax.swing.JButton();
        CosButton = new javax.swing.JButton();
        TanButton = new javax.swing.JButton();
        ytoXButton = new javax.swing.JButton();
        ASinButton = new javax.swing.JButton();
        ACosButton = new javax.swing.JButton();
        ATanButton = new javax.swing.JButton();
        SqrtButton = new javax.swing.JButton();
        LnXButton = new javax.swing.JButton();
        etoxButton = new javax.swing.JButton();
        logXButton = new javax.swing.JButton();
        tenXButton = new javax.swing.JButton();
        ChsButton = new javax.swing.JButton();
        dropButton = new javax.swing.JButton();
        InvXButton = new javax.swing.JButton();
        swapButton1 = new javax.swing.JButton();
        ClearButton = new javax.swing.JButton();
        drButton = new javax.swing.JButton();
        rdButton = new javax.swing.JButton();
        piButton = new javax.swing.JButton();
        eButton = new javax.swing.JButton();
        x2Button = new javax.swing.JButton();
        yrx = new javax.swing.JButton();
        AddButton = new javax.swing.JButton();
        SubButton = new javax.swing.JButton();
        MultButton = new javax.swing.JButton();
        DivButton = new javax.swing.JButton();
        EnterButton = new javax.swing.JButton();
        financePanel = new javax.swing.JPanel();
        IRButton = new javax.swing.JButton();
        FVButton = new javax.swing.JButton();
        PVButton = new javax.swing.JButton();
        NPButton = new javax.swing.JButton();
        PMTButton = new javax.swing.JButton();
        FVField = new javax.swing.JTextField();
        IRField = new javax.swing.JTextField();
        PVField = new javax.swing.JTextField();
        NPField = new javax.swing.JTextField();
        PMTField = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        FinanceTextArea = new javax.swing.JTextArea();
        paymentTypePanel = new javax.swing.JPanel();
        PayBeginButton = new javax.swing.JRadioButton();
        PayEndButton = new javax.swing.JRadioButton();
        statPanel = new javax.swing.JPanel();
        MeanField = new javax.swing.JTextField();
        SDField = new javax.swing.JTextField();
        PopField = new javax.swing.JTextField();
        aField = new javax.swing.JTextField();
        bField = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        resultField = new javax.swing.JTextField();
        resultButton = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        StatisticsTextArea = new javax.swing.JTextArea();
        unitsPanel = new javax.swing.JPanel();
        unitsButtonPanel1 = new javax.swing.JPanel();
        unitsButtonPanel2 = new javax.swing.JPanel();
        unitsIOPanel = new javax.swing.JPanel();
        unitsInputPanel = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        unitsInputField = new javax.swing.JTextField();
        inputUnitLabel = new javax.swing.JLabel();
        unitsOutputPanel = new javax.swing.JPanel();
        jLabel16 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();
        outputListScrollPane = new javax.swing.JScrollPane();
        outputUnitsList = new javax.swing.JList();
        BasePanel = new javax.swing.JPanel();
        BinaryField = new javax.swing.JTextField();
        OctalField = new javax.swing.JTextField();
        DecimalField = new javax.swing.JTextField();
        HexField = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        BaseTextArea = new javax.swing.JTextArea();
        helpPanel = new javax.swing.JPanel();
        jScrollPane5 = new javax.swing.JScrollPane();
        HelpTextArea = new javax.swing.JTextArea();
        StatusLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        NumFormatPane.setLayout(new java.awt.GridBagLayout());

        FixSciButtonGroup.add(FixRadioButton);
        FixRadioButton.setText("Fixed");
        FixRadioButton.setToolTipText("Fixed-point number formatting");
        FixRadioButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                FixRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        NumFormatPane.add(FixRadioButton, gridBagConstraints);

        FixSciButtonGroup.add(SciRadioButton);
        SciRadioButton.setText("Scientific");
        SciRadioButton.setToolTipText("Scientific number formatting");
        SciRadioButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SciRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        NumFormatPane.add(SciRadioButton, gridBagConstraints);

        DecPlacesCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        DecPlacesCombo.setToolTipText("Displayed decimal places");
        DecPlacesCombo.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                DecPlacesComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        NumFormatPane.add(DecPlacesCombo, gridBagConstraints);

        FixSciButtonGroup.add(AllRadioButton);
        AllRadioButton.setSelected(true);
        AllRadioButton.setText("All");
        AllRadioButton.setToolTipText("General number formatting");
        AllRadioButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                AllRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        NumFormatPane.add(AllRadioButton, gridBagConstraints);

        InputModeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        InputModeComboBox.setToolTipText("Entry/display mode");
        InputModeComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                InputModeComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        NumFormatPane.add(InputModeComboBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(NumFormatPane, gridBagConstraints);

        TabbedPane.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        TabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                TabbedPaneStateChanged(evt);
            }
        });

        calcPanel.setLayout(new java.awt.GridBagLayout());

        StackDisplayPane.setLayout(new java.awt.GridBagLayout());

        ZTextField.setFont(new java.awt.Font("Courier", 0, 14));
        ZTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        ZTextField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        StackDisplayPane.add(ZTextField, gridBagConstraints);

        YTextField.setFont(new java.awt.Font("Courier", 0, 14));
        YTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        YTextField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        StackDisplayPane.add(YTextField, gridBagConstraints);

        XTextField.setFont(new java.awt.Font("Courier", 0, 14));
        XTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        XTextField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        StackDisplayPane.add(XTextField, gridBagConstraints);

        EntryTextField.setFont(new java.awt.Font("Courier", 0, 14));
        EntryTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        EntryTextField.setFocusCycleRoot(true);
        EntryTextField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        EntryTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                EntryTextFieldKeyPressed(evt);
            }
            public void keyTyped(java.awt.event.KeyEvent evt) {
                EntryTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        StackDisplayPane.add(EntryTextField, gridBagConstraints);

        TTextField.setFont(new java.awt.Font("Courier", 0, 14));
        TTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        TTextField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        StackDisplayPane.add(TTextField, gridBagConstraints);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        StackDisplayPane.add(jLabel1, gridBagConstraints);

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText("Z");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        StackDisplayPane.add(jLabel2, gridBagConstraints);

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("T");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        StackDisplayPane.add(jLabel3, gridBagConstraints);

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        StackDisplayPane.add(jLabel4, gridBagConstraints);

        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel5.setText("Entry");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        StackDisplayPane.add(jLabel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(StackDisplayPane, gridBagConstraints);

        SinButton.setText("Sin");
        SinButton.setToolTipText("Shortcut: \"sin\"");
        SinButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SinButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        calcPanel.add(SinButton, gridBagConstraints);

        CosButton.setText("Cos");
        CosButton.setToolTipText("Shortcut: \"cos\"");
        CosButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                CosButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(CosButton, gridBagConstraints);

        TanButton.setText("Tan");
        TanButton.setToolTipText("Shortcut: \"tan\"");
        TanButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                TanButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(TanButton, gridBagConstraints);

        ytoXButton.setText("<html>y<sup>x</sup></html>");
        ytoXButton.setToolTipText("Shortcut: \"^\"");
        ytoXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ytoXButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(ytoXButton, gridBagConstraints);

        ASinButton.setText("<html>Sin<sup>-1</sup></html>");
        ASinButton.setToolTipText("Shortcut: \"asin\"");
        ASinButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ASinButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        calcPanel.add(ASinButton, gridBagConstraints);

        ACosButton.setText("<html>Cos<sup>-1</sup></html>");
        ACosButton.setToolTipText("Shortcut: \"acos\"");
        ACosButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ACosButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(ACosButton, gridBagConstraints);

        ATanButton.setText("<html>Tan<sup>-1</sup></html>");
        ATanButton.setToolTipText("Shortcut: \"atan\"");
        ATanButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ATanButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(ATanButton, gridBagConstraints);

        SqrtButton.setText("<html>&radic;x</html>");
        SqrtButton.setToolTipText("Shortcut: \"sqrt\"");
        SqrtButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SqrtButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        calcPanel.add(SqrtButton, gridBagConstraints);

        LnXButton.setText("ln(x)");
        LnXButton.setToolTipText("Shortcut: \"lnx\"");
        LnXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                LnXButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        calcPanel.add(LnXButton, gridBagConstraints);

        etoxButton.setText("<html>e<sup>x</sup></html>");
        etoxButton.setToolTipText("Shortcut: \"ex\"");
        etoxButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                etoxButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(etoxButton, gridBagConstraints);

        logXButton.setText("log(x)");
        logXButton.setToolTipText("Shortcut: \"logx\"");
        logXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                logXButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(logXButton, gridBagConstraints);

        tenXButton.setText("<html>10<sup>x</sup></html>");
        tenXButton.setToolTipText("Shortcut: \"10x\"");
        tenXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                tenXButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        calcPanel.add(tenXButton, gridBagConstraints);

        ChsButton.setText("+/-");
        ChsButton.setToolTipText("Shortcut: \"chs\"");
        ChsButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ChsButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(ChsButton, gridBagConstraints);

        dropButton.setText("Drop");
        dropButton.setToolTipText("Shortcut: \"drop\"");
        dropButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                dropButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(dropButton, gridBagConstraints);

        InvXButton.setText("1/x");
        InvXButton.setToolTipText("Shortcut: \"1/x\"");
        InvXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                InvXButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(InvXButton, gridBagConstraints);

        swapButton1.setText("x<->y");
        swapButton1.setToolTipText("Shortcut: \"swap\"");
        swapButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                swapButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        calcPanel.add(swapButton1, gridBagConstraints);

        ClearButton.setText("Clear");
        ClearButton.setToolTipText("Shortcut: \"clr\"");
        ClearButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ClearButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(ClearButton, gridBagConstraints);

        drButton.setText("D->R");
        drButton.setToolTipText("Shortcut: \"d-r\"");
        drButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                drButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(drButton, gridBagConstraints);

        rdButton.setText("R->D");
        rdButton.setToolTipText("Shortcut: \"r-d\"");
        rdButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                rdButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        calcPanel.add(rdButton, gridBagConstraints);

        piButton.setText("<html>&pi;</html>");
        piButton.setToolTipText("Shortcut: \"pi\"");
        piButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                piButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(piButton, gridBagConstraints);

        eButton.setText("e");
        eButton.setToolTipText("Shortcut: \"e\"");
        eButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                eButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(eButton, gridBagConstraints);

        x2Button.setText("<html>x<sup>2</sup></html>");
        x2Button.setToolTipText("Shortcut: \"sq\"");
        x2Button.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                x2ButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(x2Button, gridBagConstraints);

        yrx.setText("<html><sup>x</sup>&radic;y</html>");
        yrx.setToolTipText("Shortcut: \"yrx\"");
        yrx.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                yrxMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        calcPanel.add(yrx, gridBagConstraints);

        AddButton.setText("+");
        AddButton.setToolTipText("Shortcut: \"+\"");
        AddButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                AddButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        calcPanel.add(AddButton, gridBagConstraints);

        SubButton.setText("-");
        SubButton.setToolTipText("Shortcut: \"-\"");
        SubButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SubButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(SubButton, gridBagConstraints);

        MultButton.setText("*");
        MultButton.setToolTipText("Shortcut: \"*\"");
        MultButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                MultButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(MultButton, gridBagConstraints);

        DivButton.setText("/");
        DivButton.setToolTipText("Shortcut: \"/\"");
        DivButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                DivButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        calcPanel.add(DivButton, gridBagConstraints);

        EnterButton.setText("Enter");
        EnterButton.setToolTipText("Shortcut: \"ent\"");
        EnterButton.setDefaultCapable(false);
        EnterButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                EnterButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        calcPanel.add(EnterButton, gridBagConstraints);

        TabbedPane.addTab("Calculator", calcPanel);

        financePanel.setLayout(new java.awt.GridBagLayout());

        IRButton.setText("IR");
        IRButton.setToolTipText("Interest Rate Per Period");
        IRButton.setDefaultCapable(false);
        IRButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                IRButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        financePanel.add(IRButton, gridBagConstraints);

        FVButton.setText("FV");
        FVButton.setToolTipText("Future Value");
        FVButton.setDefaultCapable(false);
        FVButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                FVButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        financePanel.add(FVButton, gridBagConstraints);

        PVButton.setText("PV");
        PVButton.setToolTipText("Present Value");
        PVButton.setDefaultCapable(false);
        PVButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                PVButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        financePanel.add(PVButton, gridBagConstraints);

        NPButton.setText("NP");
        NPButton.setToolTipText("Number of Periods");
        NPButton.setDefaultCapable(false);
        NPButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                NPButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        financePanel.add(NPButton, gridBagConstraints);

        PMTButton.setText("PMT");
        PMTButton.setToolTipText("Payment Amount");
        PMTButton.setDefaultCapable(false);
        PMTButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                PMTButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        financePanel.add(PMTButton, gridBagConstraints);

        FVField.setFont(new java.awt.Font("Courier", 0, 14));
        FVField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        FVField.setText("0");
        FVField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        financePanel.add(FVField, gridBagConstraints);

        IRField.setFont(new java.awt.Font("Courier", 0, 14));
        IRField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        IRField.setText("1");
        IRField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        financePanel.add(IRField, gridBagConstraints);

        PVField.setFont(new java.awt.Font("Courier", 0, 14));
        PVField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        PVField.setText("0");
        PVField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        financePanel.add(PVField, gridBagConstraints);

        NPField.setFont(new java.awt.Font("Courier", 0, 14));
        NPField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        NPField.setText("120");
        NPField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        financePanel.add(NPField, gridBagConstraints);

        PMTField.setFont(new java.awt.Font("Courier", 0, 14));
        PMTField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        PMTField.setText("-100");
        PMTField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        financePanel.add(PMTField, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setHorizontalScrollBar(null);

        FinanceTextArea.setColumns(20);
        FinanceTextArea.setEditable(false);
        FinanceTextArea.setFont(new java.awt.Font("Courier", 0, 13));
        FinanceTextArea.setLineWrap(true);
        FinanceTextArea.setRows(5);
        FinanceTextArea.setWrapStyleWord(true);
        FinanceTextArea.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jScrollPane1.setViewportView(FinanceTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jScrollPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        financePanel.add(jPanel2, gridBagConstraints);

        payButtonGroup.add(PayBeginButton);
        PayBeginButton.setText("Payment at Beginning");
        paymentTypePanel.add(PayBeginButton);

        payButtonGroup.add(PayEndButton);
        PayEndButton.setSelected(true);
        PayEndButton.setText("Payment at End");
        paymentTypePanel.add(PayEndButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        financePanel.add(paymentTypePanel, gridBagConstraints);

        TabbedPane.addTab("Finance", financePanel);

        statPanel.setLayout(new java.awt.GridBagLayout());

        MeanField.setFont(new java.awt.Font("Courier", 0, 14));
        MeanField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        MeanField.setText("100.0");
        MeanField.setToolTipText("Mean Value");
        MeanField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(MeanField, gridBagConstraints);

        SDField.setFont(new java.awt.Font("Courier", 0, 14));
        SDField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        SDField.setText("15.0");
        SDField.setToolTipText("Standard Deviation");
        SDField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(SDField, gridBagConstraints);

        PopField.setFont(new java.awt.Font("Courier", 0, 14));
        PopField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        PopField.setText("1.0");
        PopField.setToolTipText("Population Size");
        PopField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(PopField, gridBagConstraints);

        aField.setFont(new java.awt.Font("Courier", 0, 14));
        aField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        aField.setText("85");
        aField.setToolTipText("Interval Start");
        aField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(aField, gridBagConstraints);

        bField.setFont(new java.awt.Font("Courier", 0, 14));
        bField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        bField.setText("115");
        bField.setToolTipText("Interval End");
        bField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        statPanel.add(bField, gridBagConstraints);

        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel10.setText("<html>&mu;</html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(jLabel10, gridBagConstraints);

        jLabel11.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel11.setText("<html>&sigma;</html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(jLabel11, gridBagConstraints);

        jLabel12.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel12.setText("p");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(jLabel12, gridBagConstraints);

        jLabel13.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel13.setText("a");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(jLabel13, gridBagConstraints);

        jLabel14.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel14.setText("b");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(jLabel14, gridBagConstraints);

        resultField.setFont(new java.awt.Font("Courier", 0, 14));
        resultField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        resultField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        statPanel.add(resultField, gridBagConstraints);

        resultButton.setText("Result");
        resultButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                resultButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        statPanel.add(resultButton, gridBagConstraints);

        StatisticsTextArea.setColumns(20);
        StatisticsTextArea.setEditable(false);
        StatisticsTextArea.setFont(new java.awt.Font("Courier", 0, 13));
        StatisticsTextArea.setLineWrap(true);
        StatisticsTextArea.setRows(5);
        StatisticsTextArea.setWrapStyleWord(true);
        StatisticsTextArea.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jScrollPane3.setViewportView(StatisticsTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        statPanel.add(jScrollPane3, gridBagConstraints);

        TabbedPane.addTab("Statistics", statPanel);

        unitsPanel.setLayout(new java.awt.GridBagLayout());

        unitsButtonPanel1.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        unitsPanel.add(unitsButtonPanel1, gridBagConstraints);

        unitsButtonPanel2.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        unitsPanel.add(unitsButtonPanel2, gridBagConstraints);

        unitsIOPanel.setLayout(new java.awt.GridBagLayout());

        unitsInputPanel.setLayout(new java.awt.GridBagLayout());

        jLabel15.setText("<html><b>Input Value:</b></html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        unitsInputPanel.add(jLabel15, gridBagConstraints);

        unitsInputField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        unitsInputField.setText("1");
        unitsInputField.setToolTipText("Press Enter to perform conversion");
        unitsInputField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                unitsInputFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        unitsInputPanel.add(unitsInputField, gridBagConstraints);

        inputUnitLabel.setText("Input Unit:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        unitsInputPanel.add(inputUnitLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        unitsIOPanel.add(unitsInputPanel, gridBagConstraints);

        unitsOutputPanel.setLayout(new java.awt.GridBagLayout());

        jLabel16.setText("<html><b>Output Unit</b></html>");
        jLabel16.setPreferredSize(new java.awt.Dimension(90, 31));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        unitsOutputPanel.add(jLabel16, gridBagConstraints);

        jLabel17.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel17.setText("<html><b>Output Value</b></html>");
        jLabel17.setPreferredSize(new java.awt.Dimension(103, 31));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        unitsOutputPanel.add(jLabel17, gridBagConstraints);

        outputListScrollPane.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                outputListScrollPaneComponentResized(evt);
            }
        });

        outputUnitsList.setFont(new java.awt.Font("Monospaced", 0, 14)); // NOI18N
        outputUnitsList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        outputUnitsList.setToolTipText("Click desired input unit");
        outputUnitsList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                outputUnitsListMouseClicked(evt);
            }
        });
        outputListScrollPane.setViewportView(outputUnitsList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        unitsOutputPanel.add(outputListScrollPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        unitsIOPanel.add(unitsOutputPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        unitsPanel.add(unitsIOPanel, gridBagConstraints);

        TabbedPane.addTab("Conversions", unitsPanel);

        BasePanel.setLayout(new java.awt.GridBagLayout());

        BinaryField.setFont(new java.awt.Font("Courier", 0, 14));
        BinaryField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        BinaryField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        BinaryField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                BinaryFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        BasePanel.add(BinaryField, gridBagConstraints);

        OctalField.setFont(new java.awt.Font("Courier", 0, 14));
        OctalField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        OctalField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        OctalField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                OctalFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        BasePanel.add(OctalField, gridBagConstraints);

        DecimalField.setFont(new java.awt.Font("Courier", 0, 14));
        DecimalField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        DecimalField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        DecimalField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                DecimalFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        BasePanel.add(DecimalField, gridBagConstraints);

        HexField.setFont(new java.awt.Font("Courier", 0, 14));
        HexField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        HexField.setMargin(new java.awt.Insets(0, 2, 0, 2));
        HexField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                HexFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        BasePanel.add(HexField, gridBagConstraints);

        jLabel6.setText("Binary");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        BasePanel.add(jLabel6, gridBagConstraints);

        jLabel7.setText("Octal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        BasePanel.add(jLabel7, gridBagConstraints);

        jLabel8.setText("Decimal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        BasePanel.add(jLabel8, gridBagConstraints);

        jLabel9.setText("Hexadecimal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        BasePanel.add(jLabel9, gridBagConstraints);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        BaseTextArea.setColumns(20);
        BaseTextArea.setEditable(false);
        BaseTextArea.setFont(new java.awt.Font("Courier", 0, 13));
        BaseTextArea.setLineWrap(true);
        BaseTextArea.setRows(5);
        BaseTextArea.setWrapStyleWord(true);
        BaseTextArea.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jScrollPane2.setViewportView(BaseTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jScrollPane2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        BasePanel.add(jPanel3, gridBagConstraints);

        TabbedPane.addTab("Bases", BasePanel);

        helpPanel.setLayout(new java.awt.GridBagLayout());

        HelpTextArea.setColumns(20);
        HelpTextArea.setFont(new java.awt.Font("Courier", 0, 13));
        HelpTextArea.setLineWrap(true);
        HelpTextArea.setRows(5);
        HelpTextArea.setWrapStyleWord(true);
        HelpTextArea.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jScrollPane5.setViewportView(HelpTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        helpPanel.add(jScrollPane5, gridBagConstraints);

        TabbedPane.addTab("Help", helpPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(TabbedPane, gridBagConstraints);

        StatusLabel.setText("Status");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        add(StatusLabel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void FixRadioButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_FixRadioButtonMouseClicked
        // TODO add your handling code here:
        displayOptionsChanged();
}//GEN-LAST:event_FixRadioButtonMouseClicked

    private void SciRadioButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SciRadioButtonMouseClicked
        // TODO add your handling code here:
        displayOptionsChanged();
}//GEN-LAST:event_SciRadioButtonMouseClicked

    private void DecPlacesComboItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_DecPlacesComboItemStateChanged
        // TODO add your handling code here:
        displayOptionsChanged();
}//GEN-LAST:event_DecPlacesComboItemStateChanged

    private void AllRadioButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_AllRadioButtonMouseClicked
        // TODO add your handling code here:
        displayOptionsChanged();
}//GEN-LAST:event_AllRadioButtonMouseClicked

    private void InputModeComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_InputModeComboBoxItemStateChanged
        // TODO add your handling code here:
        calc.showStackDisp();
}//GEN-LAST:event_InputModeComboBoxItemStateChanged

    private void TabbedPaneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_TabbedPaneStateChanged
        // TODO add your handling code here:
        setPaneTab(-1);
}//GEN-LAST:event_TabbedPaneStateChanged

    private void HexFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_HexFieldKeyReleased
        // TODO add your handling code here:
        basec.process(evt, 3);
}//GEN-LAST:event_HexFieldKeyReleased

    private void DecimalFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_DecimalFieldKeyReleased
        // TODO add your handling code here:
        basec.process(evt, 2);
}//GEN-LAST:event_DecimalFieldKeyReleased

    private void OctalFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_OctalFieldKeyReleased
        // TODO add your handling code here:
        basec.process(evt, 1);
}//GEN-LAST:event_OctalFieldKeyReleased

    private void BinaryFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_BinaryFieldKeyReleased
        // TODO add your handling code here:
        basec.process(evt, 0);
}//GEN-LAST:event_BinaryFieldKeyReleased

    private void resultButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_resultButtonMouseClicked
        // TODO add your handling code here:
        stat.process();
}//GEN-LAST:event_resultButtonMouseClicked

    private void PMTButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_PMTButtonMouseClicked
        // TODO add your handling code here:
        finance.process("PMT");
}//GEN-LAST:event_PMTButtonMouseClicked

    private void NPButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_NPButtonMouseClicked
        // TODO add your handling code here:
        finance.process("NP");
}//GEN-LAST:event_NPButtonMouseClicked

    private void PVButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_PVButtonMouseClicked
        // TODO add your handling code here:
        finance.process("PV");
}//GEN-LAST:event_PVButtonMouseClicked

    private void FVButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_FVButtonMouseClicked
        // TODO add your handling code here:
        finance.process("FV");
}//GEN-LAST:event_FVButtonMouseClicked

    private void IRButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_IRButtonMouseClicked
        // TODO add your handling code here:
        finance.process("IR");
}//GEN-LAST:event_IRButtonMouseClicked

    private void EnterButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_EnterButtonMouseClicked
        // TODO add your handling code here:
        calc.enterAction();
}//GEN-LAST:event_EnterButtonMouseClicked

    private void DivButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_DivButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("/");
}//GEN-LAST:event_DivButtonMouseClicked

    private void MultButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_MultButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("*");
}//GEN-LAST:event_MultButtonMouseClicked

    private void SubButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SubButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("-");
}//GEN-LAST:event_SubButtonMouseClicked

    private void AddButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_AddButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("+");
}//GEN-LAST:event_AddButtonMouseClicked

    private void yrxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_yrxMouseClicked
        // TODO add your handling code here:
        calc.processCommand("yrx");
}//GEN-LAST:event_yrxMouseClicked

    private void x2ButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_x2ButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("sq");
}//GEN-LAST:event_x2ButtonMouseClicked

    private void eButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_eButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("e");
}//GEN-LAST:event_eButtonMouseClicked

    private void piButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_piButtonMouseClicked
        // TODO add your handling code here:\
        calc.processCommand("pi");
}//GEN-LAST:event_piButtonMouseClicked

    private void rdButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rdButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("r-d");
}//GEN-LAST:event_rdButtonMouseClicked

    private void drButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_drButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("d-r");
}//GEN-LAST:event_drButtonMouseClicked

    private void ClearButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ClearButtonMouseClicked
        // TODO add your handling code here:
        calc.clearStack(true);
}//GEN-LAST:event_ClearButtonMouseClicked

    private void swapButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_swapButton1MouseClicked
        // TODO add your handling code here:
        calc.processCommand("swap");
}//GEN-LAST:event_swapButton1MouseClicked

    private void InvXButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_InvXButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("1/x");
}//GEN-LAST:event_InvXButtonMouseClicked

    private void dropButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dropButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("drop");
}//GEN-LAST:event_dropButtonMouseClicked

    private void ChsButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ChsButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("chs");
}//GEN-LAST:event_ChsButtonMouseClicked

    private void tenXButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_tenXButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("tenx");
}//GEN-LAST:event_tenXButtonMouseClicked

    private void logXButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_logXButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("logx");
}//GEN-LAST:event_logXButtonMouseClicked

    private void etoxButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_etoxButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("ex");
}//GEN-LAST:event_etoxButtonMouseClicked

    private void LnXButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_LnXButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("lnx");
}//GEN-LAST:event_LnXButtonMouseClicked

    private void SqrtButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SqrtButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("sqrt");
}//GEN-LAST:event_SqrtButtonMouseClicked

    private void ATanButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ATanButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("atan");
}//GEN-LAST:event_ATanButtonMouseClicked

    private void ACosButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ACosButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("acos");
}//GEN-LAST:event_ACosButtonMouseClicked

    private void ASinButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ASinButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("asin");
}//GEN-LAST:event_ASinButtonMouseClicked

    private void ytoXButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ytoXButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("^");
}//GEN-LAST:event_ytoXButtonMouseClicked

    private void TanButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_TanButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("tan");
}//GEN-LAST:event_TanButtonMouseClicked

    private void CosButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_CosButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("cos");
}//GEN-LAST:event_CosButtonMouseClicked

    private void SinButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SinButtonMouseClicked
        // TODO add your handling code here:
        calc.processCommand("sin");
}//GEN-LAST:event_SinButtonMouseClicked

    private void EntryTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_EntryTextFieldKeyTyped
        // TODO add your handling code here:
        calc.enterAction(evt);
}//GEN-LAST:event_EntryTextFieldKeyTyped

    private void EntryTextFieldKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_EntryTextFieldKeyPressed
        // TODO add your handling code here:
        calc.processKey(evt);
    }//GEN-LAST:event_EntryTextFieldKeyPressed

    private void unitsInputFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_unitsInputFieldKeyTyped
        // TODO add your handling code here:
        units.manageKeyTyped(evt);
    }//GEN-LAST:event_unitsInputFieldKeyTyped

    private void outputListScrollPaneComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_outputListScrollPaneComponentResized
        // TODO add your handling code here:
        testUnitsAcceptConversion();

    }//GEN-LAST:event_outputListScrollPaneComponentResized

    private void outputUnitsListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_outputUnitsListMouseClicked
        // TODO add your handling code here:
        units.setInputUnit();
    }//GEN-LAST:event_outputUnitsListMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton ACosButton;
    private javax.swing.JButton ASinButton;
    private javax.swing.JButton ATanButton;
    private javax.swing.JButton AddButton;
    protected javax.swing.JRadioButton AllRadioButton;
    private javax.swing.JPanel BasePanel;
    private javax.swing.JTextArea BaseTextArea;
    protected javax.swing.JTextField BinaryField;
    private javax.swing.JButton ChsButton;
    private javax.swing.JButton ClearButton;
    private javax.swing.JButton CosButton;
    protected javax.swing.JComboBox DecPlacesCombo;
    protected javax.swing.JTextField DecimalField;
    private javax.swing.JButton DivButton;
    private javax.swing.JButton EnterButton;
    protected javax.swing.JTextField EntryTextField;
    private javax.swing.JButton FVButton;
    protected javax.swing.JTextField FVField;
    private javax.swing.JTextArea FinanceTextArea;
    protected javax.swing.JRadioButton FixRadioButton;
    private javax.swing.ButtonGroup FixSciButtonGroup;
    private javax.swing.JTextArea HelpTextArea;
    protected javax.swing.JTextField HexField;
    private javax.swing.JButton IRButton;
    protected javax.swing.JTextField IRField;
    protected javax.swing.JComboBox InputModeComboBox;
    private javax.swing.JButton InvXButton;
    private javax.swing.JButton LnXButton;
    protected javax.swing.JTextField MeanField;
    private javax.swing.JButton MultButton;
    private javax.swing.JButton NPButton;
    protected javax.swing.JTextField NPField;
    private javax.swing.JPanel NumFormatPane;
    protected javax.swing.JTextField OctalField;
    private javax.swing.JButton PMTButton;
    protected javax.swing.JTextField PMTField;
    private javax.swing.JButton PVButton;
    protected javax.swing.JTextField PVField;
    protected javax.swing.JRadioButton PayBeginButton;
    protected javax.swing.JRadioButton PayEndButton;
    protected javax.swing.JTextField PopField;
    protected javax.swing.JTextField SDField;
    protected javax.swing.JRadioButton SciRadioButton;
    private javax.swing.JButton SinButton;
    private javax.swing.JButton SqrtButton;
    private javax.swing.JPanel StackDisplayPane;
    private javax.swing.JTextArea StatisticsTextArea;
    private javax.swing.JLabel StatusLabel;
    private javax.swing.JButton SubButton;
    protected javax.swing.JTextField TTextField;
    private javax.swing.JTabbedPane TabbedPane;
    private javax.swing.JButton TanButton;
    protected javax.swing.JTextField XTextField;
    protected javax.swing.JTextField YTextField;
    protected javax.swing.JTextField ZTextField;
    protected javax.swing.JTextField aField;
    protected javax.swing.JTextField bField;
    private javax.swing.JPanel calcPanel;
    private javax.swing.JButton drButton;
    private javax.swing.JButton dropButton;
    private javax.swing.JButton eButton;
    private javax.swing.JButton etoxButton;
    private javax.swing.JPanel financePanel;
    private javax.swing.JPanel helpPanel;
    protected javax.swing.JLabel inputUnitLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JButton logXButton;
    protected javax.swing.JScrollPane outputListScrollPane;
    protected javax.swing.JList outputUnitsList;
    private javax.swing.ButtonGroup payButtonGroup;
    private javax.swing.JPanel paymentTypePanel;
    private javax.swing.JButton piButton;
    private javax.swing.JButton rdButton;
    private javax.swing.JButton resultButton;
    protected javax.swing.JTextField resultField;
    private javax.swing.JPanel statPanel;
    private javax.swing.JButton swapButton1;
    private javax.swing.JButton tenXButton;
    protected javax.swing.JPanel unitsButtonPanel1;
    protected javax.swing.JPanel unitsButtonPanel2;
    protected javax.swing.JPanel unitsIOPanel;
    protected javax.swing.JTextField unitsInputField;
    private javax.swing.JPanel unitsInputPanel;
    private javax.swing.JPanel unitsOutputPanel;
    protected javax.swing.JPanel unitsPanel;
    private javax.swing.JButton x2Button;
    private javax.swing.JButton yrx;
    private javax.swing.JButton ytoXButton;
    // End of variables declaration//GEN-END:variables
}
