/*
 * Decompiled with CFR 0.152.
 */
package plcalc;

import javax.swing.JTextField;
import plcalc.PLCalcMainPanel;

public class Statistics {
    PLCalcMainPanel parent;
    static double epsilon = 1.0E-16;
    double[] defaults = new double[]{100.0, 15.0, 1.0, 85.0, 115.0};
    double[] vals;
    JTextField[] statFields;

    public Statistics(PLCalcMainPanel pLCalcMainPanel) {
        this.parent = pLCalcMainPanel;
        this.statFields = new JTextField[]{this.parent.MeanField, this.parent.SDField, this.parent.PopField, this.parent.aField, this.parent.bField};
        this.vals = new double[this.statFields.length];
        for (int i = 0; i < this.defaults.length; ++i) {
            this.statFields[i].setText(this.parent.specialFormat(this.parent.getCurrentFormat(), this.defaults[i]));
        }
    }

    void getVals() {
        for (int i = 0; i < this.statFields.length; ++i) {
            this.vals[i] = this.parent.getNum(this.statFields[i]);
            this.statFields[i].setText(this.parent.specialFormat(this.parent.getCurrentFormat(), this.vals[i]));
        }
    }

    double erfc(double d) {
        double d2;
        if (d == 0.0) {
            return 1.0;
        }
        if (Math.abs(d) < 2.2) {
            return 1.0 - this.erf(d);
        }
        if (d < 0.0) {
            return 2.0 - this.erfc(-d);
        }
        double d3 = 1.0;
        double d4 = d;
        double d5 = d;
        double d6 = d * d + 0.5;
        double d7 = d4 / d6;
        double d8 = 1.0;
        do {
            double d9 = d3 * d8 + d4 * d;
            d3 = d4;
            d4 = d9;
            d9 = d5 * d8 + d6 * d;
            d5 = d6;
            d6 = d9;
            d8 += 0.5;
        } while (Math.abs((d2 = d7) - (d7 = d4 / d6)) >= epsilon);
        return d7 * Math.exp(-(d * d)) / Math.sqrt(Math.PI);
    }

    double erf(double d) {
        double d2;
        if (d == 0.0) {
            return d;
        }
        if (Math.abs(d) > 2.2) {
            return 1.0 - this.erfc(d);
        }
        double d3 = d < 0.0 ? -1.0 : 1.0;
        double d4 = d = Math.abs(d);
        double d5 = d;
        double d6 = d * d;
        int n = 1;
        while (Math.abs((d2 = d5) - (d5 += (d4 = -d4 * d6 / (double)n) / (double)(2 * ++n + 1))) >= epsilon) {
        }
        return d3 * d5 * 2.0 / Math.sqrt(Math.PI);
    }

    double erfint(double d, double d2, double d3, double d4, double d5) {
        if (d2 == 0.0) {
            this.parent.setStatus("Standard Deviation cannot be zero.", true);
        }
        double d6 = Math.sqrt(2.0) * d2;
        double d7 = this.erf((d4 - d) / d6);
        double d8 = this.erf((d5 - d) / d6);
        return d3 * 0.5 * (d8 - d7);
    }

    public void process() {
        this.parent.setStatus("OK", false);
        this.getVals();
        double d = this.erfint(this.vals[0], this.vals[1], this.vals[2], this.vals[3], this.vals[4]);
        String string = this.parent.specialFormat(this.parent.getCurrentFormat(), d);
        this.parent.resultField.setText(string);
    }
}

