/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import opticalraytracer.Common;
import opticalraytracer.MyColor;

public final class WavelengthColor {
    static final double redNM = 650.0;
    static final double violetNM = 400.0;
    static final double dispersionPivotNM = 589.3;
    static final double dispersionFactor = 500000.0;
    double r;
    double g;
    double b;
    double wvl;
    MyColor col;

    public WavelengthColor(double h) {
        this.wvl = Common.ntrp(h, 0.0, 1.0, 650.0, 400.0);
        this.col = WavelengthColor.hToRGB(h *= 0.75);
        this.r = (double)this.col.getRed() / 255.0;
        this.g = (double)this.col.getGreen() / 255.0;
        this.b = (double)this.col.getBlue() / 255.0;
    }

    static MyColor hToRGB(double h) {
        MyColor rgb;
        double hp = h * 6.0;
        double c = 1.0;
        double x = c * (1.0 - Math.abs(hp % 2.0 - 1.0));
        switch ((int)hp) {
            case 0: {
                rgb = new MyColor(c, x, 0.0);
                break;
            }
            case 1: {
                rgb = new MyColor(x, c, 0.0);
                break;
            }
            case 2: {
                rgb = new MyColor(0.0, c, x);
                break;
            }
            case 3: {
                rgb = new MyColor(0.0, x, c);
                break;
            }
            case 4: {
                rgb = new MyColor(x, 0.0, c);
                break;
            }
            case 5: {
                rgb = new MyColor(c, 0.0, x);
                break;
            }
            default: {
                rgb = new MyColor(0.0, 0.0, 0.0);
            }
        }
        return rgb;
    }

    static double dispersionIndex(double ior, double wavelength, double abbe) {
        return ior + (589.3 - wavelength) * 500000.0 / (abbe * 589.3 * wavelength * wavelength);
    }
}

