/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

public final class Vector {
    double x = 0.0;
    double y = 0.0;

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector(Vector p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vector() {
    }

    public void assign(Vector v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector translate(Vector p) {
        return new Vector(this.x + p.x, this.y + p.y);
    }

    public Vector translate(double px, double py) {
        return new Vector(this.x + px, this.y + py);
    }

    public Vector translateSub(Vector p) {
        return new Vector(this.x - p.x, this.y - p.y);
    }

    public Vector scale(double scale) {
        return new Vector(this.x * scale, this.y * scale);
    }

    public Vector scale(double xs, double ys) {
        return new Vector(this.x * xs, this.y * ys);
    }

    public Vector rotate(double x, double y, double angleRadians) {
        double xx = x * Math.cos(angleRadians) - y * Math.sin(angleRadians);
        double yy = y * Math.cos(angleRadians) + x * Math.sin(angleRadians);
        return new Vector(xx, yy);
    }

    public Vector rotate(double angleRadians) {
        double xx = this.x * Math.cos(angleRadians) - this.y * Math.sin(angleRadians);
        double yy = this.y * Math.cos(angleRadians) + this.x * Math.sin(angleRadians);
        return new Vector(xx, yy);
    }

    public Vector rotate(Vector v, double angleRadians) {
        double xx = v.x * Math.cos(angleRadians) - v.y * Math.sin(angleRadians);
        double yy = v.y * Math.cos(angleRadians) + v.x * Math.sin(angleRadians);
        return new Vector(xx, yy);
    }

    public Vector mul(double v) {
        return new Vector(this.x * v, this.y * v);
    }

    public Vector mul(Vector v) {
        return new Vector(this.x * v.x, this.y * v.y);
    }

    public Vector div(double v) {
        return new Vector(this.x / v, this.y / v);
    }

    public Vector div(Vector v) {
        return new Vector(this.x / v.x, this.y / v.y);
    }

    public Vector add(Vector v) {
        return new Vector(this.x + v.x, this.y + v.y);
    }

    public Vector add(double v) {
        return new Vector(this.x + v, this.y + v);
    }

    public Vector sub(Vector v) {
        return new Vector(this.x - v.x, this.y - v.y);
    }

    public Vector sub(double v) {
        return new Vector(this.x - v, this.y - v);
    }

    public Vector negate() {
        return new Vector(-this.x, -this.y);
    }

    public Vector normalize() {
        if (this.x != 0.0 || this.y != 0.0) {
            double m = this.m();
            return new Vector(this.x / m, this.y / m);
        }
        return new Vector(0.0, 0.0);
    }

    public static Vector polar(double m, double a) {
        return new Vector(m * Math.cos(a), m * Math.sin(a));
    }

    public static Vector polar(double a) {
        return new Vector(Math.cos(a), Math.sin(a));
    }

    public double angle() {
        return Math.atan2(this.y, this.x);
    }

    public double m() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double dot(Vector v) {
        return this.x * v.x + this.y * v.y;
    }

    public static Vector invalidState() {
        return new Vector(Double.NaN, Double.NaN);
    }

    public boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isNaN(this.y);
    }

    public String toString() {
        return String.format("{%f,%f}", this.x, this.y);
    }
}

