/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import opticalraytracer.OpticalComponent;
import opticalraytracer.Vector;

public final class RayLensIntersection {
    int function;
    boolean leftSide;
    Vector a;
    Vector b;
    Vector p;
    double wavelength;
    double dot;
    double m;
    OpticalComponent lens = null;

    public RayLensIntersection(Vector a, Vector b, double wavelength, Vector p, boolean leftSide, OpticalComponent lens) {
        this.a = new Vector(a);
        this.b = new Vector(b);
        this.p = new Vector(p);
        this.wavelength = wavelength;
        this.leftSide = leftSide;
        this.lens = lens;
        this.function = lens.values.function;
        double cx = b.x - a.x;
        double cy = b.y - a.y;
        double dx = p.x - a.x;
        double dy = p.y - a.y;
        this.dot = dx * cx + dy * cy;
        this.m = dx * dx + dy * dy;
    }

    public RayLensIntersection() {
    }

    public String toString() {
        return String.format("ax = %f, ay = %f, bx = %f, by = %f, x = %f, y = %f, dot = %f, m = %f", this.a.x, this.a.y, this.b.x, this.b.y, this.p.x, this.p.y, this.dot, this.m);
    }
}

