/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import opticalraytracer.Common;
import opticalraytracer.RayLensIntersection;
import opticalraytracer.Vector;

public final class LineData {
    String from = "";
    String to = "";
    String type = "";
    String fromEvent = "";
    String toEvent = "";
    Vector a;
    Vector b;
    double dx;
    double dy;
    double m;
    double ar;
    double sa;
    double wavelength;

    public LineData(int ray, int dbeam, double wavelength, RayLensIntersection oldrli, RayLensIntersection rli, Vector ia, Vector ib, double surfaceAngle, String fromEvent, String toEvent) {
        this.fromEvent = fromEvent;
        this.toEvent = toEvent;
        if (oldrli == null) {
            this.from = String.format("Origin Ray %d", ray + 1);
            if (wavelength != 0.0) {
                this.from = String.valueOf(this.from) + String.format(" Dbeam %d", dbeam + 1);
            }
        } else {
            this.from = oldrli.lens.values.name;
        }
        if (rli == null) {
            this.to = "Virtual space boundary";
            this.type = "Domain Limit";
        } else {
            this.to = rli.lens.values.name;
            this.type = Common.getObjectType(rli.function);
        }
        this.a = new Vector(ia.x, ia.y);
        this.b = new Vector(ib.x, ib.y);
        this.dx = ib.x - ia.x;
        this.dy = ib.y - ia.y;
        this.m = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.wavelength = wavelength == 0.0 ? 589.3 : wavelength;
        this.ar = Math.atan2(this.dy, this.dx) * 57.29577951308232;
        this.sa = surfaceAngle * 57.29577951308232;
    }

    public double[] numericValues() {
        return new double[]{this.a.x, this.a.y, this.b.x, this.b.y, this.dx, this.dy, this.m, this.ar, this.sa, this.wavelength};
    }
}

