/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import opticalraytracer.Common;
import opticalraytracer.OpticalComponent;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.ProgramValues;
import opticalraytracer.RayTraceComputer;
import opticalraytracer.Vector;

public final class GraphicDisplay
extends JPanel {
    boolean mouseInside = false;
    OpticalRayTracer parent;
    OpticalComponent ocUnderMouse = null;
    String name;
    int tabValue;
    int testCount = 0;
    ProgramValues programValues;
    RayTraceComputer rayTraceComputer;
    JPopupMenu popupMenu;
    boolean hasFocus = false;
    Cursor handCursor;
    Cursor moveCursor;
    Cursor crossCursor;
    Cursor defaultCursor;
    boolean shiftKey;
    boolean ctrlKey;
    boolean altKey;

    public GraphicDisplay(OpticalRayTracer p, String name, int tab) {
        this.name = name;
        this.tabValue = tab;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GraphicDisplay.this.hasFocus = true;
                GraphicDisplay.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                GraphicDisplay.this.hasFocus = false;
                GraphicDisplay.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GraphicDisplay.this.handleMouseWheelEvent(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GraphicDisplay.this.handleMouseMove(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                GraphicDisplay.this.handleMouseDrag(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GraphicDisplay.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GraphicDisplay.this.handleMousePressEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                GraphicDisplay.this.setMouseInside(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GraphicDisplay.this.setMouseInside(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GraphicDisplay.this.handleMouseReleaseEvent(e);
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                GraphicDisplay.this.handleKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.parent = p;
        this.programValues = this.parent.programValues;
        this.rayTraceComputer = this.parent.rayTraceComputer;
        this.handCursor = new Cursor(12);
        this.moveCursor = new Cursor(13);
        this.crossCursor = new Cursor(1);
        this.defaultCursor = new Cursor(0);
        this.popupMenu = new JPopupMenu();
        GraphicDisplay.addPopup(this, this.popupMenu);
        JMenuItem mntmNewLens = new JMenuItem("New Lens");
        mntmNewLens.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.makeNewLensPopup(GraphicDisplay.this.parent.popupMouseX, GraphicDisplay.this.parent.popupMouseY);
            }
        });
        mntmNewLens.setToolTipText("Create new lens at cursor position");
        mntmNewLens.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/document-new.png")));
        this.popupMenu.add(mntmNewLens);
        JMenuItem mntmNewMirror = new JMenuItem("New Mirror");
        mntmNewMirror.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.makeNewMirrorPopup(GraphicDisplay.this.parent.popupMouseX, GraphicDisplay.this.parent.popupMouseY);
            }
        });
        mntmNewMirror.setToolTipText("Create new mirror at cursor position");
        mntmNewMirror.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/view-fullscreen.png")));
        this.popupMenu.add(mntmNewMirror);
        JMenuItem mntmLineProperties = new JMenuItem("Line Properties");
        mntmLineProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.lineAnalysis.nearestLineProperties(GraphicDisplay.this.parent.mousePressX, GraphicDisplay.this.parent.mousePressY);
            }
        });
        mntmLineProperties.setToolTipText("<html>List properties of line closest to mouse cursor<br/>(double-click also works)");
        mntmLineProperties.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/document-save.png")));
        this.popupMenu.add(mntmLineProperties);
        JMenuItem mntmCut = new JMenuItem("Cut");
        mntmCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.clipboardCutLens();
            }
        });
        mntmCut.setToolTipText("Cut selected object");
        mntmCut.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/edit-cut.png")));
        this.popupMenu.add(mntmCut);
        JMenuItem mntmCopy = new JMenuItem("Copy");
        mntmCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.clipboardCopyLens();
            }
        });
        mntmCopy.setToolTipText("Copy selected object");
        mntmCopy.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/edit-copy.png")));
        this.popupMenu.add(mntmCopy);
        JMenuItem mntmPaste = new JMenuItem("Paste: mouse cursor");
        mntmPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.clipboardPasteObject(true);
            }
        });
        mntmPaste.setToolTipText("Paste object to mouse cursor position");
        mntmPaste.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/edit-paste.png")));
        this.popupMenu.add(mntmPaste);
        JMenuItem mntmNewMenuItem = new JMenuItem("Paste: defined position");
        mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.clipboardPasteObject(false);
            }
        });
        mntmNewMenuItem.setToolTipText("Paste object to its defined position");
        mntmNewMenuItem.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/edit-paste.png")));
        this.popupMenu.add(mntmNewMenuItem);
        JMenuItem mntmDelete = new JMenuItem("Delete");
        mntmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.parent.deleteSelectedLens();
            }
        });
        mntmDelete.setToolTipText("Delete selected object");
        mntmDelete.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/process-stop.png")));
        this.popupMenu.add(mntmDelete);
        JMenuItem mntmContextHelp = new JMenuItem("Context Help");
        mntmContextHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicDisplay.this.contextHelp();
            }
        });
        mntmContextHelp.setToolTipText("Show a brief explanation of this display's controls");
        mntmContextHelp.setIcon(new ImageIcon(GraphicDisplay.class.getResource("/opticalraytracer/icons/system-help.png")));
        this.popupMenu.add(mntmContextHelp);
    }

    protected void acquireFocus() {
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.requestFocusInWindow();
    }

    protected Vector setupCursorPosition(int centerX, int centerY) {
        this.parent.popupMouseX = centerX;
        this.parent.popupMouseY = centerY;
        Vector p = this.parent.displayToSpace(this.parent.popupMouseX, this.parent.popupMouseY);
        this.parent.mousePressX = p.x + this.programValues.xOffset;
        this.parent.mousePressY = p.y + this.programValues.yOffset;
        return p;
    }

    protected void centerCursorOnScreen() {
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        Point ps = this.getLocationOnScreen();
        try {
            Robot r = new Robot();
            r.mouseMove(centerX + ps.x, centerY + ps.y);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    private void handleKeyPressed(KeyEvent evt) {
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        boolean ctrlKey = evt.isControlDown();
        boolean shiftKey = evt.isShiftDown();
        boolean altKey = evt.isAltDown();
        double multiplier = 1.0;
        multiplier = shiftKey ? multiplier * 0.1 : multiplier;
        multiplier = altKey ? multiplier * 0.1 : multiplier;
        double panStep = 0.05 * multiplier / this.programValues.dispScale;
        double zoomStep = 0.1 * multiplier;
        boolean consume = true;
        int kcode = evt.getKeyCode();
        switch (kcode) {
            case 112: {
                this.contextHelp();
                break;
            }
            case 10: {
                Vector c = this.parent.displayToSpace(centerX, centerY).translate(this.programValues.xOffset, this.programValues.yOffset);
                OpticalComponent p = this.testMouseInsideLens(c, false);
                if (p != null) {
                    this.parent.setSelectedComponent(p);
                    this.parent.mouseTarget = p;
                    break;
                }
                this.setupCursorPosition(centerX, centerY);
                this.parent.lineAnalysis.nearestLineProperties(this.parent.mousePressX, this.parent.mousePressY);
                break;
            }
            case 76: {
                this.setupCursorPosition(centerX, centerY);
                this.parent.lineAnalysis.nearestLineProperties(this.parent.mousePressX, this.parent.mousePressY);
                break;
            }
            case 79: {
                this.parent.selectNextObject();
                break;
            }
            case 85: {
                this.parent.unSelectLens();
                break;
            }
            case 77: 
            case 524: 
            case 525: {
                this.setupCursorPosition(centerX, centerY);
                this.popupMenu.show(this, this.parent.popupMouseX, this.parent.popupMouseY);
                break;
            }
            case 9: {
                break;
            }
            case 36: 
            case 61: 
            case 103: 
            case 107: 
            case 521: {
                this.processZoom(ctrlKey, shiftKey, zoomStep);
                break;
            }
            case 35: 
            case 45: 
            case 97: 
            case 109: {
                this.processZoom(ctrlKey, shiftKey, -zoomStep);
                break;
            }
            case 38: 
            case 104: 
            case 224: {
                this.processPan(true, ctrlKey, panStep);
                break;
            }
            case 40: 
            case 98: 
            case 225: {
                this.processPan(true, ctrlKey, -panStep);
                break;
            }
            case 37: 
            case 100: 
            case 226: {
                this.processPan(false, ctrlKey, -panStep);
                break;
            }
            case 39: 
            case 102: 
            case 227: {
                this.processPan(false, ctrlKey, panStep);
                break;
            }
            default: {
                consume = false;
            }
        }
        if (consume) {
            evt.consume();
            this.centerCursorOnScreen();
            this.rayTraceProcess(true);
        }
    }

    protected void processPan(boolean vertical, boolean ctrlKey, double step) {
        if (ctrlKey) {
            OpticalComponent oc = this.parent.selectedComponent;
            if (oc != null) {
                if (vertical) {
                    oc.values.yPos += step;
                    this.parent.programValues.yOffset += step;
                } else {
                    oc.values.xPos += step;
                    this.parent.programValues.xOffset += step;
                }
                oc.writeObjectControls();
            }
        } else if (vertical) {
            this.programValues.yOffset += step;
        } else {
            this.programValues.xOffset += step;
        }
    }

    protected void processZoom(boolean ctrlKey, boolean shiftKey, double step) {
        OpticalComponent oc = this.parent.selectedComponent;
        if (shiftKey && oc != null) {
            oc.values.angle = (oc.values.angle + (step * 100.0 + 720.0)) % 360.0;
            oc.writeObjectControls();
        } else if (ctrlKey && oc != null) {
            oc.values.lensRadius += step;
            oc.writeObjectControls();
        } else {
            this.programValues.dispScale *= 1.0 + step;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        this.rayTraceProcessCore(w, h, false);
        g.drawImage(this.parent.image, 0, 0, null);
    }

    void drawData(Graphics g, int x, int y) {
        this.rayTraceProcessCore(x, y, false);
        g.drawImage(this.parent.image, 0, 0, null);
    }

    void rayTraceProcess(boolean paint) {
        if (!paint || this.parent.currentTab() == this.tabValue) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (paint) {
                this.repaint();
            } else {
                this.rayTraceProcessCore(w, h, false);
            }
        }
    }

    void rayTraceProcessCore(int w, int h, boolean forceFocus) {
        if (this.updateGraphicBuffer(w, h)) {
            this.parent.unselectButton.setEnabled(this.parent.selectedComponent != null);
            Graphics2D bg = (Graphics2D)this.parent.image.getGraphics();
            if (this.programValues.antialias) {
                RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                bg.addRenderingHints(rh);
            }
            Color bgColor = this.hasFocus || forceFocus ? new Color(this.programValues.inverse ? this.programValues.colorLowBackground : this.programValues.colorHighBackground) : (this.programValues.inverse ? Common.noFocusInverse : Common.noFocusHi);
            bg.setColor(bgColor);
            bg.fillRect(0, 0, this.parent.image.getWidth(), this.parent.image.getHeight());
            if (this.programValues.beamWidth > 1) {
                bg.setStroke(new BasicStroke(this.programValues.beamWidth));
            }
            if (this.programValues.showGrid) {
                this.rayTraceComputer.drawGrid(bg);
                this.rayTraceComputer.drawBaselines(bg);
            }
            this.rayTraceComputer.drawLenses(bg);
            this.rayTraceComputer.traceRays(bg, false);
            bg.dispose();
        }
    }

    boolean updateGraphicBuffer(int x, int y) {
        boolean success = false;
        if (x > 0 && y > 0) {
            success = true;
            if (this.parent.image == null || this.parent.xSize != x || this.parent.ySize != y) {
                this.parent.xSize = x;
                this.parent.ySize = y;
                this.parent.image = new BufferedImage(x, y, 1);
                this.parent.xCenter = this.parent.xSize / 2;
                this.parent.yCenter = this.parent.ySize / 2;
            }
        }
        return success;
    }

    void updateStatusBar(int mx, int my, boolean erase) {
        String s = String.format("       %10s   %10s      %10s", "", "", "");
        if (!erase) {
            Vector sp = this.parent.displayToSpaceOffset(new Vector(mx, my));
            String sx = this.dispRoundNum(sp.x);
            String sy = this.dispRoundNum(sp.y);
            String sz = this.dispRoundNum(this.programValues.dispScale);
            s = String.format("Pos: X:%10s Y:%10s Magnification:%10s", sx, sy, sz);
        }
        this.parent.statusLabel.setText(s);
    }

    String dispRoundNum(double v) {
        double av = Math.abs(v);
        String result = av > 100.0 || av < 0.1 ? String.format("%9.4e", v) : String.format("%9.4f", v);
        return result;
    }

    public boolean hasMouse() {
        return this.mouseInside;
    }

    void setMouseInside(boolean inside) {
        this.mouseInside = inside;
        if (!inside) {
            this.updateStatusBar(0, 0, true);
        }
    }

    void updateDisplay() {
        this.rayTraceProcess(true);
    }

    void handleMouseMove(MouseEvent evt) {
        int my;
        int mx = evt.getX();
        Vector p = this.parent.displayToSpace(mx, my = evt.getY()).translate(this.programValues.xOffset, this.programValues.yOffset);
        if (this.testMouseInsideLens(p, true) != null) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
        this.updateStatusBar(evt.getX(), evt.getY(), false);
        StringBuilder sb = new StringBuilder();
        if (this.ocUnderMouse != null) {
            sb.append(this.ocUnderMouse.values.name);
            sb.append(" ");
        }
        sb.append(String.format("{%s,%s}", this.parent.formatNum(p.x), this.parent.formatNum(p.y)));
        this.setToolTipText(sb.toString());
    }

    void handleMouseDrag(MouseEvent evt) {
        this.updateStatusBar(evt.getX(), evt.getY(), false);
        int mx = evt.getX();
        int my = evt.getY();
        Vector p = this.parent.displayToSpace(mx, my);
        if (!this.shiftKey && !this.ctrlKey) {
            this.programValues.xOffset = -p.x + this.parent.mousePressX;
            this.programValues.yOffset = -p.y + this.parent.mousePressY;
        } else if (this.parent.selectedComponent != null && (this.shiftKey || this.ctrlKey)) {
            this.parent.selectedComponent.values.xPos = p.x + this.parent.mousePressX;
            this.parent.selectedComponent.values.yPos = p.y + this.parent.mousePressY;
            this.parent.selectedComponent.writeObjectControls();
        }
        this.rayTraceProcess(true);
    }

    void detectKeys(MouseEvent evt) {
        this.shiftKey = (evt.getModifiers() & 1) != 0;
        this.ctrlKey = (evt.getModifiers() & 2) != 0;
        this.altKey = (evt.getModifiers() & 8) != 0;
    }

    void handleMouseWheelEvent(MouseWheelEvent evt) {
        int mx = evt.getX();
        int my = evt.getY();
        this.detectKeys(evt);
        double v = evt.getWheelRotation();
        double mv = v * (double)(this.altKey ? 1 : 5);
        if (this.parent.selectedComponent != null) {
            if (this.shiftKey) {
                this.parent.selectedComponent.values.angle = (this.parent.selectedComponent.values.angle + (mv + 720.0)) % 360.0;
                this.parent.selectedComponent.writeObjectControls();
            } else if (this.ctrlKey) {
                this.parent.selectedComponent.values.lensRadius -= mv * 0.01;
                this.parent.selectedComponent.writeObjectControls();
            } else {
                this.programValues.dispScale *= 1.0 - mv * 0.02;
            }
        } else {
            this.programValues.dispScale *= 1.0 - mv * 0.02;
        }
        this.rayTraceProcess(true);
        this.updateStatusBar(mx, my, false);
        evt.consume();
    }

    void handleMousePressEvent(MouseEvent evt) {
        this.parent.undoPush();
        this.requestFocus();
        boolean doubleClick = evt.getClickCount() == 2;
        boolean isPopup = evt.isPopupTrigger();
        this.setCursor(this.moveCursor);
        int mx = evt.getX();
        int my = evt.getY();
        this.detectKeys(evt);
        Vector op = this.parent.displayToSpace(mx, my);
        Vector offset = op.translate(this.programValues.xOffset, this.programValues.yOffset);
        OpticalComponent p = this.testMouseInsideLens(offset, isPopup);
        if (p != null) {
            this.parent.setSelectedComponent(p);
            this.parent.mouseTarget = p;
        }
        if (!this.shiftKey && !this.ctrlKey) {
            this.parent.mousePressX = op.x + this.programValues.xOffset;
            this.parent.mousePressY = op.y + this.programValues.yOffset;
        } else if (p != null) {
            if (this.ctrlKey || this.shiftKey) {
                this.parent.mousePressX = -op.x + p.values.xPos;
                this.parent.mousePressY = -op.y + p.values.yPos;
            }
            this.rayTraceProcess(true);
        }
        if (!(this.shiftKey || this.ctrlKey || this.altKey)) {
            if (isPopup && this.isVisible()) {
                this.setCursor(this.defaultCursor);
                this.parent.popupMouseX = evt.getX();
                this.parent.popupMouseY = evt.getY();
            }
            if (doubleClick) {
                this.parent.lineAnalysis.nearestLineProperties(this.parent.mousePressX, this.parent.mousePressY);
            }
        }
    }

    OpticalComponent testMouseInsideLens(Vector mp, boolean isPopup) {
        ArrayList<OpticalComponent> lensSet = new ArrayList<OpticalComponent>();
        for (OpticalComponent oc : this.parent.componentList) {
            if (!oc.inside(mp, oc.mouseProximityPolygon)) continue;
            lensSet.add(oc);
        }
        if (lensSet.size() == 0) {
            this.ocUnderMouse = null;
            return null;
        }
        if (!(isPopup | this.shiftKey | this.ctrlKey | this.altKey)) {
            ++this.parent.overlappedLensSelector;
        }
        this.ocUnderMouse = (OpticalComponent)lensSet.get(this.parent.overlappedLensSelector % lensSet.size());
        return this.ocUnderMouse;
    }

    void handleMouseReleaseEvent(MouseEvent evt) {
        this.setCursor(this.defaultCursor);
        if (this.parent.selectedComponent != null) {
            this.parent.selectedComponent.snapToGrid();
            if (this.parent.selectedComponent != null) {
                this.parent.selectedComponent.writeObjectControls();
            }
        }
        this.rayTraceProcess(true);
        if (evt.isPopupTrigger()) {
            this.parent.popupMouseX = evt.getX();
            this.parent.popupMouseY = evt.getY();
        }
    }

    protected void contextHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("Mouse related:\n");
        sb.append("  Click once: select object\n");
        sb.append("  Click more: cycle through overlapping objects\n");
        sb.append("  Double-click: list properties of nearest line\n");
        sb.append("  Drag mouse: pan display\n");
        sb.append("  Drag mouse with Shift or Ctrl key: move selected object\n");
        sb.append("  Mouse wheel: zoom display\n");
        sb.append("  Mouse wheel with Shift key: rotate selected object\n");
        sb.append("  Mouse wheel with Ctrl key: rescale selected object\n");
        sb.append("Keyboard related:\n");
        sb.append("  Tab: Move forward through all program controls\n");
        sb.append("  Shift|Tab: Move in reverse through all program controls\n");
        sb.append("  Alt-D: Design tab\n");
        sb.append("  Alt-C: Configure tab\n");
        sb.append("  Alt-T: Table tab\n");
        sb.append("  Alt-H: Help tab\n");
        sb.append("  F1: Concise help dialog (this dialog)\n");
        sb.append("  M or Context-menu key: context menu\n");
        sb.append("  Enter (over object): select object under cursor\n");
        sb.append("  Enter (outside objects): List properties of nearest line\n");
        sb.append("  L: [L]ist properties of nearest line (even inside objects)\n");
        sb.append("  U: [U]nselect all objects\n");
        sb.append("  O: Cycle through [O]bject selections\n");
        sb.append("  Up/down/left/right arrow keys: pan display\n");
        sb.append("  Ctrl|Arrow or Shift|Arrow keys: move selected object\n");
        sb.append("  +/- or Home/End: zoom display in/out\n");
        sb.append("  Ctrl|(+/-) or Ctrl|(Home/End): resize selected object\n");
        sb.append("  Shift|(+/-) or Shift|(Home/End): rotate selected object\n");
        sb.append("Most of the above with Alt key: slower change\n");
        sb.append("This information is also in the Help file, under\n\"Using the mouse and keyboard\".");
        this.parent.showNotifyMessageFormatted(sb.toString(), "Context help");
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                try {
                    if (e.getComponent().isVisible()) {
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

