/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.util.ArrayList;
import java.util.Iterator;
import opticalraytracer.ElementBase;
import opticalraytracer.OpticalComponent;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.Vector;

public final class ElementHyperbolic
implements ElementBase {
    private OpticalRayTracer parent;
    private double zValue = -1.0;
    private double mValue = -1.0;
    private double bValue = -1.0;
    private double lrValue = -1.0;
    private double invLrValue = -1.0;
    private double srValue = -1.0;
    private double epsilon = 1.0E-8;
    private ArrayList<Vector> points;
    private int pointsSize = 4;

    public ElementHyperbolic(OpticalRayTracer p) {
        this.parent = p;
        this.points = new ArrayList();
        int i = 0;
        while (i < this.pointsSize) {
            this.points.add(new Vector());
            ++i;
        }
    }

    @Override
    public ArrayList<Vector> getPoints() {
        return this.points;
    }

    private double pa0(double z, double s, double m, double x_1, double y_1) {
        return (-m * m * s * s * y_1 + s * x_1 - Math.sqrt(s * s * (m * m * s * s * x_1 * x_1 - m * m * s * s * z - 2.0 * m * m * s * x_1 * y_1 + m * m * y_1 * y_1 + z))) / (s * (m * m * s * s - 1.0));
    }

    private double pa1(double z, double s, double m, double x_1, double y_1) {
        return (-m * m * s * s * y_1 + s * x_1 - Math.sqrt(s * s * (m * m * s * s * x_1 * x_1 - m * m * s * s * z - 2.0 * m * m * s * x_1 * y_1 + m * m * y_1 * y_1 + z))) / (m * m * s * s - 1.0);
    }

    private double pa2(double z, double s, double m, double x_1, double y_1) {
        return (-m * m * s * s * y_1 + s * x_1 + Math.sqrt(s * s * (m * m * s * s * x_1 * x_1 - m * m * s * s * z - 2.0 * m * m * s * x_1 * y_1 + m * m * y_1 * y_1 + z))) / (s * (m * m * s * s - 1.0));
    }

    private double pa3(double z, double s, double m, double x_1, double y_1) {
        return (-m * m * s * s * y_1 + s * x_1 + Math.sqrt(s * s * (m * m * s * s * x_1 * x_1 - m * m * s * s * z - 2.0 * m * m * s * x_1 * y_1 + m * m * y_1 * y_1 + z))) / (m * m * s * s - 1.0);
    }

    private double pb(double y, double z, double m, double x_1, double y_1) {
        return -x_1 - Math.sqrt(m * m * y * y + 2.0 * m * m * y * y_1 + m * m * y_1 * y_1 + z);
    }

    private double pd(double y, double z, double m, double y_1) {
        return -m * m * (y + y_1) / Math.sqrt(m * m * y * y + 2.0 * m * m * y * y_1 + m * m * y_1 * y_1 + z);
    }

    private double pm(double z, double r) {
        return -Math.sqrt(r * r + 2.0 * Math.sqrt(r * r * z));
    }

    @Override
    public void intersections(OpticalComponent oc, boolean leftSide, Vector op1, Vector op2) {
        double s;
        Vector p1;
        Vector tc;
        for (Vector p : this.points) {
            p.assign(Vector.invalidState());
        }
        double signedScale = oc.signedScale(leftSide);
        double lensRadius = oc.lensRadius();
        double angleRadians = oc.angleRadians();
        while (true) {
            Vector thr = new Vector(-oc.signedThickness(leftSide), 0.0).rotate(angleRadians);
            tc = new Vector(oc.xPos(), oc.yPos()).translate(thr);
            p1 = new Vector(op1).translateSub(tc).rotate(-angleRadians).scale(1.0 / signedScale, 1.0 / lensRadius);
            Vector p2 = new Vector(op2).translateSub(tc).rotate(-angleRadians).scale(1.0 / signedScale, 1.0 / lensRadius);
            s = (p2.y - p1.y) / (p2.x - p1.x);
            if (Math.abs(s) >= this.epsilon) break;
            angleRadians += this.epsilon;
        }
        this.updateFactors(oc, leftSide);
        int len_d2 = this.points.size() / 2;
        int n = 0;
        Iterator<Vector> ic = this.points.iterator();
        double sb = s < 0.0 ? -this.bValue : this.bValue;
        while (ic.hasNext()) {
            double sbb = n >= len_d2 ? -sb : sb;
            Vector pt = ic.next();
            pt.x = this.pa0(this.zValue, s, this.mValue, p1.x - sbb, p1.y) + p1.x;
            pt.y = this.pa1(this.zValue, s, this.mValue, p1.x - sbb, p1.y) + p1.y;
            pt = ic.next();
            pt.x = this.pa2(this.zValue, s, this.mValue, p1.x + sbb, p1.y) + p1.x;
            pt.y = this.pa3(this.zValue, s, this.mValue, p1.x + sbb, p1.y) + p1.y;
            n += 2;
        }
        double count = 0.0;
        double minx = 1000000.0;
        double maxx = -1000000.0;
        for (Vector p : this.points) {
            if (leftSide) {
                p.x = p.x < 0.0 ? Double.NaN : p.x;
            } else {
                double d = p.x = p.x > 0.0 ? Double.NaN : p.x;
            }
            if (Double.isNaN(p.x)) continue;
            minx = Math.min(minx, p.x);
            maxx = Math.max(maxx, p.x);
            count += 1.0;
        }
        if (!oc.isReflector() && count > 1.0) {
            for (Vector p : this.points) {
                p.x = p.x < 0.0 && p.x == minx ? Double.NaN : p.x;
                double d = p.x = p.x > 0.0 && p.x == maxx ? Double.NaN : p.x;
            }
        }
        for (Vector p : this.points) {
            p.assign(p.scale(signedScale, lensRadius).rotate(angleRadians).translate(tc));
        }
    }

    @Override
    public double lensProfileXforY(OpticalComponent oc, boolean leftSide, double y, double cx) {
        this.updateFactors(oc, leftSide);
        return this.lensProfileXforYCore(oc, leftSide, y, cx);
    }

    public double lensProfileXforYCore(OpticalComponent oc, boolean leftSide, double y, double cx) {
        double x = -this.pb(y / oc.lensRadius(), this.zValue, this.mValue, cx + this.bValue, 0.0) * oc.scale(leftSide) * oc.radiusSign(leftSide) - oc.thickness();
        if (leftSide) {
            x = -x;
        }
        return x;
    }

    @Override
    public double lensProfileDXforY(OpticalComponent oc, boolean leftSide, boolean entering, double y) {
        this.updateFactors(oc, leftSide);
        double dx = this.pd(y * this.invLrValue, this.zValue, this.mValue, 0.0) * oc.scale(leftSide) * oc.radiusSign(leftSide) * this.invLrValue;
        if (leftSide) {
            dx = -dx;
        }
        return -dx;
    }

    private void updateFactors(OpticalComponent oc, boolean leftSide) {
        double newZ = oc.zValue(leftSide);
        double newSR = oc.sphereRadius(leftSide);
        double newLR = oc.lensRadius();
        if (this.zValue != newZ || newLR != this.lrValue || newSR != this.srValue) {
            this.mValue = this.pm(newZ, 1.0);
            this.bValue = this.pb(1.0, newZ, this.mValue, 0.0, 0.0);
            this.zValue = newZ;
            this.lrValue = newLR;
            this.invLrValue = 1.0 / newLR;
            this.srValue = newSR;
        }
    }
}

