/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import opticalraytracer.DataTableModel;
import opticalraytracer.LineData;
import opticalraytracer.OpticalRayTracer;

public final class DataTableDisplay
extends JTable {
    OpticalRayTracer parent;
    DataTableModel dataTableModel;
    int hScroll;
    int vScroll;

    public DataTableDisplay(OpticalRayTracer p) {
        this.parent = p;
        Font origfont = this.getFont();
        Font f = new Font("Monospaced", 0, origfont.getSize());
        this.setFont(f);
        this.getTableHeader().setFont(f);
        this.dataTableModel = new DataTableModel(p, this);
        this.setModel(this.dataTableModel);
        this.updateDisplay();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DataTableDisplay.this.updateDisplay();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataTableDisplay.this.hScroll = DataTableDisplay.this.parent.tableScrollPane.getHorizontalScrollBar().getValue();
                DataTableDisplay.this.vScroll = DataTableDisplay.this.parent.tableScrollPane.getVerticalScrollBar().getValue();
            }
        });
        this.setToolTipText("Double-click: copy line to clipboard");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                LineData ld;
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                if (me.getClickCount() == 2 && (ld = DataTableDisplay.this.dataTableModel.getRowData(row)) != null) {
                    DataTableDisplay.this.parent.lineAnalysis.copyLineToClipboard(ld);
                }
            }
        });
    }

    protected void updateDisplay() {
        this.dataTableModel.updateDisplay();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableDisplay.this.parent.tableScrollPane.getHorizontalScrollBar().setValue(DataTableDisplay.this.hScroll);
                DataTableDisplay.this.parent.tableScrollPane.getVerticalScrollBar().setValue(DataTableDisplay.this.vScroll);
            }
        });
    }
}

