/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class DataTableCellRenderer
extends JLabel
implements TableCellRenderer {
    Color evenColor;
    Color oddColor;
    Color[] rowColors;
    boolean[] rightJust;

    public DataTableCellRenderer(boolean[] rightJust) {
        this.rightJust = rightJust;
        this.setOpaque(true);
        this.evenColor = new Color(0xFFFFFF);
        this.oddColor = new Color(0xF0F0F0);
        this.rowColors = new Color[]{this.evenColor, this.oddColor};
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            this.setText((String)value);
        }
        this.setOpaque(true);
        this.setBackground(this.rowColors[row % 2]);
        this.setHorizontalAlignment(this.rightJust[column] ? 4 : 2);
        this.setFont(table.getFont());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        }
        return this;
    }
}

