/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import opticalraytracer.Common;
import opticalraytracer.LocaleHandler;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.ProgramControl;

public final class ControlManager
implements ProgramControl {
    JTextField numberField = null;
    JTextField nameField = null;
    JCheckBox box = null;
    JRadioButton radio;
    JComboBox<String> comboBox = null;
    ArrayList<JRadioButton> radioButtonArray;
    static int[] radioButtonList = new int[]{-1, -1, -1};
    int radioButtonIndex = -1;
    OpticalRayTracer parent;
    double sens = 1.0;
    double dmin;
    double dmax;
    int imin;
    int imax;
    private String tag = "";

    public ControlManager(JTextField field, OpticalRayTracer p, String tag) {
        this.nameField = field;
        this.init(p, tag);
        this.assignHandlers(field);
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                int kcode = evt.getKeyCode();
                if (kcode == 10) {
                    evt.consume();
                    ControlManager.this.updateAllControls();
                }
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ControlManager.this.updateAllControls();
            }
        });
    }

    public ControlManager(double sens, double min, double max, JTextField field, OpticalRayTracer p, String tag) {
        this.numberField = field;
        this.dmin = min;
        this.dmax = max;
        this.sens = sens;
        this.init(p, tag);
        this.assignHandlers(field);
    }

    public ControlManager(JCheckBox box, OpticalRayTracer p, String tag) {
        this.box = box;
        this.init(p, tag);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlManager.this.updateAllControls();
            }
        });
    }

    public ControlManager(JRadioButton b, OpticalRayTracer p, String tag) {
        this.radio = b;
        this.init(p, tag);
        int i = 0;
        ArrayList<ArrayList> radioArrayList = new ArrayList<ArrayList>(Arrays.asList(this.parent.typeRadioButtonList));
        for (ArrayList bl : radioArrayList) {
            if (bl.indexOf(b) != -1) {
                this.radioButtonIndex = i;
                this.radioButtonArray = bl;
            }
            ++i;
        }
        this.radio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlManager.radioButtonList[ControlManager.this.radioButtonIndex] = ControlManager.this.radioButtonArray.indexOf(ControlManager.this.radio);
                ControlManager.this.updateAllControls();
            }
        });
    }

    public ControlManager(JComboBox<String> cb, OpticalRayTracer p, String tag) {
        this.comboBox = cb;
        this.init(p, tag);
        this.init(p, tag);
        String[] stringArray = Common.curvatures;
        int n = Common.curvatures.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.comboBox.addItem(s);
            ++n2;
        }
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ControlManager.this.parent.suppressCombo) {
                    ControlManager.this.updateAllControls();
                }
            }
        });
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    void init(OpticalRayTracer p, String tag) {
        this.parent = p;
        this.tag = tag;
    }

    @Override
    public void reset() {
    }

    public void assignHandlers(Component comp) {
        comp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                ControlManager.this.handleMouseWheelMoved(evt);
            }
        });
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ControlManager.this.handleKeyPressed(evt);
            }
        });
    }

    void enable(boolean enabled) {
        if (this.numberField != null) {
            this.numberField.setEnabled(enabled);
            if (!enabled) {
                this.numberField.setText("(Select a lens)");
            }
        } else if (this.nameField != null) {
            this.nameField.setEnabled(enabled);
            if (!enabled) {
                this.nameField.setText("");
            }
        } else if (this.box != null) {
            this.box.setEnabled(enabled);
        } else if (this.radio != null) {
            for (JRadioButton jb : this.radioButtonArray) {
                jb.setEnabled(enabled);
            }
        } else if (this.comboBox != null) {
            this.comboBox.setEnabled(enabled);
        }
    }

    @Override
    public String getValue() {
        String result = "";
        result = this.numberField != null ? this.numberField.getText() : (this.nameField != null ? this.nameField.getText() : (this.box != null ? "" + this.box.isSelected() : (this.comboBox != null ? "" + this.comboBox.getSelectedIndex() : "" + radioButtonList[this.radioButtonIndex])));
        return result;
    }

    @Override
    public void setValue(String s) {
        if (this.numberField != null) {
            double v = 0.0;
            try {
                v = LocaleHandler.getDouble(s, LocaleHandler.localeDecimalSeparator);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.numberField.setText(this.parent.formatNum(v));
        } else if (this.nameField != null) {
            this.nameField.setText(s);
        } else if (this.box != null) {
            this.box.setSelected(s.matches("(?i).*true.*"));
        } else if (this.comboBox != null) {
            int v = Integer.parseInt(s);
            this.parent.suppressCombo = true;
            this.comboBox.setSelectedIndex(v);
            this.parent.suppressCombo = false;
        } else if (this.radio != null) {
            int v = Integer.parseInt(s);
            this.radioButtonArray.get(v).setSelected(true);
            ControlManager.radioButtonList[this.radioButtonIndex] = v;
        }
    }

    void setDoubleValue(double v) {
        try {
            this.numberField.setText(this.parent.formatNum(v));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    double getDoubleValue() {
        double v = 0.0;
        try {
            v = LocaleHandler.getDouble(this.numberField.getText(), LocaleHandler.localeDecimalSeparator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    void setBooleanValue(boolean v) {
        try {
            this.box.setSelected(v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean getBooleanValue() {
        boolean v = false;
        try {
            v = this.box.isSelected();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    private void handleKeyPressed(KeyEvent evt) {
        int n = 0;
        double sign = 0.0;
        double v = this.sens;
        boolean consume = true;
        v = evt.isShiftDown() ? v * 0.1 : v;
        v = evt.isAltDown() ? v * 0.1 : v;
        int kcode = evt.getKeyCode();
        if (kcode == 10) {
            sign = 1.0;
        } else if (kcode == 36) {
            n = 100;
            sign = 1.0;
        } else if (kcode == 35) {
            n = -100;
            sign = 1.0;
        } else if (kcode == 33) {
            n = 10;
            sign = 1.0;
        } else if (kcode == 34) {
            n = -10;
            sign = 1.0;
        } else if (kcode == 40) {
            n = -1;
            sign = 1.0;
        } else if (kcode == 38) {
            n = 1;
            sign = 1.0;
        } else if (kcode == 27) {
            n = 0;
            sign = -1.0;
        } else {
            consume = false;
        }
        if (consume) {
            evt.consume();
        }
        this.handleIncrement(n, sign, v);
        evt.consume();
    }

    private void handleMouseWheelMoved(MouseWheelEvent evt) {
        double v = this.sens;
        v = evt.isShiftDown() ? v * 0.1 : v;
        v = evt.isAltDown() ? v * 0.1 : v;
        this.handleIncrement(-evt.getWheelRotation(), 1.0, v);
        evt.consume();
    }

    void handleIncrement(int n, double sign, double sv) {
        if (sign != 0.0) {
            if (this.numberField != null) {
                String text = this.numberField.getText();
                double dv = 0.0;
                try {
                    dv = LocaleHandler.getDouble(text, LocaleHandler.localeDecimalSeparator);
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(this.getClass().getName()) + ": Error: " + e);
                }
                dv += (double)n * sv;
                dv *= sign;
                dv = Math.min(this.dmax, dv);
                dv = Math.max(this.dmin, dv);
                String s = this.parent.formatNum(dv);
                this.numberField.setText(s);
            }
            this.updateAllControls();
        }
    }

    private void updateAllControls() {
        this.parent.undoPush();
        if (this.parent != null) {
            this.parent.readProgramControls();
            if (this.parent.selectedComponent != null) {
                this.parent.selectedComponent.readObjectControls();
            }
            if (this.parent.currentTab() == 2) {
                this.parent.dataTableDisplay.updateDisplay();
            }
        }
    }
}

