/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "interfacedatamanager.h"

// must have this for toLowerCase below

class op_tolower : unary_function<char, char> {
public:
    op_tolower() {}
    ;
    char operator()(const char c) {
        return tolower(c);
    }
};

InterfaceDataManager::InterfaceDataManager() {
    dataTree = new(MMSS);
    interfaceList = new (vector <string>);
}


InterfaceDataManager::~InterfaceDataManager() {
    delete(dataTree);
    delete(interfaceList);
}

void InterfaceDataManager::dumpEverything(string path, string match) {
    readDirectory(path,match);
    for(MMSS::iterator i = dataTree->begin();i != dataTree->end();i++) {
        cout << i->first << "\n";
        MSS m = i->second;
        for(MSS::iterator j = m.begin();j != m.end();j++) {
            cout << "\t\t" << j->first << " === " << j->second << "\n";
        }
    }
}

vector <string> InterfaceDataManager::getInterfaceList() {
    return *interfaceList;
}

string InterfaceDataManager::getInterfaceName(int i) {
    return (*interfaceList)[i];
}

string InterfaceDataManager::getDeviceName(int i) {
    return (*dataTree)[(*interfaceList)[i]]["device"];
}

int InterfaceDataManager::readDirectory(string path,string match) {
    DIR *p;
    if(dataTree != NULL) {
        delete(dataTree);
    }
    if(interfaceList != NULL) {
        delete(interfaceList);
    }
    interfaceList = new (vector <string>);
    dataTree = new (MMSS);
    if((p = opendir(path.c_str()))) {
        struct dirent *d;
        while((d = readdir(p))) {
            string s = string(d->d_name);
            size_t p = s.find(match);
            if(p != string::npos) {
                string name = s.substr(p + match.length());
                interfaceList->push_back(name);
                MSS m = readFile(path + "/" + string(d->d_name));
                (*dataTree)[name] = m;
            }
        }
        closedir(p);
        sort(interfaceList->begin(),interfaceList->end());
    }
    return interfaceList->size();
}

MSS InterfaceDataManager::readFile(string fn) {
    MSS m;
    ifstream ifs(fn.c_str());
    string s;
    while(getline(ifs,s)) {
        vector <string> sp = split(s,string("="));
        if(sp.size() == 2) {
            m[sp[0]] = sp[1];
        }
    }
    ifs.close();
    return m;
}

vector <string> InterfaceDataManager::split(string s,string delim) {
    vector <string> v;
    size_t p = s.find(delim);
    if(p != string::npos) {
        string a = trimWhitespace(s.substr(0,p));
        string b = trimWhitespace(s.substr(p+delim.length()));
        toLowerCase(a);
        v.push_back(a);
        v.push_back(b);
    }
    return v;
}

vector <string> InterfaceDataManager::splitOnWhitespace(string s) {
    vector <string> v;
    size_t a = 0,b,c;
    while((b = s.find_first_of(" \t",a)) != string::npos) {
        v.push_back(s.substr(a,b));
        // test for multiple whitespace chars
        if((c = s.find_first_not_of(" \t",b)) != string::npos) {
            a = c;
        } else {
            a = b+1;
        }
    }
    v.push_back(s.substr(a));
    return v;
}

string InterfaceDataManager::trimWhitespace(string s) {
    // trim left
    size_t p = s.find_first_not_of(" \n\r\t");
    if(p != string::npos) {
        s.erase(0,p);
    } else {
        s = "";
    }
    // trim right
    p = s.find_last_not_of(" \n\r\t");
    if(p != string::npos) {
        s.erase(p+1);
    }
    return s;
}

void InterfaceDataManager::toLowerCase(string& s) {
    transform(s.begin(),s.end(),s.begin(),op_tolower());
}


