/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dirlist.h"

#include <string.h>
#include <qstring.h>

DirList::DirList() {}


DirList::~DirList() {}


void DirList::makeList(vecDn& vi, QString& path, QString& match) {
    DIR *p;
    if((p = opendir(path))) {
        struct dirent *d;
        while((d = readdir(p))) {
            if (QString(d->d_name).find(match) >= 0) {
                vi.push_back(QString(d->d_name));
            }
        }
        closedir(p);
    }
}
