/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
package magiclantern;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

/**
 *
 * @author lutusp
 */
final public class MyMessageDialog extends javax.swing.JDialog {

    /** Creates new form ModalDialog */
    public MyMessageDialog(java.awt.Frame parent, boolean modal, String title, String message, Image icon) {
        super(parent, modal);
        setTitle(title);
        if (icon != null) {
            setIconImage(icon);
        }
        initComponents();
        messageTextArea.setText(message);
        messageTextArea.setSelectionStart(0);
        messageTextArea.setSelectionEnd(0);
        pack();
        setLocationRelativeTo(parent);
        setVisible(true);
    }

    void close() {
        setVisible(false);
        dispose();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        OKButton = new javax.swing.JButton();
        messageTextArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        OKButton.setText("OK");
        OKButton.setMaximumSize(new java.awt.Dimension(64, 48));
        OKButton.setMinimumSize(new java.awt.Dimension(48, 29));
        OKButton.setPreferredSize(new java.awt.Dimension(48, 29));
        OKButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                OKButtonMouseClicked(evt);
            }
        });
        jPanel1.add(OKButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        messageTextArea.setColumns(20);
        messageTextArea.setEditable(false);
        messageTextArea.setFont(new java.awt.Font("Monospaced", 0, 14));
        messageTextArea.setRows(5);
        messageTextArea.setMargin(new java.awt.Insets(8, 8, 8, 8));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(messageTextArea, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void OKButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_OKButtonMouseClicked
        // TODO add your handling code here:
        close();
    }//GEN-LAST:event_OKButtonMouseClicked

    /**
     * @param args the command line arguments
     */
    /* public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                ModalDialog dialog = new ModalDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }*/

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton OKButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextArea messageTextArea;
    // End of variables declaration//GEN-END:variables
}
