/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MyHelpPane.java
 *
 * Created on Feb 18, 2009, 2:12:32 PM
 */
package magiclantern;

import javax.swing.*;
import java.net.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.text.*;
import javax.swing.text.html.HTMLDocument.*;
import java.util.*;

/**
 *
 * @author lutusp
 */
final public class MyHelpPane extends javax.swing.JPanel {

    MagicLantern parent;
    Stack<Integer> undoStack;
    Stack<Integer> redoStack;
    Document doc;
    String oldSearch = "";
    int oldPos = 0;
    Object oldHighlight = null;
    Highlighter highlighter;
    Highlighter.HighlightPainter highlightPainter;

    /** Creates new form MyHelpPane */
    public MyHelpPane(MagicLantern p) {
        parent = p;
        initComponents();
        doc = helpTextPane.getDocument();
        undoStack = new Stack<Integer>();
        redoStack = new Stack<Integer>();
        highlighter = helpTextPane.getHighlighter();
        highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(200, 255, 200));
        setupHelp();
        setButtons();
        setFocus();
    }

    void setFocus() {
        SwingUtilities.invokeLater(
                new Runnable() {

                    public void run() {
                        findTextField.requestFocus();
                    }
                });
    }

    void setupHelp() {
        Thread t = new Thread() {

            @Override
            public void run() {
                setupHelpThread();
            }
        };
        t.start();
    }

    // help resource related
    void setupHelpThread() {
        String fn = "help/MagicLanternHelp.html";
        try {
            URL helpURL = getClass().getResource(fn).toURI().toURL();
            helpTextPane.setPage(helpURL);
        } catch (Exception e) {
            System.out.println(e);
        }
        try {
            Thread.sleep(2000);
        } catch (Exception e) {
        }
        editContent();
    }

    void editContent() {
        String s = helpTextPane.getText();
        s = s.replaceAll("\\(application path\\)", parent.appPath.replaceAll("\\\\", "&#92;"));
        s = s.replaceAll("\\(data path\\)", parent.dataPath.replaceAll("\\\\", "&#92;"));
        s = s.replaceAll("\\(configuration path\\)", parent.configPath.replaceAll("\\\\", "&#92;"));
        s = s.replaceAll("\\(browse path\\)", parent.browseContentPath.replaceAll("\\\\", "&#92;"));
        s = s.replaceAll("\\(extension path\\)", parent.extPath.replaceAll("\\\\", "&#92;"));
        s = s.replaceAll("\\(user home directory\\)", parent.userDir.replaceAll("\\\\", "&#92;"));
        s = s.replaceAll("\\(version\\)", parent.appVersion);
        helpTextPane.setText(s);
        helpTextPane.select(0, 0);
    }

    // manageHyperlinks tries to find and launch a browser
    void manageHyperlinks(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String surl = evt.getURL().toString();
            if (surl.matches("http://.*")) {
                String os = System.getProperty("os.name");
                String prefix = (os.matches("(?i).*windows.*") ? "cmd.exe /c start" : "");
                /// popular browser names
                String browserNames[] = {"firefox", "iexplore", "mozilla", "konqueror", "safari", "opera", "chrome"};
                boolean success = false;
                for (int j = 0; j <
                        browserNames.length && !success; j++) {
                    try {
                        Process p = Runtime.getRuntime().exec(prefix + " " + browserNames[j] + " " + evt.getURL());
                        success =
                                true;
                    } catch (Exception e) {
                    }
                }
            } else { // possibly a bookmark
                if (surl.matches(".*#.*")) {
                    try {
                        pushUndo();
                        helpTextPane.scrollToReference(url.getRef());

                    } catch (Exception e) {
                        System.out.println(e);
                    }
                }
            }
        }
    }

    void undo() {
        if (undoStack.size() > 0) {
            removeOldHighlight();
            pushRedo();
            helpScrollPane.getVerticalScrollBar().setValue(undoStack.pop());
            setButtons();
        } else {
            CommonCode.beep();
        }
    }

    void redo() {
        if (redoStack.size() > 0) {
            removeOldHighlight();
            pushUndo();
            helpScrollPane.getVerticalScrollBar().setValue(redoStack.pop());
            setButtons();
        } else {
            CommonCode.beep();
        }
    }

    void pushUndo() {
        undoStack.push(helpScrollPane.getVerticalScrollBar().getValue());
        setButtons();
    }

    void pushRedo() {
        redoStack.push(helpScrollPane.getVerticalScrollBar().getValue());
        setButtons();
    }

    void setButtons() {
        undoButton.setEnabled(undoStack.size() > 0);
        redoButton.setEnabled(redoStack.size() > 0);
    }

    void removeOldHighlight() {
        if (oldHighlight != null) {
            highlighter.removeHighlight(oldHighlight);
            oldHighlight = null;
        }
    }

    void manageHelpTextField(KeyEvent evt) {
        String code = KeyEvent.getKeyText(evt.getKeyCode());
        // if a function key, go to main command switchboard
        if (code.matches("F\\d")) {
            parent.handleKeyPressed(evt);
        } else {
            try {

                removeOldHighlight();
                doc = helpTextPane.getDocument();
                int len = doc.getLength();
                String content = doc.getText(0, len).toLowerCase();
                String search = findTextField.getText().toLowerCase();
                if (!search.equals(oldSearch)) {
                    oldPos = 0;
                }
                oldSearch = search;
                int p = content.indexOf(search, oldPos);
                if (p == -1) {
                    oldPos = 0;
                    p = content.indexOf(search, oldPos);
                }
                if (p >= 0) { // if found
                    pushUndo();
                    int slen = search.length();
                    Rectangle r = helpTextPane.modelToView(p);
                    // aim for the middle of the screen
                    int pos = r.y - helpScrollPane.getHeight() / 2;
                    // but don't try for the impossible
                    pos = (pos < 0) ? 0 : pos;
                    helpScrollPane.getVerticalScrollBar().setValue(pos);
                    // now highlight the found text in our nonfocused text pane
                    oldHighlight = highlighter.addHighlight(p, p + slen, highlightPainter);
                    oldPos = p + 1; // to find next case
                } else {
                    CommonCode.beep();
                }
            } catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        undoButton = new javax.swing.JButton();
        redoButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        findTextField = new javax.swing.JTextField();
        helpScrollPane = new javax.swing.JScrollPane();
        helpTextPane = new javax.swing.JTextPane();

        setLayout(new java.awt.GridBagLayout());

        undoButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/go-previous.png"))); // NOI18N
        undoButton.setToolTipText("Go back");
        undoButton.setFocusable(false);
        undoButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                undoButtonMouseClicked(evt);
            }
        });
        jPanel1.add(undoButton);

        redoButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/go-next.png"))); // NOI18N
        redoButton.setToolTipText("Go forward");
        redoButton.setFocusable(false);
        redoButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                redoButtonMouseClicked(evt);
            }
        });
        jPanel1.add(redoButton);

        jLabel1.setText("Search:");
        jPanel1.add(jLabel1);

        findTextField.setToolTipText("<html>Quick search: type a search string,<br/>press Enter to find the next case</html>");
        findTextField.setFocusCycleRoot(true);
        findTextField.setMinimumSize(new java.awt.Dimension(150, 27));
        findTextField.setPreferredSize(new java.awt.Dimension(150, 27));
        findTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                findTextFieldKeyReleased(evt);
            }
        });
        jPanel1.add(findTextField);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jPanel1, gridBagConstraints);

        helpScrollPane.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        helpTextPane.setBackground(java.awt.Color.white);
        helpTextPane.setEditable(false);
        helpTextPane.setFocusable(false);
        helpTextPane.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                helpTextPaneHyperlinkUpdate(evt);
            }
        });
        helpScrollPane.setViewportView(helpTextPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(helpScrollPane, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void helpTextPaneHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {//GEN-FIRST:event_helpTextPaneHyperlinkUpdate
        // TODO add your handling code here:
        manageHyperlinks(evt);
    }//GEN-LAST:event_helpTextPaneHyperlinkUpdate

    private void undoButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_undoButtonMouseClicked
        // TODO add your handling code here:
        undo();
}//GEN-LAST:event_undoButtonMouseClicked

    private void redoButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_redoButtonMouseClicked
        // TODO add your handling code here:
        redo();
}//GEN-LAST:event_redoButtonMouseClicked

    private void findTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_findTextFieldKeyReleased
        // TODO add your handling code here:
        manageHelpTextField(evt);
    }//GEN-LAST:event_findTextFieldKeyReleased

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField findTextField;
    private javax.swing.JScrollPane helpScrollPane;
    private javax.swing.JTextPane helpTextPane;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton redoButton;
    private javax.swing.JButton undoButton;
    // End of variables declaration//GEN-END:variables
}
