/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
package magiclantern;

import java.lang.reflect.Field;
import java.util.*;
import java.io.*;
import java.awt.*;

/**
 *
 * @author lutusp
 */
final public class InitManager {

    String initPath;
    ProgramValues progVals;
    MagicLantern parent;

    public InitManager(MagicLantern p,String pa, ProgramValues v) {
        parent = p;
        initPath = pa;
        progVals = v;
        readConfig();
    //getVarNames();
    }

    Field[] getFieldNames() {
        return progVals.getClass().getFields();
    }

    String[] parsePair(String val) {
        String pair[] = null;
        int p = val.indexOf("=");
        if (p > 0) {
            pair = new String[]{val.substring(0, p), val.substring(p + 1, val.length())};
            for (int i = 0; i < 2 && i < pair.length; i++) {
                pair[i] = pair[i].replaceFirst("^\\s*(.*?)\\s*$", "$1");
            }
        }
        return pair;
    }

    public boolean readConfig() {
        boolean result = false;
        Class pc = progVals.getClass();
        String data = CommonCode.readTextFile(initPath,parent.lineSep);
        if (data != null) {
            String values[] = data.split(parent.lineSep);
            for (int i = 0; i < values.length; i++) {
                String item = CommonCode.strip(values[i]);
                String[] pair = parsePair(item);
                try {
                    //System.out.println("looking for [" + pair[0] + "]");
                    Field f = pc.getDeclaredField(pair[0]);
                    String fc = f.getType().toString();
                    //System.out.println(fc);
                    if (fc.equals("int")) {
                        f.setInt(progVals, Integer.parseInt(pair[1]));
                    } else if (fc.equals("double")) {
                        f.setDouble(progVals, Double.parseDouble(pair[1]));
                    } else if (fc.equals("boolean")) {
                        f.setBoolean(progVals, pair[1].equals("true"));
                    } else if (fc.equals("class java.lang.String")) {
                        f.set(progVals, pair[1]);
                    } // This is so terrible. Surely there's an easier way
                    else if (fc.equals("class java.awt.Rectangle")) {
                        String s = pair[1].replaceFirst("^.*x=([-|\\d]+).*y=([-|\\d]+).*width=([-|\\d]+).*height=([-|\\d]+).*$", "$1,$2,$3,$4");
                        String s_vals[] = s.split(",");
                        Vector<Integer> vi = new Vector<Integer>();
                        for (int j = 0; j < s_vals.length; j++) {
                            vi.add(Integer.parseInt(s_vals[j]));
                        }
                        Iterator<Integer> it = vi.iterator();
                        Rectangle r = new Rectangle(it.next(), it.next(), it.next(), it.next());
                        f.set(progVals, r);
                    }
                } catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        return result;
    }

    public boolean writeConfig() {
        boolean result = false;
        Vector<String> data = new Vector<String>();
        Field[] fns = getFieldNames();
        String name, value = "";
        for (int i = 0; i < fns.length; i++) {
            name = fns[i].getName();
            try {
                value = fns[i].get(progVals).toString();
            } catch (IllegalAccessException e) {
                System.out.println(e);
            }
            data.add(name + " = " + value);
        }
        String[] array = (String[]) data.toArray(new String[]{});
        String output = CommonCode.join(array, parent.lineSep) + parent.lineSep;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(initPath));
            bw.write(output);
            bw.close();
        } catch (IOException e) {
            System.out.println(e);
        }
        return result;
    }
}
