/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package magiclantern;

import javax.swing.*;
import java.io.*;

import java.awt.event.*;
import java.util.*;

/**
 *
 * @author lutusp
 */
final public class EditShowPanel extends EditBrowsePanelCoreRoutines {

    /** Creates new form EditPanel */
    public EditShowPanel(MagicLantern p, EditBase b) {
        super(p, b);
        initComponents();
        initialize(editorList, editPopupMenu, SaveButton);
        populateFileComboBox();
        setupColumnsComboBox();
        SlideDurationTextField.setText("" + parent.programValues.editSlideDurationSeconds);
        readShowFile();
        setupTooltips(true);
        updateCutCopyPasteButtons();
    }

    void setupColumnsComboBox() {
        columnsComboBox.removeAllItems();
        for (int i = 1; i < 8; i++) {
            columnsComboBox.addItem(i);
        }
        columnsComboBox.setSelectedIndex(parent.editColumns - 1);
    }

    void populateFileComboBox() {
        parent.buildShowList(showComboBox, parent.dataPath);
        if (parent.programValues.editSelectedShow.length() > 0) {
            showComboBox.setSelectedItem(parent.programValues.editSelectedShow);
        }
        else {
           showComboBox.setSelectedIndex(0);
        }
    }

    void setEditColumns(ActionEvent evt) {
        if ((evt.getModifiers() & ActionEvent.MOUSE_EVENT_MASK) != 0) {
            parent.editColumns = columnsComboBox.getSelectedIndex() + 1;
            reformatDisplay();
            base.browsePanel.reformatDisplay();
        }
    }

    @Override
    void updateButtons() {
        UndoButton.setEnabled(undoStack.size() > 0);
        RedoButton.setEnabled(redoStack.size() > 0);
        SaveButton.setEnabled(contentChanged);
    }

    void updateCutCopyPasteButtons() {
        super.updateCutCopyPasteButtons(cutMenuItem, copyMenuItem, pasteMenuItem, cutButton, copyButton, pasteButton);
    }

    void comboActionPerformed(ActionEvent evt) {
        if ((evt.getModifiers() & ActionEvent.MOUSE_EVENT_MASK) != 0) {
            readShowFile();
        }
    }

    void readShowFile() {
        if (contentChanged) {
            if (!saveFileOnExit()) {
                return;
            }
        }
        editListModel.removeAllElements();
        String selection = (String) showComboBox.getSelectedItem();
        if (selection != null) {
            if (selection.equals(parent.disabledTitle)) {
                activeFile = null;
            } else {
                activeFile = parent.dataPath + parent.fileSep + selection + ".txt";
                String data = CommonCode.readTextFile(activeFile, parent.lineSep);
                if (data != null) {
                    String[] array = data.split(parent.lineSep);
                    for (int i = 0; i < array.length; i++) {
                        String fn = CommonCode.strip(array[i]);
                        addListItem(fn);
                    }
                }
            }
            parent.programValues.editSelectedShow = selection;
        }
        reformatDisplay();
        setContentChanged(false);
        parent.setStatus("Read " + editListModel.size() + " slides", false, 1);
    }

    boolean saveShowFile() {
        boolean saved = false;
        if (contentChanged && activeFile != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < editListModel.size(); i++) {
                EditCellDatum ecd = (EditCellDatum) editListModel.get(i);
                sb.append(ecd.getPath() + parent.lineSep);
            }
            if (saved = CommonCode.saveTextFile(parent,sb.toString(), activeFile, false)) {
                setContentChanged(false);
                parent.readShowFile(true);
            }
        }
        return saved;
    }

    boolean saveFileOnExit() {
        boolean proceed = false;
        if (contentChanged && activeFile != null) {
            File f = new File(activeFile);
            int reply = JOptionPane.showConfirmDialog(parent, "File \"" + f.getName() + "\" has been changed. Want to save it?", "Save Changed File", JOptionPane.YES_NO_CANCEL_OPTION);
            proceed = (reply == JOptionPane.YES_OPTION);
            if (proceed) {
                proceed = saveShowFile(); // if this fails, proceed won't be set
            } else if (reply == JOptionPane.NO_OPTION) {
                proceed = true;
            } // cancel stops the exit
        } else {
            proceed = true;
        }
        if (proceed) {
            contentChanged = false;
        }
        return proceed;
    }

    void handleKeyPressed(KeyEvent evt) {
        String kcode = KeyEvent.getKeyText(evt.getKeyCode());
        String mcode = KeyEvent.getKeyModifiersText(evt.getModifiers());
        String key = mcode + "+" + kcode;
        if (key.equals("Ctrl+X")) {
            cutAction();
        } else if (key.equals("Ctrl+C")) {
            copyAction();
        } else if (key.equals("Ctrl+V")) {
            pasteAction();
        } else if (key.equals("Ctrl+Z")) {
            undo();
        } else if (key.equals("Ctrl+Shift+Z")) {
            redo();
        }

    }

    String ldgzro(int v) {
        String s = "" + v;
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    @Override
    void updateShowDisplay() {
        int slides = editListModel.size();
        int v = parent.programValues.editSlideDurationSeconds * slides;
        int sec = v % 60;
        v /=
                60;
        int m = v % 60;
        v /=
                60;
        int h = v;
        // always wanted to do this ...
        String s = "" + slides + " | " + ldgzro(h) + ":" + ldgzro(m) + ":" + ldgzro(sec);
        statusLabel.setText(s);
    }

    void setDurationIfEnter(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            try {
                int v = Integer.parseInt(SlideDurationTextField.getText());
                if (v > 0) {
                    parent.programValues.editSlideDurationSeconds = v;
                    updateShowDisplay();

                }
            } catch (Exception e) {
                System.out.println(e);
                SlideDurationTextField.setText("" + parent.programValues.editSlideDurationSeconds);
            }
        }
    }

    void createNewShow() {
        String showName = JOptionPane.showInputDialog(this, "Please enter a name for the new show", "Create New Show", JOptionPane.QUESTION_MESSAGE);
        showName = CommonCode.strip(showName);
        if (showName.length() > 0) {
            String path = parent.dataPath + parent.fileSep + showName + ".txt";
            File f = new File(path);
            if (f.exists()) {
                JOptionPane.showMessageDialog(this, "There is already a show with the name \"" + showName + "\". Please choose another name.", "Duplicate Show", JOptionPane.WARNING_MESSAGE);
            } else {
                CommonCode.saveTextFile(parent,"", path, false);
                parent.programValues.editSelectedShow = showName;
                populateFileComboBox();
                readShowFile();
                parent.updateShowList();
            }
        }
    }

    void searchForDuplicates() {
        Vector<String> paths = new Vector<String>();
        HashMap<String, Vector<Integer>> map = new HashMap<String, Vector<Integer>>();
        for (int i = 0; i < editListModel.getSize(); i++) {
            EditCellDatum ecd = (EditCellDatum) editListModel.get(i);
            String path = ecd.getPath();
            paths.add(path);
            if (!map.containsKey(path)) {
                map.put(path, new Vector<Integer>());
            }
            map.get(path).add(i + 1); // 1-based numbering
        }
        HashMap<String, Boolean> dups = new HashMap<String, Boolean>();
        StringBuffer sb = new StringBuffer();
        String s = "";
        for (int i = 0; i < paths.size(); i++) {
            String path = paths.get(i);
            if (!dups.containsKey(path)) {
                dups.put(path, true);
                Vector v = map.get(path);
                if (v.size() > 1) {
                    if (s.length() == 0) {
                        sb.append("The following duplicates were found:" + parent.lineSep + parent.lineSep);
                    }
                    s = "Path " + path + ", locations: ";
                    for (int j = 0; j < v.size(); j++) {
                        if (j > 0) {
                            s += ",";
                        }
                        s += v.get(j);
                    }
                    sb.append(s + parent.lineSep);
                }
            }
        }
        if (sb.length() > 0) {
            sb.append(parent.lineSep + "This dialog may be kept open while editing.");
            new MyMessageDialog(parent, false, parent.programName + ": Duplicate Slides Found", sb.toString(), parent.getIconImage());
        } else {
            new MyMessageDialog(parent, false, parent.programName + ": No Duplicates", "No duplicate slides were found.", parent.getIconImage());
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        editPopupMenu = new javax.swing.JPopupMenu();
        infoMenuItem = new javax.swing.JMenuItem();
        cutMenuItem = new javax.swing.JMenuItem();
        copyMenuItem = new javax.swing.JMenuItem();
        pasteMenuItem = new javax.swing.JMenuItem();
        innerPanel = new javax.swing.JPanel();
        topPanel = new javax.swing.JPanel();
        showComboBox = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        SlideDurationTextField = new javax.swing.JTextField();
        columnsComboBox = new javax.swing.JComboBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        editorList = new javax.swing.JList();
        editToolBar = new javax.swing.JToolBar();
        newFileButton = new javax.swing.JButton();
        SaveButton = new javax.swing.JButton();
        FindDuplicatesButton = new javax.swing.JButton();
        UndoButton = new javax.swing.JButton();
        RedoButton = new javax.swing.JButton();
        cutButton = new javax.swing.JButton();
        copyButton = new javax.swing.JButton();
        pasteButton = new javax.swing.JButton();
        statusLabel = new javax.swing.JLabel();

        infoMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/dialog-question.png"))); // NOI18N
        infoMenuItem.setText("Info");
        infoMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                infoMenuItemMousePressed(evt);
            }
        });
        editPopupMenu.add(infoMenuItem);

        cutMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-cut.png"))); // NOI18N
        cutMenuItem.setMnemonic('t');
        cutMenuItem.setText("Cut");
        cutMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                cutMenuItemMousePressed(evt);
            }
        });
        editPopupMenu.add(cutMenuItem);

        copyMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-copy.png"))); // NOI18N
        copyMenuItem.setMnemonic('y');
        copyMenuItem.setText("Copy");
        copyMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                copyMenuItemMousePressed(evt);
            }
        });
        editPopupMenu.add(copyMenuItem);

        pasteMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-paste.png"))); // NOI18N
        pasteMenuItem.setMnemonic('p');
        pasteMenuItem.setText("Paste");
        pasteMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                pasteMenuItemMousePressed(evt);
            }
        });
        editPopupMenu.add(pasteMenuItem);

        setLayout(new java.awt.BorderLayout());

        innerPanel.setLayout(new java.awt.GridBagLayout());

        showComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        showComboBox.setToolTipText("Select a slide show or click the new show button on the toolbar");
        showComboBox.setFocusable(false);
        showComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showComboBoxActionPerformed(evt);
            }
        });
        topPanel.add(showComboBox);

        jLabel2.setText("Time:");
        topPanel.add(jLabel2);

        SlideDurationTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        SlideDurationTextField.setText("22");
        SlideDurationTextField.setToolTipText("Enter the expected slide duration");
        SlideDurationTextField.setFocusable(false);
        SlideDurationTextField.setMinimumSize(new java.awt.Dimension(40, 27));
        SlideDurationTextField.setPreferredSize(new java.awt.Dimension(40, 27));
        SlideDurationTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                SlideDurationTextFieldKeyTyped(evt);
            }
        });
        topPanel.add(SlideDurationTextField);

        columnsComboBox.setToolTipText("Choose display columns");
        columnsComboBox.setFocusable(false);
        columnsComboBox.setMinimumSize(new java.awt.Dimension(60, 19));
        columnsComboBox.setPreferredSize(new java.awt.Dimension(60, 19));
        columnsComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                columnsComboBoxActionPerformed(evt);
            }
        });
        topPanel.add(columnsComboBox);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        innerPanel.add(topPanel, gridBagConstraints);

        jScrollPane1.setFocusable(false);

        editorList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        editorList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        editorList.setLayoutOrientation(javax.swing.JList.HORIZONTAL_WRAP);
        editorList.setVisibleRowCount(200);
        editorList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                editorListValueChanged(evt);
            }
        });
        editorList.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                editorListKeyPressed(evt);
            }
        });
        jScrollPane1.setViewportView(editorList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        innerPanel.add(jScrollPane1, gridBagConstraints);

        add(innerPanel, java.awt.BorderLayout.CENTER);

        editToolBar.setRollover(true);
        editToolBar.setFocusable(false);

        newFileButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/document-new.png"))); // NOI18N
        newFileButton.setToolTipText("Create a new show");
        newFileButton.setFocusable(false);
        newFileButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        newFileButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        newFileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                newFileButtonMouseClicked(evt);
            }
        });
        editToolBar.add(newFileButton);

        SaveButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/document-save.png"))); // NOI18N
        SaveButton.setToolTipText("Save changed show");
        SaveButton.setFocusable(false);
        SaveButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        SaveButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        SaveButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SaveButtonMouseClicked(evt);
            }
        });
        editToolBar.add(SaveButton);

        FindDuplicatesButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/system-run.png"))); // NOI18N
        FindDuplicatesButton.setToolTipText("Search for duplicate slides");
        FindDuplicatesButton.setFocusable(false);
        FindDuplicatesButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        FindDuplicatesButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        FindDuplicatesButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                FindDuplicatesButtonMouseClicked(evt);
            }
        });
        editToolBar.add(FindDuplicatesButton);

        UndoButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-undo.png"))); // NOI18N
        UndoButton.setToolTipText("Undo last action (Ctrl+Z)");
        UndoButton.setEnabled(false);
        UndoButton.setFocusable(false);
        UndoButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        UndoButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        UndoButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                UndoButtonMouseClicked(evt);
            }
        });
        editToolBar.add(UndoButton);

        RedoButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-redo.png"))); // NOI18N
        RedoButton.setToolTipText("Redo last action (Ctrl+Shift+Z)");
        RedoButton.setEnabled(false);
        RedoButton.setFocusable(false);
        RedoButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        RedoButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        RedoButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                RedoButtonMouseClicked(evt);
            }
        });
        editToolBar.add(RedoButton);

        cutButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-cut.png"))); // NOI18N
        cutButton.setToolTipText("Cut (Ctrl+X)");
        cutButton.setFocusable(false);
        cutButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        cutButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        cutButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cutButtonMouseClicked(evt);
            }
        });
        editToolBar.add(cutButton);

        copyButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-copy.png"))); // NOI18N
        copyButton.setToolTipText("Copy (Ctrl+C)");
        copyButton.setFocusable(false);
        copyButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        copyButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        copyButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                copyButtonMouseClicked(evt);
            }
        });
        editToolBar.add(copyButton);

        pasteButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-paste.png"))); // NOI18N
        pasteButton.setToolTipText("Paste (Ctrl+V)");
        pasteButton.setFocusable(false);
        pasteButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        pasteButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        pasteButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                pasteButtonMouseClicked(evt);
            }
        });
        editToolBar.add(pasteButton);

        statusLabel.setToolTipText("<html>This shows the slide count and a show time estimate<br/>based on the slide duration entered below</html>");
        editToolBar.add(statusLabel);

        add(editToolBar, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents

    private void cutMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutMenuItemMousePressed
        // TODO add your handling code here:
        cutAction();
}//GEN-LAST:event_cutMenuItemMousePressed

    private void copyMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_copyMenuItemMousePressed
        // TODO add your handling code here:
        copyAction();
}//GEN-LAST:event_copyMenuItemMousePressed

    private void pasteMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_pasteMenuItemMousePressed
        // TODO add your handling code here:
        pasteAction();
}//GEN-LAST:event_pasteMenuItemMousePressed

    private void UndoButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_UndoButtonMouseClicked
        // TODO add your handling code here:
        undo();
    }//GEN-LAST:event_UndoButtonMouseClicked

    private void RedoButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_RedoButtonMouseClicked
        // TODO add your handling code here:
        redo();
    }//GEN-LAST:event_RedoButtonMouseClicked

    private void SaveButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SaveButtonMouseClicked
        // TODO add your handling code here:
        saveShowFile();
}//GEN-LAST:event_SaveButtonMouseClicked

    private void editorListKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_editorListKeyPressed
        // TODO add your handling code here:
        handleKeyPressed(evt);
    }//GEN-LAST:event_editorListKeyPressed

    private void cutButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutButtonMouseClicked
        // TODO add your handling code here:
        cutAction();
    }//GEN-LAST:event_cutButtonMouseClicked

    private void copyButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_copyButtonMouseClicked
        // TODO add your handling code here:
        copyAction();
    }//GEN-LAST:event_copyButtonMouseClicked

    private void pasteButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_pasteButtonMouseClicked
        // TODO add your handling code here:
        pasteAction();
    }//GEN-LAST:event_pasteButtonMouseClicked

    private void newFileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newFileButtonMouseClicked
        // TODO add your handling code here:
        createNewShow();
    }//GEN-LAST:event_newFileButtonMouseClicked

    private void FindDuplicatesButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_FindDuplicatesButtonMouseClicked
        // TODO add your handling code here:
        searchForDuplicates();
    }//GEN-LAST:event_FindDuplicatesButtonMouseClicked

    private void infoMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_infoMenuItemMousePressed
        // TODO add your handling code here:
        showImageInfo();
    }//GEN-LAST:event_infoMenuItemMousePressed

    private void SlideDurationTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_SlideDurationTextFieldKeyTyped
        // TODO add your handling code here:
        setDurationIfEnter(evt);
}//GEN-LAST:event_SlideDurationTextFieldKeyTyped

    private void showComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showComboBoxActionPerformed
        // TODO add your handling code here:
        comboActionPerformed(evt);
    }//GEN-LAST:event_showComboBoxActionPerformed

    private void columnsComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_columnsComboBoxActionPerformed
        // TODO add your handling code here:
        setEditColumns(evt);
    }//GEN-LAST:event_columnsComboBoxActionPerformed

    private void editorListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_editorListValueChanged
        // TODO add your handling code here:
        updateCutCopyPasteButtons();
    }//GEN-LAST:event_editorListValueChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton FindDuplicatesButton;
    private javax.swing.JButton RedoButton;
    private javax.swing.JButton SaveButton;
    private javax.swing.JTextField SlideDurationTextField;
    private javax.swing.JButton UndoButton;
    private javax.swing.JComboBox columnsComboBox;
    private javax.swing.JButton copyButton;
    protected javax.swing.JMenuItem copyMenuItem;
    private javax.swing.JButton cutButton;
    protected javax.swing.JMenuItem cutMenuItem;
    protected javax.swing.JPopupMenu editPopupMenu;
    private javax.swing.JToolBar editToolBar;
    private javax.swing.JList editorList;
    private javax.swing.JMenuItem infoMenuItem;
    private javax.swing.JPanel innerPanel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton newFileButton;
    private javax.swing.JButton pasteButton;
    protected javax.swing.JMenuItem pasteMenuItem;
    private javax.swing.JComboBox showComboBox;
    private javax.swing.JLabel statusLabel;
    private javax.swing.JPanel topPanel;
    // End of variables declaration//GEN-END:variables
}
