/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTMLDocument;
import magiclantern.CommonCode;
import magiclantern.MagicLantern;

public final class MyHelpPane
extends JPanel {
    MagicLantern parent;
    Stack<Integer> undoStack;
    Stack<Integer> redoStack;
    Document doc;
    String oldSearch = "";
    int oldPos = 0;
    Object oldHighlight = null;
    Highlighter highlighter;
    Highlighter.HighlightPainter highlightPainter;
    private JTextField findTextField;
    private JScrollPane helpScrollPane;
    private JTextPane helpTextPane;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JButton redoButton;
    private JButton undoButton;

    public MyHelpPane(MagicLantern magicLantern) {
        this.parent = magicLantern;
        this.initComponents();
        this.doc = this.helpTextPane.getDocument();
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.highlighter = this.helpTextPane.getHighlighter();
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(200, 255, 200));
        this.setupHelp();
        this.setButtons();
        this.setFocus();
    }

    void setFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyHelpPane.this.findTextField.requestFocus();
            }
        });
    }

    void setupHelp() {
        String string = "help/MagicLanternHelp.html";
        try {
            String string2;
            InputStream inputStream = this.parent.getClass().getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2 + "\n");
            }
            inputStream.close();
            String string3 = stringBuilder.toString();
            string3 = string3.replaceAll("\\(application path\\)", this.parent.appPath.replaceAll("\\\\", "&#92;"));
            string3 = string3.replaceAll("\\(data path\\)", this.parent.dataPath.replaceAll("\\\\", "&#92;"));
            string3 = string3.replaceAll("\\(configuration path\\)", this.parent.configPath.replaceAll("\\\\", "&#92;"));
            string3 = string3.replaceAll("\\(browse path\\)", this.parent.browseContentPath.replaceAll("\\\\", "&#92;"));
            string3 = string3.replaceAll("\\(user home directory\\)", this.parent.userDir.replaceAll("\\\\", "&#92;"));
            string3 = string3.replaceAll("\\(version\\)", this.parent.appVersion);
            this.helpTextPane.setText(string3);
            this.helpTextPane.select(0, 0);
            URL uRL = this.parent.getClass().getResource(string).toURI().toURL();
            ((HTMLDocument)this.helpTextPane.getDocument()).setBase(uRL);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    void manageHyperlinks(HyperlinkEvent hyperlinkEvent) {
        URL uRL = hyperlinkEvent.getURL();
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getURL().toString();
            if (string.matches("http://.*")) {
                try {
                    Desktop.getDesktop().browse(URI.create(string));
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            } else if (string.matches(".*#.*")) {
                try {
                    this.pushUndo();
                    this.helpTextPane.scrollToReference(uRL.getRef());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
    }

    void undo() {
        if (this.undoStack.size() > 0) {
            this.removeOldHighlight();
            this.pushRedo();
            this.helpScrollPane.getVerticalScrollBar().setValue(this.undoStack.pop());
            this.setButtons();
        } else {
            CommonCode.beep();
        }
    }

    void redo() {
        if (this.redoStack.size() > 0) {
            this.removeOldHighlight();
            this.pushUndo();
            this.helpScrollPane.getVerticalScrollBar().setValue(this.redoStack.pop());
            this.setButtons();
        } else {
            CommonCode.beep();
        }
    }

    void pushUndo() {
        this.undoStack.push(this.helpScrollPane.getVerticalScrollBar().getValue());
        this.setButtons();
    }

    void pushRedo() {
        this.redoStack.push(this.helpScrollPane.getVerticalScrollBar().getValue());
        this.setButtons();
    }

    void setButtons() {
        this.undoButton.setEnabled(this.undoStack.size() > 0);
        this.redoButton.setEnabled(this.redoStack.size() > 0);
    }

    void removeOldHighlight() {
        if (this.oldHighlight != null) {
            this.highlighter.removeHighlight(this.oldHighlight);
            this.oldHighlight = null;
        }
    }

    void manageHelpTextField(KeyEvent keyEvent) {
        String string = KeyEvent.getKeyText(keyEvent.getKeyCode());
        if (string.matches("F\\d")) {
            this.parent.handleKeyPressed(keyEvent);
        } else {
            try {
                this.removeOldHighlight();
                this.doc = this.helpTextPane.getDocument();
                int n2 = this.doc.getLength();
                String string2 = this.doc.getText(0, n2).toLowerCase();
                String string3 = this.findTextField.getText().toLowerCase();
                if (!string3.equals(this.oldSearch)) {
                    this.oldPos = 0;
                }
                this.oldSearch = string3;
                int n3 = string2.indexOf(string3, this.oldPos);
                if (n3 == -1) {
                    this.oldPos = 0;
                    n3 = string2.indexOf(string3, this.oldPos);
                }
                if (n3 >= 0) {
                    this.pushUndo();
                    int n4 = string3.length();
                    Rectangle rectangle = this.helpTextPane.modelToView(n3);
                    int n5 = rectangle.y - this.helpScrollPane.getHeight() / 2;
                    n5 = n5 < 0 ? 0 : n5;
                    this.helpScrollPane.getVerticalScrollBar().setValue(n5);
                    this.oldHighlight = this.highlighter.addHighlight(n3, n3 + n4, this.highlightPainter);
                    this.oldPos = n3 + 1;
                } else {
                    CommonCode.beep();
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.undoButton = new JButton();
        this.redoButton = new JButton();
        this.jLabel1 = new JLabel();
        this.findTextField = new JTextField();
        this.helpScrollPane = new JScrollPane();
        this.helpTextPane = new JTextPane();
        this.setLayout(new GridBagLayout());
        this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/go-previous.png")));
        this.undoButton.setToolTipText("Go back");
        this.undoButton.setFocusable(false);
        this.undoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MyHelpPane.this.undoButtonMouseClicked(mouseEvent);
            }
        });
        this.jPanel1.add(this.undoButton);
        this.redoButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/go-next.png")));
        this.redoButton.setToolTipText("Go forward");
        this.redoButton.setFocusable(false);
        this.redoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MyHelpPane.this.redoButtonMouseClicked(mouseEvent);
            }
        });
        this.jPanel1.add(this.redoButton);
        this.jLabel1.setText("Search:");
        this.jPanel1.add(this.jLabel1);
        this.findTextField.setToolTipText("<html>Quick search: type a search string,<br/>press Enter to find the next case</html>");
        this.findTextField.setFocusCycleRoot(true);
        this.findTextField.setMinimumSize(new Dimension(150, 27));
        this.findTextField.setPreferredSize(new Dimension(150, 27));
        this.findTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MyHelpPane.this.findTextFieldKeyReleased(keyEvent);
            }
        });
        this.jPanel1.add(this.findTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.helpScrollPane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.helpTextPane.setBackground(Color.white);
        this.helpTextPane.setContentType("text/html");
        this.helpTextPane.setEditable(false);
        this.helpTextPane.setFocusable(false);
        this.helpTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                MyHelpPane.this.helpTextPaneHyperlinkUpdate(hyperlinkEvent);
            }
        });
        this.helpScrollPane.setViewportView(this.helpTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.helpScrollPane, gridBagConstraints);
    }

    private void helpTextPaneHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        this.manageHyperlinks(hyperlinkEvent);
    }

    private void undoButtonMouseClicked(MouseEvent mouseEvent) {
        this.undo();
    }

    private void redoButtonMouseClicked(MouseEvent mouseEvent) {
        this.redo();
    }

    private void findTextFieldKeyReleased(KeyEvent keyEvent) {
        this.manageHelpTextField(keyEvent);
    }
}

