/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import magiclantern.MagicLantern;
import magiclantern.MutableDouble;
import magiclantern.StringComparatorNoCase;

public final class InitManager {
    MagicLantern parent;
    String fileSep;
    String lineSep;
    String appName;
    String userDir;
    String userPath;
    String initPath;
    String fieldPrefix = "sv_";

    public InitManager(MagicLantern magicLantern) {
        this.parent = magicLantern;
        this.lineSep = System.getProperty("line.separator");
        this.fileSep = System.getProperty("file.separator");
        this.appName = this.parent.getClass().getSimpleName();
        this.userDir = System.getProperty("user.home");
        this.userPath = this.userDir + this.fileSep + "." + this.appName;
        this.initPath = this.userPath + this.fileSep + this.appName + ".ini";
        this.testMakeDirs(this.userPath);
    }

    String[] parsePair(String string) {
        String[] stringArray = null;
        int n2 = string.indexOf("=");
        if (n2 > 0) {
            stringArray = new String[]{string.substring(0, n2), string.substring(n2 + 1, string.length())};
            for (int i2 = 0; i2 < 2 && i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].replaceFirst("^\\s*(.*?)\\s*$", "$1");
            }
        }
        return stringArray;
    }

    public void setConfig(String string) {
        if (string != null) {
            String[] stringArray = string.split(this.lineSep);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = this.strip(stringArray[i2]);
                String[] stringArray2 = this.parsePair(string2);
                this.readWriteField(stringArray2[0], stringArray2[1]);
            }
        }
    }

    public void readConfig() {
        String string = this.readTextFile(this.initPath, this.lineSep);
        this.setConfig(string);
    }

    Rectangle parseRectangle(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        Rectangle rectangle = null;
        try {
            String string2 = string.replaceFirst("^.*x=([-|\\d]+).*y=([-|\\d]+).*width=([-|\\d]+).*height=([-|\\d]+).*$", "$1,$2,$3,$4");
            String[] stringArray = string2.split(",");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                vector.add(Integer.parseInt(stringArray[i2]));
            }
            Iterator iterator = vector.iterator();
            rectangle = new Rectangle((Integer)iterator.next(), (Integer)iterator.next(), (Integer)iterator.next(), (Integer)iterator.next());
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ": error: " + exception);
        }
        return rectangle;
    }

    String readWriteField(String string, String string2) {
        try {
            boolean bl;
            Class<?> clazz = this.parent.getClass();
            Field field = clazz.getDeclaredField(string);
            Object object = field.get(this.parent);
            String string3 = field.getType().toString();
            string3 = string3.replaceFirst(".*\\.(.*)", "$1");
            boolean bl2 = bl = string2 != null;
            if (bl) {
                string2 = this.strip(string2);
            }
            if (string3.equals("int")) {
                if (bl) {
                    field.setInt(this.parent, Integer.parseInt(string2));
                } else {
                    string2 = "" + field.getInt(this.parent);
                }
            } else if (string3.equals("double")) {
                if (bl) {
                    field.setDouble(this.parent, Double.parseDouble(string2));
                } else {
                    string2 = "" + field.getDouble(this.parent);
                }
            } else if (string3.equals("MutableDouble")) {
                if (bl) {
                    ((MutableDouble)object).v = Double.parseDouble(string2);
                } else {
                    string2 = "" + ((MutableDouble)object).v;
                }
            } else if (string3.equals("boolean")) {
                if (bl) {
                    field.setBoolean(this.parent, string2.equals("true"));
                } else {
                    string2 = "" + field.getBoolean(this.parent);
                }
            } else if (string3.equals("String")) {
                if (bl) {
                    field.set(this.parent, string2);
                } else {
                    string2 = (String)field.get(this.parent);
                }
            } else if (string3.equals("Rectangle")) {
                if (bl) {
                    Rectangle rectangle = this.parseRectangle(string2);
                    if (rectangle != null) {
                        field.set(this.parent, rectangle);
                    }
                } else {
                    string2 = field.get(this.parent).toString();
                }
            } else if (string3.equals("JRadioButton")) {
                JRadioButton jRadioButton = (JRadioButton)object;
                if (bl) {
                    jRadioButton.setSelected(string2.equals("true"));
                } else {
                    string2 = "" + jRadioButton.isSelected();
                }
            } else if (string3.equals("JCheckBox")) {
                JCheckBox jCheckBox = (JCheckBox)object;
                if (bl) {
                    jCheckBox.setSelected(string2.equals("true"));
                } else {
                    string2 = "" + jCheckBox.isSelected();
                }
            } else if (string3.equals("JTextField")) {
                JTextField jTextField = (JTextField)object;
                if (bl) {
                    jTextField.setText(string2);
                } else {
                    string2 = jTextField.getText();
                }
            } else if (string3.equals("JComboBox")) {
                JComboBox jComboBox = (JComboBox)object;
                if (bl) {
                    jComboBox.setSelectedIndex(Integer.parseInt(string2));
                } else {
                    string2 = "" + jComboBox.getSelectedIndex();
                }
            } else if (string3.equals("JSpinner")) {
                JSpinner jSpinner = (JSpinner)object;
                if (bl) {
                    jSpinner.setValue(Integer.parseInt(string2));
                } else {
                    string2 = "" + jSpinner.getValue();
                }
            } else if (string3.equals("JTabbedPane")) {
                JTabbedPane jTabbedPane = (JTabbedPane)object;
                if (bl) {
                    jTabbedPane.setSelectedIndex(Integer.parseInt(string2));
                } else {
                    string2 = "" + jTabbedPane.getSelectedIndex();
                }
            } else if (string3.equals("JFrame")) {
                JFrame jFrame = (JFrame)object;
                if (bl) {
                    Rectangle rectangle = this.parseRectangle(string2);
                    if (rectangle != null) {
                        jFrame.setBounds(rectangle);
                    }
                } else {
                    string2 = "" + jFrame.getBounds();
                }
            } else {
                System.out.println(this.getClass().getName() + ": cannot decode value for " + string3 + " (" + string + ")");
            }
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ":readWriteField: \"" + string + "\": " + exception);
        }
        return string2;
    }

    public void writeConfig() {
        String string = this.getConfig();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.initPath));
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public String getConfig() {
        Vector<String> vector = new Vector<String>();
        Hashtable<String, Field> hashtable = this.getFieldNames();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Field field = hashtable.get(enumeration.nextElement());
            String string = field.getName();
            String string2 = this.readWriteField(string, null);
            if (string2 == null) continue;
            vector.add(string + " = " + string2);
        }
        Collections.sort(vector, new StringComparatorNoCase());
        String[] stringArray = vector.toArray(new String[0]);
        return this.join(stringArray, this.lineSep) + this.lineSep;
    }

    Hashtable<String, Field> getFieldNames() {
        Hashtable<String, Field> hashtable = new Hashtable<String, Field>();
        Field[] fieldArray = this.parent.getClass().getDeclaredFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Field field = fieldArray[i2];
            String string = field.getName();
            if (!string.matches("^" + this.fieldPrefix + ".*")) continue;
            hashtable.put(string, field);
        }
        return hashtable;
    }

    String readTextFile(String string, String string2) {
        String string3 = null;
        File file = new File(string);
        if (file.exists()) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4 + string2);
                }
                bufferedReader.close();
                string3 = stringBuffer.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string3;
    }

    boolean testMakeDirs(String string) {
        File file = new File(string);
        if (file.exists()) {
            return false;
        }
        file.mkdirs();
        return true;
    }

    String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i2]);
        }
        return stringBuffer.toString();
    }

    String strip(String string) {
        return string.replaceFirst("^\\s*(.*)\\s*$", "$1");
    }
}

