/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import magiclantern.CommonCode;
import magiclantern.EditBase;
import magiclantern.EditCellDatum;
import magiclantern.EditCellRenderer;
import magiclantern.MagicLantern;
import magiclantern.MyDefaultListModel;
import magiclantern.MyMessageDialog;
import magiclantern.StringComparatorNoCase;

public class EditBrowsePanelCoreRoutines
extends JPanel
implements ClipboardOwner,
DragGestureListener,
DragSourceListener {
    MyDefaultListModel editListModel;
    JList editList = null;
    JButton saveButton;
    JPopupMenu editPopupMenu = null;
    MagicLantern parent;
    EditBase base;
    DragSource dragSource;
    Object[] draggedItems;
    Stack<Object[]> undoStack;
    Stack<Object[]> redoStack;
    boolean contentChanged = false;
    String activeFile = null;

    public EditBrowsePanelCoreRoutines(MagicLantern magicLantern, EditBase editBase) {
        this.parent = magicLantern;
        this.base = editBase;
        this.resetUndoRedo();
    }

    void setupTooltips(boolean bl) {
        String string = null;
        String string2 = null;
        if (bl) {
            string = "<html>This panel is for creating and editing<br/>";
            string = string + "your slide show. To create a new show,<br/>";
            string = string + "press the \"Create\" button at the upper right.</html>";
            string2 = "<html>This panel is a scratch-pad area<br/>";
            string2 = string2 + "for temporary storage of images<br/>";
            string2 = string2 + "you might want to add to your slide show.</html>";
        }
        final String string3 = string;
        final String string4 = string2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditBrowsePanelCoreRoutines.this.base.editPanel.getList().setToolTipText(string3);
                EditBrowsePanelCoreRoutines.this.base.browsePanel.getList().setToolTipText(string4);
            }
        });
    }

    public void openFileMessage() {
        CommonCode.beep();
        JOptionPane.showMessageDialog(this, "Cannot edit -- please open a new or existing show", this.parent.programName + ": No open show", 2);
    }

    void setEditRenderer() {
        Color color;
        Color color2;
        if (this.parent.sv_editWhiteBackground) {
            color2 = Color.black;
            color = Color.white;
        } else {
            color = Color.black;
            color2 = Color.white;
        }
        this.editList.setCellRenderer(new EditCellRenderer(this.parent, color, color2));
        this.editList.setBackground(color);
    }

    void initialize(JList jList, JPopupMenu jPopupMenu, JButton jButton) {
        this.editList = jList;
        this.saveButton = jButton;
        this.editPopupMenu = jPopupMenu;
        this.editListModel = new MyDefaultListModel();
        this.editList.setModel(this.editListModel);
        this.setEditRenderer();
        this.editList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditBrowsePanelCoreRoutines.this.handleMouseEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                EditBrowsePanelCoreRoutines.this.handleMouseEvent(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanelCoreRoutines.this.handleMouseClick(mouseEvent);
            }
        });
        this.editList.setDragEnabled(true);
        this.editList.setDropMode(DropMode.INSERT);
        this.editList.setTransferHandler(this.createTransferHandler(this));
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.editList, 3, this);
    }

    TransferHandler createTransferHandler(final EditBrowsePanelCoreRoutines editBrowsePanelCoreRoutines) {
        return new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                boolean bl = false;
                try {
                    JList.DropLocation dropLocation;
                    if ((transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor) || transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) && (dropLocation = (JList.DropLocation)transferSupport.getDropLocation()) != null && dropLocation.getIndex() != -1) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                return bl;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                if (EditBrowsePanelCoreRoutines.this.activeFile == null) {
                    EditBrowsePanelCoreRoutines.this.openFileMessage();
                    return false;
                }
                if (!this.canImport(transferSupport)) {
                    return false;
                }
                Transferable transferable = transferSupport.getTransferable();
                String string = EditBrowsePanelCoreRoutines.this.getTransferableContents(transferable);
                if (string == null) {
                    return false;
                }
                EditBrowsePanelCoreRoutines.this.pushUndo();
                String[] stringArray = string.split("\n");
                for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                    EditCellDatum editCellDatum;
                    File file;
                    String string2 = stringArray[i2];
                    string2 = CommonCode.strip(string2);
                    String[] stringArray2 = string2.split(",");
                    String string3 = stringArray2[0];
                    String string4 = stringArray2.length > 1 ? stringArray2[1] : null;
                    string3 = string3.replaceFirst("file://", "");
                    if (string4 != null) {
                        string4 = string4.replaceFirst("file://", "");
                    }
                    if (!(file = new File(string3)).exists() || !(editCellDatum = new EditCellDatum(EditBrowsePanelCoreRoutines.this.parent, editBrowsePanelCoreRoutines, string3, string4)).valid()) continue;
                    JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
                    int n2 = dropLocation.getIndex();
                    if (dropLocation.isInsert()) {
                        EditBrowsePanelCoreRoutines.this.editListModel.add(n2, editCellDatum);
                    } else {
                        EditBrowsePanelCoreRoutines.this.editListModel.set(n2, editCellDatum);
                    }
                    EditBrowsePanelCoreRoutines.this.setContentChanged(true);
                    Rectangle rectangle = EditBrowsePanelCoreRoutines.this.editList.getCellBounds(n2, n2);
                    EditBrowsePanelCoreRoutines.this.scrollRectToVisible(rectangle);
                }
                EditBrowsePanelCoreRoutines.this.reformatDisplay();
                EditBrowsePanelCoreRoutines.this.parent.setStatus("OK", false, 1);
                return true;
            }
        };
    }

    void resetUndoRedo() {
        this.undoStack = new Stack();
        this.redoStack = new Stack();
    }

    void populateControl(String string, String[] stringArray) {
        if (stringArray != null) {
            this.editListModel.removeAllElements();
            Arrays.sort(stringArray, new StringComparatorNoCase());
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = CommonCode.strip(stringArray[i2]);
                this.addListItem(string + this.parent.fileSep + string2);
            }
            this.reformatDisplay();
        }
    }

    void showImageInfo() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                EditBrowsePanelCoreRoutines.this.showImageInfoThread();
            }
        };
        thread.start();
    }

    void showImageInfoThread() {
        String string = "";
        int n2 = this.editList.getSelectedIndex();
        EditCellDatum editCellDatum = (EditCellDatum)this.editList.getSelectedValue();
        if (editCellDatum != null) {
            try {
                String string2 = editCellDatum.getPath();
                String string3 = editCellDatum.getSoundPath();
                File file = new File(string2);
                BufferedImage bufferedImage = this.parent.readImage(file);
                int n3 = bufferedImage.getWidth(this);
                int n4 = bufferedImage.getHeight(this);
                int n5 = bufferedImage.getType();
                int n6 = n5 == 6 || n5 == 7 ? 4 : 3;
                long l2 = n3 * n4 * n6;
                Date date = new Date(file.lastModified());
                String string4 = file.getName();
                String string5 = file.getParent();
                long l3 = file.length();
                double d2 = (double)n3 / (double)n4 + 0.005;
                d2 = d2 < 1.0 ? 1.0 / d2 : d2;
                string = "Index                 : " + (n2 + 1) + "\n";
                string = string + "Name                  : " + string4 + "\n";
                string = string + "Location              : " + string5 + "\n";
                string = string + "Last Modified         : " + date + "\n";
                string = string + "Storage Size          : " + CommonCode.createDecimalFormat(l3) + " bytes\n";
                string = string + "Uncompressed Size     : " + CommonCode.createDecimalFormat(l2) + " bytes\n";
                string = string + "Width                 : " + CommonCode.createDecimalFormat(n3) + " pixels\n";
                string = string + "Height                : " + CommonCode.createDecimalFormat(n4) + " pixels\n";
                string = string + "Aspect Ratio          : " + CommonCode.createDecimalFormat(d2) + "\n";
                if (string3 != null) {
                    string = string + "Associated Sound File : " + string3 + "\n";
                }
                String string6 = this.parent.programName + ": File Info";
                new MyMessageDialog(this.parent, true, string6, string, this.parent.getIconImage());
            }
            catch (Exception exception) {
                System.out.println(exception);
                string = "Error: Cannot read this image.";
            }
        }
    }

    public DefaultListModel getListModel() {
        return this.editListModel;
    }

    public JList getList() {
        return this.editList;
    }

    void MoveFileListToControl(String string) {
        File file = new File(string);
        String[] stringArray = file.list();
        this.populateControl(string, stringArray);
    }

    void reformatDisplay() {
        int n2 = this.editListModel.size();
        n2 = n2 > 0 ? n2 - 1 : n2;
        int n3 = n2 / this.parent.editColumns + 1;
        this.editList.setVisibleRowCount(n3);
    }

    void pushUndo() {
        this.undoStack.push(this.editListModel.toArray());
        this.updateButtons();
    }

    void pushRedo() {
        this.redoStack.push(this.editListModel.toArray());
        this.updateButtons();
    }

    void undo() {
        if (this.undoStack.size() > 0) {
            this.pushRedo();
            Object[] objectArray = this.undoStack.pop();
            this.replaceModelContent(objectArray);
            this.updateButtons();
        } else {
            CommonCode.beep();
        }
    }

    void redo() {
        if (this.redoStack.size() > 0) {
            this.pushUndo();
            Object[] objectArray = this.redoStack.pop();
            this.replaceModelContent(objectArray);
            this.updateButtons();
        } else {
            CommonCode.beep();
        }
    }

    void updateButtons() {
    }

    void updateShowDisplay() {
    }

    void setContentChanged(boolean bl) {
        this.contentChanged = bl;
        if (this.saveButton != null) {
            this.saveButton.setEnabled(this.contentChanged);
        }
        this.updateShowDisplay();
        this.setupTooltips(false);
    }

    void replaceModelContent(Object[] objectArray) {
        this.editListModel.removeAllElements();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.editListModel.addElement(objectArray[i2]);
        }
        this.reformatDisplay();
        this.setContentChanged(true);
    }

    void addListItem(String string) {
        EditCellDatum editCellDatum = new EditCellDatum(this.parent, this, string);
        if (editCellDatum.valid()) {
            this.editListModel.addElement(editCellDatum);
            this.setContentChanged(true);
        }
    }

    void updateCutCopyPasteButtons(JMenuItem jMenuItem, JMenuItem jMenuItem2, JMenuItem jMenuItem3, JButton jButton, JButton jButton2, JButton jButton3) {
        boolean bl = this.cutCopyActionValid();
        boolean bl2 = this.pasteActionValid();
        jMenuItem.setEnabled(bl);
        jMenuItem2.setEnabled(bl);
        jButton.setEnabled(bl);
        jButton2.setEnabled(bl);
        jMenuItem3.setEnabled(bl2);
        jButton3.setEnabled(bl2);
    }

    boolean cutCopyActionValid() {
        Object[] objectArray = this.editList.getSelectedValues();
        return objectArray != null && objectArray.length > 0;
    }

    boolean pasteActionValid() {
        return this.getClipboardContents() != null;
    }

    void cutAction() {
        if (this.activeFile == null) {
            this.openFileMessage();
            return;
        }
        if (this.cutCopyActionValid()) {
            Object[] objectArray = this.editList.getSelectedValues();
            this.pushUndo();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append(((EditCellDatum)objectArray[i2]).getPath() + "\n");
                this.editListModel.removeElement(objectArray[i2]);
                this.setContentChanged(true);
            }
            this.setClipboardContents(stringBuffer.toString());
            this.reformatDisplay();
        } else {
            CommonCode.beep();
        }
    }

    String getCopyContent() {
        String string = null;
        Object[] objectArray = this.editList.getSelectedValues();
        if (objectArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append(((EditCellDatum)objectArray[i2]).getPath() + "\n");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    void copyAction() {
        if (this.activeFile == null) {
            this.openFileMessage();
            return;
        }
        String string = this.getCopyContent();
        if (string != null) {
            this.setClipboardContents(string.toString());
        } else {
            CommonCode.beep();
        }
    }

    void pasteAction() {
        if (this.activeFile == null) {
            this.openFileMessage();
            return;
        }
        String string = this.getClipboardContents();
        this.putPasteContent(string);
    }

    void putPasteContent(String string) {
        this.pushUndo();
        String[] stringArray = string.split("\n");
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            String string2 = stringArray[i2];
            File file = new File(string2);
            if (!file.exists()) continue;
            EditCellDatum editCellDatum = new EditCellDatum(this.parent, this, string2, "");
            int n2 = this.editList.getSelectedIndex();
            if (n2 == -1) {
                this.editListModel.addElement(editCellDatum);
            } else {
                this.editListModel.add(n2, editCellDatum);
            }
            this.setContentChanged(true);
        }
        this.reformatDisplay();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    void setClipboardContents(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    String getTransferableContents(Transferable transferable) {
        String string = null;
        try {
            if (transferable != null) {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    StringBuffer stringBuffer = new StringBuffer();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(((File)iterator.next()).getPath() + "\n");
                    }
                    string = stringBuffer.toString();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("getTransferableContents: " + exception);
        }
        return string;
    }

    String getClipboardContents() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        return this.getTransferableContents(transferable);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        try {
            this.draggedItems = this.editList.getSelectedValues();
            String string = this.getCopyContent();
            if (string != null) {
                StringSelection stringSelection = new StringSelection(string);
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, stringSelection, this);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            int n2 = dragSourceDropEvent.getDropAction();
            if (n2 == 2) {
                this.pushUndo();
                for (int i2 = 0; i2 < this.draggedItems.length; ++i2) {
                    this.editListModel.removeElement(this.draggedItems[i2]);
                }
                this.setContentChanged(true);
            }
            this.reformatDisplay();
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n2 = dragSourceDragEvent.getUserAction();
        if ((n2 & 2) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
        } else if ((n2 & 1) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    void handleMouseEvent(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.isPopupTrigger()) {
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                int[] nArray = this.editList.getSelectedIndices();
                if (nArray == null || nArray.length <= 1) {
                    int n4 = this.editList.locationToIndex(mouseEvent.getPoint());
                    this.editList.setSelectedIndex(n4);
                }
                this.editPopupMenu.show(mouseEvent.getComponent(), n2, n3);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    void handleMouseClick(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.setCursor(new Cursor(3));
            EditCellDatum editCellDatum = (EditCellDatum)this.editList.getSelectedValue();
            this.parent.editPreview(editCellDatum.getShowDataItem());
            this.setCursor(new Cursor(0));
        }
    }
}

