/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import magiclantern.CommonCode;
import magiclantern.EditBase;
import magiclantern.EditBrowsePanelCoreRoutines;
import magiclantern.EditCellDatum;
import magiclantern.MagicLantern;
import magiclantern.MyFileNameFilter;

public final class EditBrowsePanel
extends EditBrowsePanelCoreRoutines {
    private JButton RedoButton;
    private JButton UndoButton;
    private JPanel centerPanel;
    private JButton clearButton;
    private JLabel contentLabel;
    private JButton copyButton;
    protected JMenuItem copyMenuItem;
    private JButton cutButton;
    protected JMenuItem cutMenuItem;
    protected JPopupMenu editPopupMenu;
    private JList editSelectorList;
    private JButton fileButton;
    private JMenuItem infoMenuItem;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JButton pasteButton;
    protected JMenuItem pasteMenuItem;

    public EditBrowsePanel(MagicLantern magicLantern, EditBase editBase) {
        super(magicLantern, editBase);
        this.initComponents();
        this.initialize(this.editSelectorList, this.editPopupMenu, null);
        this.readBrowseFile();
        this.setupTooltips(true);
        this.updateCutCopyPasteButtons();
        this.editList.revalidate();
        this.activeFile = "";
    }

    void readImageDirectory() {
        JFileChooser jFileChooser = new JFileChooser();
        boolean bl = CommonCode.changeLookAndFeel(jFileChooser);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(this.parent.programName + ": Choose Graphic Directory");
        jFileChooser.setApproveButtonText("Read");
        jFileChooser.setCurrentDirectory(new File(this.parent.sv_editSearchDirectory));
        int n2 = jFileChooser.showOpenDialog(this.parent);
        if (bl) {
            CommonCode.restoreSystemLookAndFeel();
        }
        if (n2 == 0) {
            try {
                this.parent.sv_editSearchDirectory = jFileChooser.getSelectedFile().getCanonicalPath();
                this.readGraphicDirectory(this.parent.sv_editSearchDirectory);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    void clearBrowseList() {
        this.pushUndo();
        this.editListModel.removeAllElements();
        this.contentLabel.setText("");
        this.reformatDisplay();
    }

    void readGraphicDirectory(String string) {
        if (this.editListModel.size() > 0) {
            this.pushUndo();
        }
        File file = new File(string);
        MyFileNameFilter myFileNameFilter = new MyFileNameFilter(this.parent.defaultFilenameFilter);
        String[] stringArray = file.list(myFileNameFilter);
        this.populateControl(string, stringArray);
        this.updateShowDisplay();
    }

    @Override
    void updateShowDisplay() {
        this.contentLabel.setText(this.editListModel.size() + " slides");
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getModifiers();
        if ((n3 & 2) != 0) {
            if (n2 == 88) {
                this.cutAction();
            } else if (n2 == 67) {
                this.copyAction();
            } else if (n2 == 86) {
                this.pasteAction();
            } else if (n2 == 90) {
                this.undo();
            } else if ((n3 & 1) != 0 && n2 == 90) {
                this.redo();
            }
        }
    }

    @Override
    void updateButtons() {
        this.UndoButton.setEnabled(this.undoStack.size() > 0);
        this.RedoButton.setEnabled(this.redoStack.size() > 0);
    }

    void updateCutCopyPasteButtons() {
        super.updateCutCopyPasteButtons(this.cutMenuItem, this.copyMenuItem, this.pasteMenuItem, this.cutButton, this.copyButton, this.pasteButton);
    }

    void saveBrowseFile() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.editListModel.size(); ++i2) {
            EditCellDatum editCellDatum = (EditCellDatum)this.editListModel.get(i2);
            stringBuffer.append(editCellDatum.getPath() + this.parent.lineSep);
        }
        CommonCode.saveTextFile(this.parent, stringBuffer.toString(), this.parent.browseContentPath, false);
    }

    void readBrowseFile() {
        String string = CommonCode.readTextFile(this.parent.browseContentPath, this.parent.lineSep);
        if (string != null) {
            String[] stringArray = string.split("\n");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = CommonCode.strip(stringArray[i2]);
                this.addListItem(string2);
            }
            this.reformatDisplay();
        }
    }

    private void initComponents() {
        this.editPopupMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.centerPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.editSelectorList = new JList();
        this.jToolBar1 = new JToolBar();
        this.fileButton = new JButton();
        this.clearButton = new JButton();
        this.UndoButton = new JButton();
        this.RedoButton = new JButton();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.contentLabel = new JLabel();
        this.infoMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/dialog-question.png")));
        this.infoMenuItem.setText("Info");
        this.infoMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditBrowsePanel.this.infoMenuItemMousePressed(mouseEvent);
            }
        });
        this.infoMenuItem.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
                EditBrowsePanel.this.infoMenuItemMenuKeyTyped(menuKeyEvent);
            }
        });
        this.editPopupMenu.add(this.infoMenuItem);
        this.cutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-cut.png")));
        this.cutMenuItem.setMnemonic('t');
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditBrowsePanel.this.cutMenuItemMousePressed(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.cutMenuItem);
        this.copyMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-copy.png")));
        this.copyMenuItem.setMnemonic('y');
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditBrowsePanel.this.copyMenuItemMousePressed(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-paste.png")));
        this.pasteMenuItem.setMnemonic('p');
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditBrowsePanel.this.pasteMenuItemMousePressed(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.pasteMenuItem);
        this.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setFocusable(false);
        this.editSelectorList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n2) {
                return this.strings[n2];
            }
        });
        this.editSelectorList.setDragEnabled(true);
        this.editSelectorList.setLayoutOrientation(2);
        this.editSelectorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditBrowsePanel.this.editSelectorListValueChanged(listSelectionEvent);
            }
        });
        this.editSelectorList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                EditBrowsePanel.this.editSelectorListKeyPressed(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.editSelectorList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.centerPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.add((Component)this.centerPanel, "Center");
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/document-open.png")));
        this.fileButton.setToolTipText("Open a directory of images");
        this.fileButton.setFocusable(false);
        this.fileButton.setHorizontalTextPosition(0);
        this.fileButton.setVerticalTextPosition(3);
        this.fileButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanel.this.fileButtonMouseClicked(mouseEvent);
            }
        });
        this.jToolBar1.add(this.fileButton);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-clear.png")));
        this.clearButton.setToolTipText("Clear this list");
        this.clearButton.setFocusable(false);
        this.clearButton.setHorizontalTextPosition(0);
        this.clearButton.setVerticalTextPosition(3);
        this.clearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanel.this.clearButtonMouseClicked(mouseEvent);
            }
        });
        this.jToolBar1.add(this.clearButton);
        this.UndoButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-undo.png")));
        this.UndoButton.setToolTipText("Undo last action (Ctrl+Z)");
        this.UndoButton.setEnabled(false);
        this.UndoButton.setFocusable(false);
        this.UndoButton.setHorizontalTextPosition(0);
        this.UndoButton.setVerticalTextPosition(3);
        this.UndoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanel.this.UndoButtonMouseClicked(mouseEvent);
            }
        });
        this.jToolBar1.add(this.UndoButton);
        this.RedoButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-redo.png")));
        this.RedoButton.setToolTipText("Redo last action (Ctrl+Shift+Z)");
        this.RedoButton.setEnabled(false);
        this.RedoButton.setFocusable(false);
        this.RedoButton.setHorizontalTextPosition(0);
        this.RedoButton.setVerticalTextPosition(3);
        this.RedoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanel.this.RedoButtonMouseClicked(mouseEvent);
            }
        });
        this.jToolBar1.add(this.RedoButton);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-cut.png")));
        this.cutButton.setToolTipText("Cut (Ctrl+X)");
        this.cutButton.setFocusable(false);
        this.cutButton.setHorizontalTextPosition(0);
        this.cutButton.setVerticalTextPosition(3);
        this.cutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanel.this.cutButtonMouseClicked(mouseEvent);
            }
        });
        this.jToolBar1.add(this.cutButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-copy.png")));
        this.copyButton.setToolTipText("Copy (Ctrl+C)");
        this.copyButton.setFocusable(false);
        this.copyButton.setHorizontalTextPosition(0);
        this.copyButton.setVerticalTextPosition(3);
        this.copyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanel.this.copyButtonMouseClicked(mouseEvent);
            }
        });
        this.jToolBar1.add(this.copyButton);
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-paste.png")));
        this.pasteButton.setToolTipText("Paste (Ctrl+V)");
        this.pasteButton.setFocusable(false);
        this.pasteButton.setHorizontalTextPosition(0);
        this.pasteButton.setVerticalTextPosition(3);
        this.pasteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBrowsePanel.this.pasteButtonMouseClicked(mouseEvent);
            }
        });
        this.jToolBar1.add(this.pasteButton);
        this.contentLabel.setToolTipText("Slide count");
        this.jToolBar1.add(this.contentLabel);
        this.add((Component)this.jToolBar1, "North");
    }

    private void fileButtonMouseClicked(MouseEvent mouseEvent) {
        this.readImageDirectory();
    }

    private void cutMenuItemMousePressed(MouseEvent mouseEvent) {
        this.cutAction();
    }

    private void copyMenuItemMousePressed(MouseEvent mouseEvent) {
        this.copyAction();
    }

    private void editSelectorListKeyPressed(KeyEvent keyEvent) {
        this.handleKeyPressed(keyEvent);
    }

    private void UndoButtonMouseClicked(MouseEvent mouseEvent) {
        this.undo();
    }

    private void RedoButtonMouseClicked(MouseEvent mouseEvent) {
        this.redo();
    }

    private void pasteMenuItemMousePressed(MouseEvent mouseEvent) {
        this.pasteAction();
    }

    private void cutButtonMouseClicked(MouseEvent mouseEvent) {
        this.cutAction();
    }

    private void copyButtonMouseClicked(MouseEvent mouseEvent) {
        this.copyAction();
    }

    private void pasteButtonMouseClicked(MouseEvent mouseEvent) {
        this.pasteAction();
    }

    private void clearButtonMouseClicked(MouseEvent mouseEvent) {
        this.clearBrowseList();
    }

    private void infoMenuItemMousePressed(MouseEvent mouseEvent) {
        this.showImageInfo();
    }

    private void infoMenuItemMenuKeyTyped(MenuKeyEvent menuKeyEvent) {
    }

    private void editSelectorListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateCutCopyPasteButtons();
    }
}

