/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jwx.AudioProcessor;
import jwx.CalibrationController;
import jwx.ChartPanel;
import jwx.ComboBoxController;
import jwx.CommonCode;
import jwx.ConfigManager;
import jwx.DecodeFax;
import jwx.FrameController;
import jwx.GraphicFileFilter;
import jwx.HelpPane;
import jwx.ToggleButtonController;

public final class JWX
extends JFrame {
    boolean debug = false;
    final String VERSION = "3.0";
    List<String> data_rates = Arrays.asList("8000", "12000", "16000", "24000", "32000", "48000", "96000");
    String default_rate = "24000";
    String default_thresh = "50";
    String default_volume = "0";
    int delete_hours = 48;
    int max_open_charts = 16;
    ConfigManager config_mgr;
    DecodeFax decode_fax = null;
    AudioProcessor audio_processor;
    ToggleButtonController grayscale;
    ToggleButtonController afc;
    ToggleButtonController fullscale;
    ToggleButtonController scroll_to_bottom;
    ToggleButtonController filter;
    ComboBoxController data_rate;
    ComboBoxController threshold;
    ComboBoxController monitor_volume;
    ComboBoxController audio_input;
    ComboBoxController audio_output;
    CalibrationController calibration;
    FrameController appsize;
    final String app_path;
    final String app_name;
    final String program_name;
    final String user_dir;
    final String data_path;
    final String chart_path;
    final String init_path;
    final String file_sep;
    int default_image_width = 1810;
    int timer_period_ms = 500;
    long old_samplecount = 0L;
    List<ChartPanel> chart_list;
    int chart_number = 0;
    Timer periodic_timer;
    ChartPanel current_chart = null;
    HelpPane help_pane = null;
    boolean scaled_images;
    int calibrate_phase = 0;
    double old_mouse_x;
    double old_mouse_y;
    int audio_read = 0;
    double reset_target_time;
    static final long serialVersionUID = 21614L;
    private JComboBox<String> audio_input_combobox;
    private JComboBox<String> audio_output_combobox;
    private JLabel audio_status_label;
    private JPanel bottom_panel_a;
    private JPanel bottom_panel_b;
    private JPanel bottom_panel_c;
    private JButton calibrate_button;
    private JTextField calibration_textfield;
    private JButton defaults_button;
    private JButton delete_button;
    private JCheckBox filter_checkbox;
    private JLabel frequency_status_label;
    private JCheckBox fullscale_checkbox;
    private JCheckBox grayscale_checkbox;
    private JButton help_button;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JButton load_button;
    private JButton lock_button;
    private JLabel machine_status_label;
    private JComboBox<String> monitor_volume_combobox;
    private JButton quit_button;
    private JComboBox<String> rate_combobox;
    private JButton receive_button;
    private JCheckBox scroll_checkbox;
    private JButton standby_button;
    private JTabbedPane tabbed_pane;
    private JComboBox<String> threshold_combobox;
    private JButton unlock_button;
    private JButton website_button;

    public JWX(String[] args) {
        this.initComponents();
        this.debug = args.length > 0 && args[0].equals("-d");
        this.app_name = this.getClass().getSimpleName();
        URL url = this.getClass().getResource(this.app_name + ".class");
        String temp = url.getPath().replaceFirst("(.*?)!.*", "$1");
        temp = temp.replaceFirst("file:", "");
        this.app_path = new File(temp).getPath();
        this.user_dir = System.getProperty("user.home");
        this.file_sep = System.getProperty("file.separator");
        this.data_path = this.user_dir + this.file_sep + "." + this.app_name;
        this.chart_path = this.data_path + this.file_sep + "charts";
        File f = new File(this.chart_path);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.init_path = this.data_path + this.file_sep + this.app_name + ".ini";
        this.program_name = this.app_name + " " + "3.0";
        this.setTitle(this.program_name);
        this.setIconImage(new ImageIcon(this.getClass().getResource("images/" + this.app_name + "_icon.png")).getImage());
        this.chart_list = new ArrayList<ChartPanel>();
        this.audio_processor = new AudioProcessor(this);
        this.setup_values();
        this.checkOldCharts();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JWX.this.inner_close();
            }
        });
        this.decode_fax = new DecodeFax(this);
        this.decode_fax.init_chart_read(true);
        this.scaled_images = !this.fullscale.get_value();
        this.periodic_timer = new Timer();
        this.periodic_timer.scheduleAtFixedRate((TimerTask)new PeriodicEvents(), 500L, (long)this.timer_period_ms);
    }

    private void debug_monitor() {
        if (this.debug) {
            double free = Runtime.getRuntime().freeMemory();
            String str = String.format("time %f reset_target_time %f %s chart %d free mem %.2e\n  ... integ %.2f wsig %.2f image_line %d sample_count %d audio_read %d \n... bi start %.4f active %d bi end %.4f active %d", this.decode_fax.time_sec, this.reset_target_time, this.decode_fax.state.toString(), this.chart_number, free, this.decode_fax.pll_integral, this.decode_fax.wsig, this.decode_fax.image_line, this.decode_fax.sample_count, this.audio_read, this.decode_fax.gstart.value(), this.decode_fax.gstart.active() ? 1 : 0, this.decode_fax.gend.value(), this.decode_fax.gend.active() ? 1 : 0);
            this.p(str);
        }
    }

    private void set_frequency_status() {
        double cycles = 0.0;
        double delta = (double)(this.decode_fax.sample_count - this.old_samplecount) / (double)this.decode_fax.sample_rate;
        if (delta != 0.0) {
            this.old_samplecount = this.decode_fax.sample_count;
            cycles = (double)this.decode_fax.frequency_meter_cycles / delta;
            this.decode_fax.frequency_meter_cycles = 0;
        }
        String s = String.format("Frequency %5.0f Hz", cycles);
        this.frequency_status_label.setText(s);
    }

    private void set_audio_status() {
        String vl = " Audio: ";
        if (this.audio_processor.read_valid()) {
            double v = this.decode_fax.gain_level;
            int iv = (int)(Math.sqrt(v) / 14.0);
            if (v < 1.0) {
                vl = vl + "None";
            } else if (iv < 1) {
                vl = vl + "Low";
            } else if (iv > 11) {
                vl = vl + "*** High ***";
            } else {
                for (int i = 0; i < iv; ++i) {
                    vl = vl + "|";
                }
            }
        } else {
            vl = this.decode_fax.enabled() ? vl + "Error" : vl + "Standby";
        }
        this.audio_status_label.setText(vl);
    }

    private void set_machine_status() {
        String s;
        boolean receive = this.decode_fax.enabled();
        String string = s = receive ? "Receive" : "Standby";
        if (receive) {
            s = s + " | " + (Object)((Object)this.decode_fax.state);
        }
        this.machine_status_label.setText(s);
    }

    private void set_control_enables() {
        boolean receiving_fax = this.decode_fax.receiving_fax();
        boolean current_chart_receiving = this.current_chart != null && this.current_chart.image_panel.receiving_fax();
        this.standby_button.setEnabled(!receiving_fax);
        this.lock_button.setEnabled(!receiving_fax && this.decode_fax.enabled());
        this.unlock_button.setEnabled(receiving_fax);
        this.receive_button.setEnabled(!this.decode_fax.enabled());
        this.standby_button.setEnabled(this.decode_fax.enabled() && !receiving_fax);
        this.defaults_button.setEnabled(!this.decode_fax.enabled());
        this.calibrate_button.setEnabled(!current_chart_receiving);
        this.calibration_textfield.setEnabled(!current_chart_receiving && this.calibrate_phase != 0);
        this.rate_combobox.setEnabled(!this.decode_fax.enabled());
        this.audio_output_combobox.setEnabled(this.audio_processor.write_valid());
        this.audio_input_combobox.setEnabled(!this.decode_fax.enabled());
        double thresh = this.threshold.get_percent_value();
        this.decode_fax.gstart.set_threshold(thresh * this.decode_fax.g_gain_adjust);
        this.decode_fax.gend.set_threshold(thresh * this.decode_fax.g_gain_adjust);
    }

    private List<String> make_numeric_list(int a, int b, int step) {
        ArrayList<String> data = new ArrayList<String>();
        for (int i = a; i != b; i += step) {
            data.add(Integer.toString(i));
        }
        return data;
    }

    private <T> List<String> make_string_list(List<T> data) {
        ArrayList<String> out = new ArrayList<String>();
        data.forEach(item -> out.add(item.toString()));
        return out;
    }

    private List<String> make_mixer_description_list(List<Mixer.Info> data, String extra) {
        ArrayList<String> out = new ArrayList<String>();
        if (extra != null) {
            out.add(extra);
        }
        data.forEach(item -> out.add(item.getDescription()));
        return out;
    }

    private void setup_values() {
        this.data_rate = new ComboBoxController(this.rate_combobox, this.data_rates, this.default_rate);
        List<String> data = this.make_numeric_list(1, 251, 1);
        this.threshold = new ComboBoxController(this.threshold_combobox, data, this.default_thresh);
        data = this.make_numeric_list(0, 501, 1);
        this.monitor_volume = new ComboBoxController(this.monitor_volume_combobox, data, this.default_volume);
        data = this.make_numeric_list(1, this.audio_processor.target_mixer_count + 1, 1);
        List<String> sdata = this.make_mixer_description_list(this.audio_processor.target_mixer_list, null);
        this.audio_input = new ComboBoxController(this.audio_input_combobox, data, "1", sdata, "Select input");
        data = this.make_numeric_list(1, this.audio_processor.source_mixer_count + 1, 1);
        sdata = this.make_mixer_description_list(this.audio_processor.source_mixer_list, null);
        this.audio_output = new ComboBoxController(this.audio_output_combobox, data, "1", sdata, "Select output");
        this.grayscale = new ToggleButtonController(this.grayscale_checkbox, true);
        this.fullscale = new ToggleButtonController(this.fullscale_checkbox, false);
        this.scroll_to_bottom = new ToggleButtonController(this.scroll_checkbox, true);
        this.filter = new ToggleButtonController(this.filter_checkbox, false);
        this.calibration = new CalibrationController(this.calibration_textfield, "0", this);
        this.appsize = new FrameController(this);
        this.config_mgr = new ConfigManager(this, this.init_path);
    }

    private void set_control_defaults() {
        if (CommonCode.ask_user(this, "OK to reset all settings to defaults\n(except calibration)?", "Reset Defaults")) {
            this.data_rate.set_value(this.default_rate);
            this.threshold.set_value(this.default_thresh);
            this.monitor_volume.set_value(this.default_volume);
            this.grayscale.set_value(true);
            this.fullscale.set_value(false);
            this.scroll_to_bottom.set_value(true);
            this.filter.set_value(false);
        }
    }

    public ChartPanel new_chart(String path, double cal_val) {
        ChartPanel panel = new ChartPanel(this, path, cal_val);
        this.chart_list.add(panel);
        ++this.chart_number;
        this.tabbed_pane.addTab("chart " + this.chart_number, panel);
        this.tabbed_pane.setSelectedComponent(panel);
        int index = this.tabbed_pane.getSelectedIndex();
        this.tabbed_pane.setToolTipTextAt(index, path);
        this.current_chart = panel;
        while (this.chart_list.size() > this.max_open_charts) {
            ChartPanel cp = this.chart_list.remove(0);
            cp.close();
        }
        return panel;
    }

    public ChartPanel new_chart(double cal_val) {
        String path = this.chart_path + this.file_sep + this.create_date_time_filename();
        return this.new_chart(path, cal_val);
    }

    public String create_date_time_filename() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy'_'HH-mm-ss.S");
        String s = sdf.format(date);
        s = s.replaceFirst("(\\.\\d).*", "$1");
        s = s.replaceAll("-", ".");
        return "chart_" + s + ".jpg";
    }

    private void load_image() {
        JFileChooser fc = new JFileChooser(new File(this.chart_path));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new GraphicFileFilter());
        fc.setDialogTitle("Load Chart File");
        fc.setMultiSelectionEnabled(true);
        if (fc.showOpenDialog(this) == 0) {
            File[] files;
            for (File f : files = fc.getSelectedFiles()) {
                this.new_chart(f.toString(), this.calibration.get_dvalue());
            }
        }
    }

    public void remove_tab(JComponent comp) {
        ChartPanel cp;
        this.tabbed_pane.remove(comp);
        if (comp instanceof ChartPanel && this.chart_list.contains(cp = (ChartPanel)comp)) {
            this.chart_list.remove(cp);
        }
    }

    public void cancel_calibrate() {
        this.calibrate_control(-1, 0.0, 0.0);
    }

    public void calibrate_control(int source, double x, double y) {
        double cval = 0.0;
        switch (source) {
            case 0: {
                if (this.calibrate_phase == 0) {
                    this.calibrate_phase = 1;
                    break;
                }
                this.calibrate_phase = 0;
                break;
            }
            case 1: {
                if (this.calibrate_phase != 1) break;
                cval = this.calibration.get_dvalue();
                this.process_cal_result(cval, true);
                this.calibrate_phase = 0;
                break;
            }
            case 2: {
                if (this.current_chart == null) break;
                if (this.calibrate_phase == 1) {
                    this.old_mouse_x = x;
                    this.old_mouse_y = y;
                    this.calibrate_phase = 2;
                    break;
                }
                if (this.calibrate_phase != 2) break;
                double div = y - this.old_mouse_y;
                cval = div != 0.0 ? (x - this.old_mouse_x) / (div * (double)this.current_chart.image_panel.width) : 0.0;
                this.process_cal_result(cval, false);
                this.calibrate_phase = 0;
                break;
            }
            default: {
                this.calibrate_phase = 0;
            }
        }
        this.calibrate_button.setText(this.calibrate_phase == 0 ? "Calibrate" : "Cancel");
    }

    private void process_cal_result(double v, boolean entry) {
        if (this.current_chart != null && !entry) {
            double nv = v;
            double ov = this.calibration.get_dvalue();
            if (CommonCode.ask_user(this, "Okay to save this calibration result?", "Save result")) {
                Object[] options;
                if (ov != 0.0 && CommonCode.ask_user(this, "Add to, or replace, existing calibration value?", "Add to or replace value", options = new Object[]{"Add", "Replace"})) {
                    nv += ov;
                }
                this.calibration.set_value(nv);
            }
            if (this.current_chart != null && CommonCode.ask_user(this, "Okay to apply this calibration to the current chart?", "Apply result")) {
                this.current_chart.image_panel.clock_correct(v);
            }
        }
    }

    private void launch_help() {
        if (this.help_pane == null) {
            this.help_pane = new HelpPane(this);
            this.tabbed_pane.addTab("Help", this.help_pane);
        }
        this.tabbed_pane.setSelectedComponent(this.help_pane);
    }

    private void launch_browser_website() {
        CommonCode.launch_browser("http://arachnoid.com/JWX");
    }

    private void set_current_tab() {
        this.cancel_calibrate();
        Component obj = this.tabbed_pane.getSelectedComponent();
        this.current_chart = obj instanceof ChartPanel ? (ChartPanel)obj : null;
    }

    public String read_file(String fp) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Scanner scanner = new Scanner(new File(fp));
            while (scanner.hasNextLine()) {
                stringBuilder.append(scanner.nextLine());
                stringBuilder.append("\n");
            }
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public void write_file(String fp, String data) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(fp));){
            bw.write(data);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void close_inactive_charts(boolean prompt) {
        if (!prompt || CommonCode.ask_user(this, "Okay to close all inactive charts?", "Close all inactive charts")) {
            ArrayList temp = new ArrayList();
            this.chart_list.stream().filter(cp -> !cp.image_panel.receiving_fax()).forEachOrdered(cp -> temp.add(cp));
            temp.stream().map(cp -> {
                cp.save_file();
                return cp;
            }).forEachOrdered(cp -> this.remove_tab((JComponent)cp));
        }
    }

    private ArrayList<File> getOldChartList() {
        long delta_t = this.delete_hours * 60 * 60 * 1000;
        long now = new Date().getTime();
        File dp = new File(this.chart_path);
        FilenameFilter ff = (f, name1) -> name1.matches("^(?i).*\\.jpg$");
        File[] flist = dp.listFiles(ff);
        ArrayList<File> dlist = new ArrayList<File>();
        for (File f2 : flist) {
            long lm = f2.lastModified();
            if (lm + delta_t >= now) continue;
            dlist.add(f2);
        }
        return dlist;
    }

    private void checkOldCharts() {
        ArrayList<File> dlist = this.getOldChartList();
        this.delete_button.setEnabled(dlist.size() > 0);
    }

    public void delete_old_charts() {
        ArrayList<File> dlist = this.getOldChartList();
        int n = dlist.size();
        if (n > 0) {
            if (CommonCode.ask_user(this, "Okay to delete " + n + " chart(s) older than " + this.delete_hours + " hours?", "Delete old charts")) {
                dlist.forEach(file -> file.delete());
            }
        } else {
            CommonCode.tell_user(this, "There are no charts older than " + this.delete_hours + " hours.", "Delete old charts");
        }
        this.checkOldCharts();
    }

    private void close() {
        if (!this.decode_fax.receiving_fax() || CommonCode.ask_user(this, "JWX is receiving a chart.\nOkay to save partial chart and quit?", "Receiving Chart")) {
            this.inner_close();
            System.exit(0);
        }
    }

    private void inner_close() {
        this.decode_fax.init_chart_read(false);
        this.periodic_timer.cancel();
        this.close_inactive_charts(false);
        this.config_mgr.write_config_file();
    }

    public <T> void p(T s) {
        System.out.println(s);
    }

    private void initComponents() {
        this.tabbed_pane = new JTabbedPane();
        this.bottom_panel_a = new JPanel();
        this.jPanel1 = new JPanel();
        this.audio_status_label = new JLabel();
        this.frequency_status_label = new JLabel();
        this.machine_status_label = new JLabel();
        this.jLabel1 = new JLabel();
        this.audio_input_combobox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.audio_output_combobox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.monitor_volume_combobox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.bottom_panel_b = new JPanel();
        this.filter_checkbox = new JCheckBox();
        this.calibrate_button = new JButton();
        this.calibration_textfield = new JTextField();
        this.receive_button = new JButton();
        this.standby_button = new JButton();
        this.lock_button = new JButton();
        this.unlock_button = new JButton();
        this.defaults_button = new JButton();
        this.website_button = new JButton();
        this.help_button = new JButton();
        this.bottom_panel_c = new JPanel();
        this.fullscale_checkbox = new JCheckBox();
        this.scroll_checkbox = new JCheckBox();
        this.grayscale_checkbox = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.threshold_combobox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.rate_combobox = new JComboBox();
        this.load_button = new JButton();
        this.delete_button = new JButton();
        this.quit_button = new JButton();
        this.setDefaultCloseOperation(0);
        this.setCursor(new Cursor(0));
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(400, 400));
        this.setName("mainframe");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JWX.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabbed_pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JWX.this.tabbed_paneStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabbed_pane, gridBagConstraints);
        this.bottom_panel_a.setToolTipText("");
        this.bottom_panel_a.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.audio_status_label.setBackground(new Color(51, 51, 51));
        this.audio_status_label.setFont(new Font("Monospaced", 1, 12));
        this.audio_status_label.setForeground(new Color(255, 255, 0));
        this.audio_status_label.setText("...");
        this.audio_status_label.setToolTipText("Audio level");
        this.audio_status_label.setAlignmentX(0.1f);
        this.audio_status_label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(255, 255, 0)));
        this.audio_status_label.setHorizontalTextPosition(2);
        this.audio_status_label.setOpaque(true);
        this.jPanel1.add(this.audio_status_label);
        this.frequency_status_label.setBackground(new Color(51, 51, 51));
        this.frequency_status_label.setFont(new Font("Monospaced", 1, 12));
        this.frequency_status_label.setForeground(new Color(153, 204, 255));
        this.frequency_status_label.setHorizontalAlignment(0);
        this.frequency_status_label.setText("...");
        this.frequency_status_label.setToolTipText("Average frequency");
        this.frequency_status_label.setAlignmentX(0.1f);
        this.frequency_status_label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(153, 204, 255)));
        this.frequency_status_label.setHorizontalTextPosition(0);
        this.frequency_status_label.setOpaque(true);
        this.jPanel1.add(this.frequency_status_label);
        this.machine_status_label.setBackground(new Color(51, 51, 51));
        this.machine_status_label.setFont(new Font("Monospaced", 1, 12));
        this.machine_status_label.setForeground(new Color(0, 204, 51));
        this.machine_status_label.setHorizontalAlignment(0);
        this.machine_status_label.setText("...");
        this.machine_status_label.setToolTipText("State machine status");
        this.machine_status_label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0, 204, 51)));
        this.machine_status_label.setOpaque(true);
        this.jPanel1.add(this.machine_status_label);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.bottom_panel_a.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText("In:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_a.add((Component)this.jLabel1, gridBagConstraints);
        this.audio_input_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.audio_input_combobox.setToolTipText("<html>Select audio input channel<br/>\n(while in standby)</html>\n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.bottom_panel_a.add(this.audio_input_combobox, gridBagConstraints);
        this.jLabel3.setText("Out:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_a.add((Component)this.jLabel3, gridBagConstraints);
        this.audio_output_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.audio_output_combobox.setToolTipText("<html>Select audio output channel<br/>\n(0 = disable)</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.bottom_panel_a.add(this.audio_output_combobox, gridBagConstraints);
        this.jLabel7.setText("Vol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_a.add((Component)this.jLabel7, gridBagConstraints);
        this.monitor_volume_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.monitor_volume_combobox.setToolTipText("<html>Adjust output volume (0 = off)<br/>\n(Hold down the shift key to<br/>\nincrease the rate of change)</html>\n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.bottom_panel_a.add(this.monitor_volume_combobox, gridBagConstraints);
        this.jLabel2.setText("%");
        this.bottom_panel_a.add((Component)this.jLabel2, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.bottom_panel_a, gridBagConstraints);
        this.bottom_panel_b.setLayout(new FlowLayout(1, 2, 2));
        this.filter_checkbox.setText("Filter");
        this.filter_checkbox.setToolTipText("Enable image noise filtering");
        this.filter_checkbox.setMargin(new Insets(0, 0, 0, 0));
        this.bottom_panel_b.add(this.filter_checkbox);
        this.calibrate_button.setText("Calibrate");
        this.calibrate_button.setToolTipText("Start calibration procedure");
        this.calibrate_button.setMargin(new Insets(2, 2, 2, 2));
        this.calibrate_button.setMaximumSize(new Dimension(80, 25));
        this.calibrate_button.setMinimumSize(new Dimension(80, 25));
        this.calibrate_button.setPreferredSize(new Dimension(80, 25));
        this.calibrate_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.calibrate_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.calibrate_button);
        this.calibration_textfield.setColumns(8);
        this.calibration_textfield.setHorizontalAlignment(4);
        this.calibration_textfield.setText("0.000");
        this.calibration_textfield.setToolTipText("Present calibration value");
        this.calibration_textfield.setMargin(new Insets(4, 2, 4, 2));
        this.bottom_panel_b.add(this.calibration_textfield);
        this.receive_button.setText("Receive");
        this.receive_button.setToolTipText("Enable receive mode");
        this.receive_button.setMargin(new Insets(2, 2, 2, 2));
        this.receive_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.receive_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.receive_button);
        this.standby_button.setText("Standby");
        this.standby_button.setToolTipText("Disable receive mode");
        this.standby_button.setMargin(new Insets(2, 2, 2, 2));
        this.standby_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.standby_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.standby_button);
        this.lock_button.setText("Lock");
        this.lock_button.setToolTipText("Force receiver lock without synchronization");
        this.lock_button.setMargin(new Insets(2, 2, 2, 2));
        this.lock_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.lock_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.lock_button);
        this.unlock_button.setText("Unlock");
        this.unlock_button.setToolTipText("Unlock receiver, stop reception");
        this.unlock_button.setMargin(new Insets(2, 2, 2, 2));
        this.unlock_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.unlock_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.unlock_button);
        this.defaults_button.setText("Defaults");
        this.defaults_button.setToolTipText("Set all default values except calibration");
        this.defaults_button.setMargin(new Insets(2, 2, 2, 2));
        this.defaults_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.defaults_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.defaults_button);
        this.website_button.setText("Website");
        this.website_button.setToolTipText("Visit the JWX home page");
        this.website_button.setMargin(new Insets(2, 2, 2, 2));
        this.website_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.website_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.website_button);
        this.help_button.setText("Help");
        this.help_button.setToolTipText("Read JWX help");
        this.help_button.setIconTextGap(0);
        this.help_button.setMargin(new Insets(2, 2, 2, 2));
        this.help_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.help_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_b.add(this.help_button);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.bottom_panel_b, gridBagConstraints);
        this.bottom_panel_c.setLayout(new FlowLayout(1, 2, 2));
        this.fullscale_checkbox.setText("Full");
        this.fullscale_checkbox.setToolTipText("Show images at full scale");
        this.fullscale_checkbox.setMargin(new Insets(0, 0, 0, 0));
        this.bottom_panel_c.add(this.fullscale_checkbox);
        this.scroll_checkbox.setSelected(true);
        this.scroll_checkbox.setText("Scroll");
        this.scroll_checkbox.setToolTipText("Scroll to image bottom as data is received");
        this.scroll_checkbox.setMargin(new Insets(0, 0, 0, 0));
        this.bottom_panel_c.add(this.scroll_checkbox);
        this.grayscale_checkbox.setSelected(true);
        this.grayscale_checkbox.setText("Grayscale |");
        this.grayscale_checkbox.setToolTipText("Grayscale mode for satellite images and pictures");
        this.grayscale_checkbox.setMargin(new Insets(0, 0, 0, 0));
        this.bottom_panel_c.add(this.grayscale_checkbox);
        this.jLabel5.setText("Threshold: ");
        this.bottom_panel_c.add(this.jLabel5);
        this.threshold_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.threshold_combobox.setToolTipText("<html>Set start/stop tone sensitivity<br/>\n(if you don't know what this is, set it to 30%)<br/>\n(Hold down the shift key to increase the rate of change)</html>\n");
        this.bottom_panel_c.add(this.threshold_combobox);
        this.jLabel4.setText("% |");
        this.bottom_panel_c.add(this.jLabel4);
        this.jLabel6.setText("Rate: ");
        this.bottom_panel_c.add(this.jLabel6);
        this.rate_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.rate_combobox.setToolTipText("Set data rate (while in standby)");
        this.bottom_panel_c.add(this.rate_combobox);
        this.load_button.setText("Load");
        this.load_button.setToolTipText("Load a previously received chart file");
        this.load_button.setMargin(new Insets(2, 2, 2, 2));
        this.load_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.load_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_c.add(this.load_button);
        this.delete_button.setText("Delete...");
        this.delete_button.setToolTipText("Delete old charts");
        this.delete_button.setMargin(new Insets(2, 2, 2, 2));
        this.delete_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.delete_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_c.add(this.delete_button);
        this.quit_button.setText("Quit");
        this.quit_button.setToolTipText("Exit JWX");
        this.quit_button.setMargin(new Insets(2, 2, 2, 2));
        this.quit_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JWX.this.quit_buttonMouseClicked(evt);
            }
        });
        this.bottom_panel_c.add(this.quit_button);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.bottom_panel_c, gridBagConstraints);
        this.pack();
    }

    private void quit_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.close();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    private void defaults_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.set_control_defaults();
        }
    }

    private void unlock_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.decode_fax.unlock();
        }
    }

    private void load_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.load_image();
        }
    }

    private void receive_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.decode_fax.init_chart_read(true);
        }
    }

    private void standby_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.decode_fax.init_chart_read(false);
        }
    }

    private void lock_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.decode_fax.lock();
        }
    }

    private void calibrate_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.calibrate_control(0, 0.0, 0.0);
        }
    }

    private void help_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.launch_help();
        }
    }

    private void website_buttonMouseClicked(MouseEvent evt) {
        this.launch_browser_website();
    }

    private void tabbed_paneStateChanged(ChangeEvent evt) {
        this.set_current_tab();
    }

    private void delete_buttonMouseClicked(MouseEvent evt) {
        this.delete_old_charts();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            EventQueue.invokeLater(() -> new JWX(args).setVisible(true));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            System.out.println("main: " + e);
        }
    }

    class PeriodicEvents
    extends TimerTask {
        PeriodicEvents() {
        }

        @Override
        public void run() {
            JWX.this.scaled_images = !JWX.this.fullscale.get_value();
            JWX.this.chart_list.forEach(ChartPanel::perform_periodic);
            JWX.this.set_control_enables();
            JWX.this.decode_fax.periodic_actions();
            JWX.this.set_machine_status();
            JWX.this.set_audio_status();
            JWX.this.set_frequency_status();
            JWX.this.audio_processor.periodic_actions();
            JWX.this.debug_monitor();
            JWX.this.repaint();
        }
    }
}

