/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import jwx.ChartPanel;
import jwx.CommonCode;

public class ImagePanel
extends JPanel {
    ChartPanel parent;
    BufferedImage buffered_image = null;
    List<byte[]> image_array;
    int height;
    int width;
    byte[] bbuffer = null;
    int bbuffer_height = 0;
    int block_size = 400;
    int old_line = 0;
    int imagew;
    int imageh;
    int scaledw;
    int scaledh;
    File file;
    boolean receiving_fax;
    double image_scale = 1.0;
    int mousex;
    int mousey;
    int translate_val = 0;
    boolean changed = false;
    static final long serialVersionUID = 22045L;

    public ImagePanel(ChartPanel p, String path) {
        this.parent = p;
        this.width = this.parent.parent.default_image_width;
        this.initComponents();
        this.image_array = new ArrayList<byte[]>();
        this.old_line = 0;
        this.file = new File(path);
        this.process_path();
    }

    private void process_path() {
        try {
            boolean bl = this.receiving_fax = !this.file.exists();
            if (this.receiving_fax) {
                this.file.createNewFile();
            } else {
                this.load_file();
            }
        }
        catch (IOException e) {
            CommonCode.p("process_path: " + e);
        }
    }

    private void load_file() {
        try {
            this.buffered_image = ImageIO.read(this.file);
            this.width = this.buffered_image.getWidth();
            this.height = this.buffered_image.getHeight();
            this.load_data_array();
        }
        catch (IOException e) {
            CommonCode.p("load file: " + e);
        }
    }

    private void load_data_array() {
        this.image_array.clear();
        Raster raster = this.buffered_image.getData();
        DataBufferByte dbb = (DataBufferByte)raster.getDataBuffer();
        byte[][] bb = dbb.getBankData();
        int len = bb[0].length;
        int j = 0;
        byte[] line = new byte[this.width];
        for (int i = 0; i < len; ++i) {
            line[j++] = bb[0][i];
            if (j < this.width) continue;
            this.image_array.add(line);
            j = 0;
            line = new byte[this.width];
        }
        this.update_image(true);
        this.changed = false;
    }

    public boolean get_changed() {
        return this.changed;
    }

    public boolean receiving_fax() {
        return this.receiving_fax;
    }

    public void save_file() {
        if (this.changed && this.buffered_image != null && this.buffered_image.getHeight() > 0) {
            try {
                ImageIO.write((RenderedImage)this.buffered_image, "jpg", this.file);
                this.changed = false;
            }
            catch (IOException e) {
                CommonCode.p("save file: " + e);
            }
        }
    }

    public void update_image(boolean erase) {
        this.height = this.image_array.size();
        if (erase) {
            this.bbuffer = null;
        }
        if (this.bbuffer == null) {
            this.bbuffer_height = 0;
            this.old_line = 0;
        }
        if (this.height > 0 && this.height > this.old_line) {
            if (this.height >= this.bbuffer_height) {
                while (this.height >= this.bbuffer_height) {
                    this.bbuffer_height += this.block_size;
                }
                byte[] new_bbuffer = new byte[this.bbuffer_height * this.width];
                if (this.bbuffer != null) {
                    System.arraycopy(this.bbuffer, 0, new_bbuffer, 0, this.bbuffer.length);
                }
                this.bbuffer = new_bbuffer;
            }
            int pos = this.width * this.old_line;
            for (int i = this.old_line; i < this.height; ++i) {
                byte[] line = this.image_array.get(i);
                System.arraycopy(line, 0, this.bbuffer, pos, this.width);
                pos += this.width;
            }
            this.old_line = this.height;
            this.buffered_image = new BufferedImage(this.width, this.height, 10);
            DataBufferByte dbb = new DataBufferByte(this.bbuffer, this.width * this.height);
            SampleModel sm = this.buffered_image.getSampleModel();
            Raster r = Raster.createRaster(sm, dbb, null);
            this.buffered_image.setData(r);
            this.set_image_scale();
            this.changed = true;
        }
        this.repaint();
    }

    public void add_line(byte[] line) {
        if (this.translate_val != 0) {
            line = CommonCode.translate_line(line, this.translate_val);
        }
        if (this.parent.calibration_val != 0.0) {
            int y = this.image_array.size();
            line = CommonCode.clock_correct_line(line, y, (double)this.width * this.parent.calibration_val);
        }
        this.image_array.add(line);
        this.changed = true;
    }

    public void scroll_test(boolean force) {
        if ((force || this.receiving_fax) && this.parent.parent.scroll_to_bottom.get_value()) {
            SwingUtilities.invokeLater(() -> {
                JScrollBar vbar = this.parent.get_vert_scroll_bar();
                vbar.setValue(vbar.getMaximum());
            });
        }
    }

    public void set_image_scale() {
        if (this.buffered_image != null) {
            this.imagew = this.buffered_image.getWidth(this);
            this.imageh = this.buffered_image.getHeight(this);
            this.scaledw = this.imagew;
            this.scaledh = this.imageh;
            this.image_scale = 1.0;
            if (this.parent.parent.scaled_images) {
                Dimension vs = this.parent.get_view_size();
                int dw = vs.width - 1;
                if (dw == 0) {
                    dw = this.width;
                }
                this.image_scale = (double)dw / (double)this.imagew;
                this.scaledw = (int)((double)this.imagew * this.image_scale);
                this.scaledh = (int)((double)this.imageh * this.image_scale);
            }
            this.setPreferredSize(new Dimension(this.scaledw, this.scaledh));
            this.setSize(this.scaledw, this.scaledh);
        }
    }

    private boolean mouse_in_image() {
        return this.mousex <= this.imagew && this.mousey <= this.imageh;
    }

    private void mouse_exit() {
        this.parent.set_data_label("");
    }

    private void track_mouse(MouseEvent evt) {
        int mx = evt.getX();
        int my = evt.getY();
        if (this.image_scale != 0.0) {
            mx = (int)((double)mx / this.image_scale);
            my = (int)((double)my / this.image_scale);
        }
        this.mousex = mx;
        this.mousey = my;
        if (this.mouse_in_image()) {
            String s = String.format("Mouse: {%d,%d}", this.mousex, this.mousey);
            this.parent.set_data_label(s);
        } else {
            this.mouse_exit();
        }
    }

    private void manage_mouse_press(MouseEvent evt) {
        int button = evt.getButton();
        switch (button) {
            case 1: {
                this.translate();
                break;
            }
            case 3: {
                if (!this.receiving_fax) {
                    if (this.parent.parent.calibrate_phase == 0) {
                        if (CommonCode.ask_user(this.parent.parent, "Okay to enter calibrate mode?", "Not in calibrate mode")) {
                            this.parent.parent.calibrate_control(0, 0.0, 0.0);
                        } else {
                            return;
                        }
                    }
                    this.parent.parent.calibrate_control(2, this.mousex, this.mousey);
                    break;
                }
                CommonCode.tell_user(this.parent.parent, "Cannot calibrate while receiving fax", "Calibration unavailable");
            }
        }
    }

    private List<byte[]> translate_image(List<byte[]> src, int delta) {
        ArrayList<byte[]> b = new ArrayList<byte[]>();
        src.forEach(a -> b.add(CommonCode.translate_line(a, delta)));
        return b;
    }

    private void translate() {
        if (this.mouse_in_image() && CommonCode.ask_user(this.parent.parent, "Okay to realign image?", "Adjust Image Alignment")) {
            int delta = this.mousex;
            this.translate_val = (this.translate_val + delta + this.width * 8) % this.width;
            this.image_array = this.translate_image(this.image_array, delta);
            this.update_image(true);
        }
    }

    public void clock_correct(double delta) {
        if (!this.receiving_fax) {
            delta *= (double)this.width;
            ArrayList<byte[]> b = new ArrayList<byte[]>();
            int line = 0;
            for (byte[] a : this.image_array) {
                b.add(CommonCode.clock_correct_line(a, line, delta));
                ++line;
            }
            this.image_array = b;
            this.update_image(true);
        }
    }

    public void invert_image() {
        this.image_array.forEach(b -> {
            for (int i = 0; i < ((byte[])b).length; ++i) {
                b[i] = (byte)(255 - b[i]);
            }
        });
        this.update_image(true);
    }

    public void rotate_image(boolean cw) {
        if (this.image_array != null) {
            int y;
            ArrayList<byte[]> dest = new ArrayList<byte[]>();
            if (cw) {
                for (y = 0; y < this.width; ++y) {
                    byte[] row = new byte[this.height];
                    for (int x = 0; x < this.height; ++x) {
                        row[x] = this.image_array.get(this.height - x - 1)[y];
                    }
                    dest.add(row);
                }
            } else {
                for (y = 0; y < this.width; ++y) {
                    byte[] row = new byte[this.height];
                    for (int x = 0; x < this.height; ++x) {
                        row[x] = this.image_array.get(x)[this.width - y - 1];
                    }
                    dest.add(row);
                }
            }
            this.image_array = dest;
            int temp = this.height;
            this.height = this.width;
            this.width = temp;
            this.update_image(true);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.buffered_image != null) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.parent.parent.scaled_images) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(this.buffered_image, 0, 0, this.scaledw, this.scaledh, this);
            } else {
                g2.drawImage((Image)this.buffered_image, 0, 0, this);
            }
        }
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImagePanel.this.formMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ImagePanel.this.formMouseExited(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ImagePanel.this.formMouseMoved(evt);
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
                ImagePanel.this.formAncestorResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 247, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 65, Short.MAX_VALUE));
    }

    private void formAncestorResized(HierarchyEvent evt) {
        this.set_image_scale();
    }

    private void formMouseMoved(MouseEvent evt) {
        this.track_mouse(evt);
    }

    private void formMouseClicked(MouseEvent evt) {
        this.manage_mouse_press(evt);
    }

    private void formMouseExited(MouseEvent evt) {
        this.mouse_exit();
    }
}

