/*
 * Decompiled with CFR 0.152.
 */
package jwx;

public final class GoertzelFilter {
    private final double samples;
    private final double scaling_factor;
    private final double goertzel_factor;
    private double threshold;
    private double s0;
    private double s1;
    private double s2;
    private double samplecount;
    private double value;

    public GoertzelFilter(double frequency, double samples, double threshold) {
        this.samples = samples;
        this.threshold = threshold;
        this.goertzel_factor = 2.0 * Math.cos(Math.PI * 2 * frequency);
        this.scaling_factor = 4.0 / (samples * samples);
        this.reset(true);
    }

    public void process(double v) {
        this.s0 = v + this.goertzel_factor * this.s1 - this.s2;
        this.s2 = this.s1;
        this.s1 = this.s0;
        this.samplecount += 1.0;
        if (this.samplecount >= this.samples) {
            this.update();
        }
    }

    void update() {
        this.value = (this.s2 * this.s2 + this.s1 * this.s1 - this.goertzel_factor * this.s1 * this.s2) * this.scaling_factor;
        this.reset(false);
    }

    void reset(boolean full) {
        this.samplecount = 0.0;
        this.s2 = 0.0;
        this.s1 = 0.0;
        if (full) {
            this.value = 0.0;
        }
    }

    public void set_threshold(double v) {
        this.threshold = v;
    }

    public double value() {
        return this.value;
    }

    public boolean active() {
        return this.value >= this.threshold;
    }
}

