/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import jwx.BiQuadraticFilter;
import jwx.ChartPanel;
import jwx.CommonCode;
import jwx.GoertzelFilter;
import jwx.JWX;
import jwx.MachineState;

public final class DecodeFax {
    JWX parent;
    double goertzel_accept;
    GoertzelFilter gstart = null;
    GoertzelFilter gend = null;
    ChartPanel chart_panel;
    MachineState[] machine_states = new MachineState[]{new s_waitsig(), new s_waitstb(), new s_waitste(), new s_waitls1(), new s_sync(), new s_waitls2(), new s_proc(), new s_end()};
    State state;
    double calibration_val;
    long sample_rate;
    int sync_time;
    double sync_interval;
    int sync_lines;
    int lines_per_second;
    double sample_increm;
    int row_len;
    long long_row_len;
    double sig_sum;
    double sig_count;
    double sampleinterval;
    double gain_thresh;
    double gain_level;
    double gain_tc;
    double cf;
    double invsqr2 = 1.0 / Math.sqrt(2.0);
    double rcvr_mark;
    double rcvr_space;
    double rcvr_dev;
    double ms_q;
    double bp_q;
    double startf;
    double stopf;
    double wsig;
    double sig;
    double g_size;
    double g_gain_adjust = 0.5;
    double time_sec;
    long sample_count;
    long line_time_zero_count;
    int sign;
    long line_time_delta;
    boolean linetime_zero;
    int frequency_meter_cycles;
    int old_sign;
    int image_line;
    int row_index;
    int line_index;
    double row_pos;
    int timer_counter = 0;
    double[] sync_array;
    double[] sync_line;
    double val;
    byte[] line_buf;
    boolean grayscale = true;
    boolean video_filter = false;
    boolean enabled = false;
    double pll_integral = 0.0;
    double pll_reference = 0.0;
    double pll_loop_control;
    double pll_loop_gain = 1.0;
    double pll_center_f = 1900.0;
    double pll_deviation_f = 400.0;
    double pll_output_gain = 1.2 * this.pll_center_f / this.pll_deviation_f;
    double pll_omega = Math.PI * 2 * this.pll_center_f;
    double pll_output_lowpass_filter_f = 650.0;
    double pll_video_lowpass_filter_f = 400.0;
    BiQuadraticFilter biquad_pll_output_lowpass;
    BiQuadraticFilter biquad_video_lowpass;

    public DecodeFax(JWX p) {
        this.parent = p;
        this.goertzel_accept = 0.5;
    }

    private void setup() {
        this.sync_time = 20;
        this.calibration_val = this.parent.calibration.get_dvalue();
        this.state = State.WAITSIG;
        this.sample_rate = this.parent.data_rate.get_value();
        this.sync_interval = 0.025;
        this.lines_per_second = 2;
        this.sync_lines = this.sync_time * this.lines_per_second;
        this.gain_tc = 1000.0 / (double)this.sample_rate;
        this.sample_increm = (double)this.sample_rate / ((double)this.parent.default_image_width * 2.0);
        this.long_row_len = this.sample_rate / (long)this.lines_per_second;
        this.row_len = (int)this.long_row_len;
        this.sampleinterval = 1.0 / (double)this.sample_rate;
        this.gain_thresh = 256.0;
        this.cf = 2050.0;
        this.rcvr_dev = 800.0;
        this.bp_q = 1.0;
        this.ms_q = 2.0;
        this.rcvr_mark = this.cf + this.rcvr_dev;
        this.rcvr_space = this.cf - this.rcvr_dev;
        this.startf = 300.0;
        this.stopf = 450.0;
        this.g_size = (double)this.sample_rate / 4.0;
        this.gstart = new GoertzelFilter(this.startf * this.sampleinterval, this.g_size, this.goertzel_accept);
        this.gend = new GoertzelFilter(this.stopf * this.sampleinterval, this.g_size, this.goertzel_accept);
        this.biquad_pll_output_lowpass = new BiQuadraticFilter(BiQuadraticFilter.Type.LOWPASS, this.pll_output_lowpass_filter_f, this.sample_rate, this.invsqr2);
        this.biquad_video_lowpass = new BiQuadraticFilter(BiQuadraticFilter.Type.LOWPASS, this.pll_video_lowpass_filter_f, this.sample_rate, this.invsqr2);
        this.enable_filtering();
    }

    public void init_chart_read(boolean enable) {
        this.parent.cancel_calibrate();
        if (enable && !this.enabled) {
            this.setup();
            this.old_sign = 0;
            this.sig = 0.0;
            this.sample_count = 0L;
            this.line_time_zero_count = 0L;
            this.image_line = 0;
            this.line_time_delta = 0L;
            this.frequency_meter_cycles = 0;
            this.state = State.WAITSIG;
            this.linetime_zero = false;
            this.gstart.reset(true);
            this.gend.reset(true);
            this.parent.audio_processor.enable_audio_read(true);
        } else if (!enable && this.enabled) {
            this.unlock();
            this.parent.audio_processor.enable_audio_read(false);
        }
        System.gc();
        this.enabled = enable;
    }

    public boolean enabled() {
        return this.enabled;
    }

    protected void process_data(short[] array) {
        for (short v : array) {
            double dv = v;
            this.time_sec = (double)this.sample_count * this.sampleinterval;
            this.linetime_zero = (this.sample_count - this.line_time_delta) % this.long_row_len == 0L;
            ++this.line_time_zero_count;
            this.gain_level += (Math.abs(dv) - this.gain_level) * this.gain_tc;
            this.gain_level = Math.max(0.1, this.gain_level);
            this.pll_loop_control = (dv /= this.gain_level) * this.pll_reference * this.pll_loop_gain;
            this.pll_integral += this.pll_loop_control * this.sampleinterval;
            if (Double.isInfinite(this.pll_integral)) {
                this.pll_integral = 0.0;
            }
            this.pll_reference = Math.sin(this.pll_omega * (this.time_sec + this.pll_integral));
            this.wsig = this.biquad_pll_output_lowpass.filter(this.pll_loop_control) * this.pll_output_gain;
            this.wsig = Math.min(this.wsig, 2.0);
            this.wsig = Math.max(this.wsig, -2.0);
            int n = this.sign = this.pll_reference > 0.0 ? 1 : -1;
            if (this.sign > this.old_sign) {
                ++this.frequency_meter_cycles;
            }
            this.old_sign = this.sign;
            this.gstart.process(this.wsig);
            this.gend.process(this.wsig);
            double d = this.sig = this.video_filter ? this.biquad_video_lowpass.filter(this.wsig) : this.wsig;
            while (this.machine_states[this.state.ordinal()].exec()) {
            }
            if (this.linetime_zero) {
                ++this.image_line;
                this.line_time_zero_count = 0L;
            }
            ++this.sample_count;
        }
    }

    public void save_chart() {
        if (this.chart_panel != null) {
            this.chart_panel.image_panel.receiving_fax = false;
            this.chart_panel.image_panel.update_image(false);
            this.chart_panel.image_panel.save_file();
            this.chart_panel.image_panel.scroll_test(true);
        }
    }

    public boolean receiving_fax() {
        return this.enabled && this.state != State.WAITSIG && this.state != State.WAITSTB && this.state != State.END;
    }

    public void unlock() {
        this.save_chart();
        this.parent.cancel_calibrate();
        this.state = State.END;
    }

    public void lock() {
        if (!this.enabled) {
            CommonCode.tell_user(this.parent, "Must enable receive to lock", "Cannot Lock");
        } else {
            this.parent.cancel_calibrate();
            this.state = State.WAITLS2;
        }
    }

    public void periodic_actions() {
        if (this.state == State.PROC && this.chart_panel != null && this.timer_counter++ % 4 == 0) {
            this.chart_panel.image_panel.update_image(false);
        }
        this.enable_filtering();
        this.grayscale = this.parent.grayscale.get_value();
    }

    public void enable_filtering() {
        this.video_filter = this.parent.filter.get_value();
    }

    final class s_end
    implements MachineState {
        s_end() {
        }

        @Override
        public boolean exec() {
            DecodeFax.this.save_chart();
            DecodeFax.this.state = State.WAITSIG;
            return false;
        }
    }

    final class s_proc
    implements MachineState {
        s_proc() {
        }

        @Override
        public boolean exec() {
            if (DecodeFax.this.linetime_zero) {
                DecodeFax.this.row_index = 0;
                DecodeFax.this.row_pos = 0.0;
                DecodeFax.this.line_index = 0;
                if (DecodeFax.this.line_buf != null) {
                    DecodeFax.this.chart_panel.image_panel.add_line(DecodeFax.this.line_buf);
                }
                DecodeFax.this.line_buf = new byte[DecodeFax.this.parent.default_image_width];
                if (DecodeFax.this.gend.active() || DecodeFax.this.image_line > 4000) {
                    DecodeFax.this.state = State.END;
                    return true;
                }
            }
            if ((double)DecodeFax.this.row_index > DecodeFax.this.row_pos) {
                DecodeFax.this.row_pos += DecodeFax.this.sample_increm;
                if (DecodeFax.this.sig_count > 0.0) {
                    DecodeFax.this.sig_sum /= DecodeFax.this.sig_count;
                }
                DecodeFax.this.val = (DecodeFax.this.sig_sum + 1.0) * 0.5;
                DecodeFax.this.sig_sum = 0.0;
                DecodeFax.this.sig_count = 0.0;
                DecodeFax.this.val = Math.min(DecodeFax.this.val, 1.0);
                DecodeFax.this.val = Math.max(DecodeFax.this.val, 0.0);
                byte b = DecodeFax.this.grayscale ? (byte)(DecodeFax.this.val * 255.0) : (byte)(DecodeFax.this.val > 0.5 ? 255 : 0);
                DecodeFax.this.line_buf[DecodeFax.this.line_index++] = b;
            } else {
                DecodeFax.this.sig_sum += DecodeFax.this.sig;
                DecodeFax.this.sig_count += 1.0;
            }
            ++DecodeFax.this.row_index;
            return false;
        }
    }

    final class s_waitls2
    implements MachineState {
        s_waitls2() {
        }

        @Override
        public boolean exec() {
            if (DecodeFax.this.linetime_zero) {
                DecodeFax.this.calibration_val = DecodeFax.this.parent.calibration.get_dvalue();
                DecodeFax.this.chart_panel = DecodeFax.this.parent.new_chart(DecodeFax.this.calibration_val);
                DecodeFax.this.row_index = 0;
                DecodeFax.this.row_pos = 0.0;
                DecodeFax.this.line_index = 0;
                DecodeFax.this.line_buf = null;
                DecodeFax.this.sig_sum = 0.0;
                DecodeFax.this.sig_count = 0.0;
                DecodeFax.this.state = State.PROC;
                return true;
            }
            return false;
        }
    }

    final class s_sync
    implements MachineState {
        s_sync() {
        }

        @Override
        public boolean exec() {
            if (DecodeFax.this.sync_array == null) {
                DecodeFax.this.calibration_val = DecodeFax.this.parent.calibration.get_dvalue();
                DecodeFax.this.image_line = 0;
                DecodeFax.this.row_index = 0;
                DecodeFax.this.sync_array = new double[DecodeFax.this.row_len];
                DecodeFax.this.sync_line = new double[DecodeFax.this.row_len];
            }
            int n = DecodeFax.this.row_index++;
            DecodeFax.this.sync_line[n] = DecodeFax.this.sync_line[n] + DecodeFax.this.wsig;
            if (DecodeFax.this.row_index >= DecodeFax.this.row_len) {
                DecodeFax.this.row_index = 0;
                DecodeFax.this.sync_line = CommonCode.clock_correct_line(DecodeFax.this.sync_line, DecodeFax.this.image_line, (double)DecodeFax.this.row_len * DecodeFax.this.calibration_val);
                for (int i = 0; i < DecodeFax.this.row_len; ++i) {
                    int n2 = i;
                    DecodeFax.this.sync_array[n2] = DecodeFax.this.sync_array[n2] + DecodeFax.this.sync_line[i];
                    DecodeFax.this.sync_line[i] = 0.0;
                }
                if (DecodeFax.this.image_line >= DecodeFax.this.sync_lines) {
                    double iv = DecodeFax.this.sync_array[DecodeFax.this.sync_array.length - 1];
                    double os = iv > 0.0 ? 1.0 : -1.0;
                    double tc = 200.0 / (double)DecodeFax.this.sample_rate;
                    for (int i = 0; i < DecodeFax.this.row_len; ++i) {
                        double ns = (iv += (DecodeFax.this.sync_array[i] - iv) * tc) > 0.0 ? 1.0 : -1.0;
                        DecodeFax.this.sync_line[i] = ns - os;
                        os = ns;
                    }
                    StringBuilder sb = new StringBuilder();
                    double v = DecodeFax.this.sync_line[0];
                    DecodeFax.this.line_time_delta = 0L;
                    for (int i = 1; i < DecodeFax.this.row_len; ++i) {
                        if (!(DecodeFax.this.sync_line[i] < v)) continue;
                        v = DecodeFax.this.sync_line[i];
                        DecodeFax.this.line_time_delta = i;
                    }
                    DecodeFax.this.line_time_delta = (long)((double)DecodeFax.this.line_time_delta + ((double)(DecodeFax.this.sync_lines * DecodeFax.this.row_len) * DecodeFax.this.calibration_val - (double)((int)(DecodeFax.this.sync_interval * 0.12 * (double)DecodeFax.this.sample_rate))));
                    DecodeFax.this.state = State.WAITLS2;
                    return true;
                }
            }
            return false;
        }
    }

    final class s_waitls1
    implements MachineState {
        s_waitls1() {
        }

        @Override
        public boolean exec() {
            if (DecodeFax.this.linetime_zero) {
                DecodeFax.this.sync_array = null;
                DecodeFax.this.state = State.SYNC;
                return true;
            }
            return false;
        }
    }

    final class s_waitste
    implements MachineState {
        s_waitste() {
        }

        @Override
        public boolean exec() {
            if (!DecodeFax.this.gstart.active()) {
                DecodeFax.this.state = State.WAITLS1;
                return true;
            }
            return false;
        }
    }

    final class s_waitstb
    implements MachineState {
        s_waitstb() {
        }

        @Override
        public boolean exec() {
            if (DecodeFax.this.gain_level < DecodeFax.this.gain_thresh) {
                DecodeFax.this.state = State.WAITSIG;
                return true;
            }
            if (DecodeFax.this.gstart.active()) {
                DecodeFax.this.state = State.WAITSTE;
                return true;
            }
            return false;
        }
    }

    final class s_waitsig
    implements MachineState {
        s_waitsig() {
        }

        @Override
        public boolean exec() {
            DecodeFax.this.image_line = 0;
            DecodeFax.this.line_time_delta = 0L;
            if (DecodeFax.this.gain_level > DecodeFax.this.gain_thresh) {
                DecodeFax.this.state = State.WAITSTB;
                return true;
            }
            return false;
        }
    }

    static enum State {
        WAITSIG,
        WAITSTB,
        WAITSTE,
        WAITLS1,
        SYNC,
        WAITLS2,
        PROC,
        END;

    }
}

