/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import jwx.AudioInputReader;
import jwx.CommonCode;
import jwx.JWX;

public final class AudioProcessor {
    JWX parent;
    SourceDataLine audioOutputLine = null;
    AudioFormat audioFormat = null;
    final int word_size = 2;
    final int sbufsz = 4096;
    final int bbufsz = 8192;
    boolean read_enable = false;
    AudioInputReader audio_reader = null;
    final byte[] out_buffer = new byte[8192];
    Line.Info targetLineInfo;
    Line.Info sourceLineInfo;
    boolean read_valid = false;
    boolean write_valid = false;
    List<Mixer.Info> source_mixer_list;
    List<Mixer.Info> target_mixer_list;
    int source_mixer_count;
    int target_mixer_count;
    int target_mixer_index = -1;
    int source_mixer_index = -1;
    int new_index = -1;

    public AudioProcessor(JWX p) {
        this.parent = p;
        this.targetLineInfo = new Line.Info(TargetDataLine.class);
        this.sourceLineInfo = new Line.Info(SourceDataLine.class);
        Mixer.Info[] mi_list = AudioSystem.getMixerInfo();
        this.source_mixer_list = new ArrayList<Mixer.Info>();
        this.target_mixer_list = new ArrayList<Mixer.Info>();
        for (Mixer.Info mi : mi_list) {
            Mixer mixer = AudioSystem.getMixer(mi);
            if (mixer.isLineSupported(this.targetLineInfo)) {
                this.target_mixer_list.add(mi);
            }
            if (!mixer.isLineSupported(this.sourceLineInfo)) continue;
            this.source_mixer_list.add(mi);
        }
        this.target_mixer_count = this.target_mixer_list.size();
        this.source_mixer_count = this.source_mixer_list.size();
    }

    public void periodic_actions() {
        this.enable_audio_write_check();
    }

    public boolean read_valid() {
        return this.read_valid;
    }

    public boolean write_valid() {
        return this.write_valid;
    }

    public void enable_audio_read(boolean enable) {
        this.audioFormat = this.createAudioFormat();
        this.target_mixer_index = this.parent.audio_input.get_value() - 1;
        this.read_enable = enable;
        if (enable) {
            this.audio_reader = new AudioInputReader(this, this.parent, 2);
            this.audio_reader.start();
        } else {
            try {
                if (this.audio_reader != null) {
                    this.read_enable = false;
                    this.audio_reader.join();
                    this.audio_reader = null;
                }
            }
            catch (InterruptedException e) {
                CommonCode.p("join audio thread: " + e);
                this.read_enable = false;
            }
        }
        this.enable_audio_write(enable && this.parent.monitor_volume.get_value() != 0);
    }

    private void close_source_line() {
        if (this.audioOutputLine != null) {
            this.audioOutputLine.flush();
            this.audioOutputLine.stop();
            this.audioOutputLine.close();
            this.audioOutputLine = null;
        }
    }

    private boolean open_source_line() {
        try {
            Mixer.Info mi;
            this.close_source_line();
            this.audioFormat = this.createAudioFormat();
            try {
                mi = this.source_mixer_list.get(this.new_index);
            }
            catch (Exception e) {
                System.out.println(e + ", proceeding with index 0");
                mi = this.source_mixer_list.get(0);
            }
            Mixer mixer = AudioSystem.getMixer(mi);
            this.audioOutputLine = (SourceDataLine)mixer.getLine(this.sourceLineInfo);
            this.audioOutputLine.open(this.audioFormat);
            this.audioOutputLine.start();
            return true;
        }
        catch (LineUnavailableException e) {
            this.audioOutputLine = null;
            System.out.println("open_source_line: " + e);
            return false;
        }
    }

    public void enable_audio_write(boolean enable) {
        this.new_index = this.parent.audio_output.get_value();
        if (this.new_index >= this.source_mixer_count) {
            this.new_index = 0;
        }
        if (enable && this.parent.monitor_volume.get_percent_value() != 0.0) {
            if (this.open_source_line()) {
                this.write_valid = true;
            }
        } else {
            this.write_valid = false;
            this.close_source_line();
        }
        this.source_mixer_index = this.new_index;
    }

    public void enable_audio_write_check() {
        boolean vol_state;
        boolean bl = vol_state = this.parent.monitor_volume.get_percent_value() != 0.0;
        if (this.read_valid && (vol_state != this.write_valid || this.parent.audio_output.get_value() != this.source_mixer_index)) {
            this.enable_audio_write(this.read_valid);
        }
    }

    public boolean reading() {
        return this.read_enable;
    }

    AudioFormat createAudioFormat() {
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = true;
        float rate = this.parent.data_rate.get_value();
        return new AudioFormat(rate, sampleSizeInBits, channels, signed, bigEndian);
    }

    public void write_output(short[] data) {
        double gain = this.parent.monitor_volume.get_percent_value();
        ByteBuffer byb = ByteBuffer.wrap(this.out_buffer);
        for (short sv : data) {
            byb.putShort((short)((double)sv * gain));
        }
        this.audioOutputLine.write(this.out_buffer, 0, this.out_buffer.length);
    }
}

