/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import jwx.AudioProcessor;
import jwx.CommonCode;
import jwx.JWX;

final class AudioInputReader
extends Thread {
    AudioProcessor audio_processor;
    JWX parent;
    TargetDataLine targetDataLine = null;
    double dv;
    final int mask = 255;
    short[] short_buf;
    byte[] byte_buf;
    int word_size;
    int avail;
    double restart_cycle_time_sec = 3600.0;

    public AudioInputReader(AudioProcessor ap, JWX p, int ws) {
        this.audio_processor = ap;
        this.parent = p;
        this.word_size = ws;
        this.byte_buf = new byte[this.audio_processor.bbufsz];
        this.short_buf = new short[this.audio_processor.sbufsz];
    }

    private boolean open_target_line() {
        block4: {
            try {
                Mixer.Info mi;
                if (this.targetDataLine != null) break block4;
                try {
                    int n = this.audio_processor.target_mixer_index;
                    mi = this.audio_processor.target_mixer_list.get(n);
                }
                catch (Exception e) {
                    System.out.println(e + ", proceeding with index 0");
                    mi = this.audio_processor.target_mixer_list.get(0);
                }
                Mixer mixer = AudioSystem.getMixer(mi);
                this.targetDataLine = (TargetDataLine)mixer.getLine(this.audio_processor.targetLineInfo);
                this.targetDataLine.open(this.audio_processor.audioFormat, this.audio_processor.bbufsz * 2);
                this.targetDataLine.start();
            }
            catch (LineUnavailableException e) {
                this.targetDataLine = null;
                CommonCode.p("open_target_line: " + e);
                this.audio_processor.read_valid = false;
                return false;
            }
        }
        return true;
    }

    private void close_target_line() {
        if (this.targetDataLine != null) {
            this.targetDataLine.stop();
            this.targetDataLine.close();
            this.targetDataLine = null;
        }
    }

    public void restart_stream_test() {
        if (this.parent.decode_fax.time_sec > this.parent.reset_target_time && !this.parent.decode_fax.receiving_fax()) {
            if (this.parent.debug) {
                CommonCode.p(this.getClass().getSimpleName() + ": restarting target audio line");
            }
            this.close_target_line();
            this.open_target_line();
            this.parent.reset_target_time = this.parent.decode_fax.time_sec + this.restart_cycle_time_sec;
        }
    }

    @Override
    public void run() {
        this.audio_processor.read_valid = true;
        this.audio_processor.read_enable = true;
        this.parent.reset_target_time = -1.0;
        this.restart_stream_test();
        try {
            while (this.targetDataLine != null && this.audio_processor.read_enable) {
                while (this.audio_processor.read_enable && (this.avail = this.targetDataLine.available()) < this.audio_processor.bbufsz && this.avail >= 0) {
                    Thread.sleep(20L);
                }
                if (this.audio_processor.read_enable) {
                    this.parent.audio_read = this.targetDataLine.read(this.byte_buf, 0, this.audio_processor.bbufsz);
                    if (this.parent.audio_read > 0) {
                        ShortBuffer sb = ByteBuffer.wrap(this.byte_buf).asShortBuffer();
                        sb.get(this.short_buf);
                        this.parent.decode_fax.process_data(this.short_buf);
                        if (this.audio_processor.write_valid) {
                            this.audio_processor.write_output(this.short_buf);
                        }
                    }
                }
                this.restart_stream_test();
            }
            this.close_target_line();
            this.audio_processor.read_valid = false;
        }
        catch (InterruptedException e) {
            CommonCode.p("audio input reader: " + e);
            this.close_target_line();
            this.audio_processor.read_valid = false;
        }
    }
}

